/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.AdminRoleP;
import org.apache.directory.fortress.core.impl.HierUtil;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.Hier;
import org.apache.directory.fortress.core.model.Relationship;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.util.cache.Cache;
import org.apache.directory.fortress.core.util.cache.CacheMgr;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AdminRoleUtil {
    private static final Cache adminRoleCache;
    private static final AdminRoleP adminRoleP;
    private static final String CLS_NM;
    private static final Logger LOG;

    private AdminRoleUtil() {
    }

    static boolean isParent(String child, String parent, String contextId) {
        boolean result = false;
        Set<String> parents = AdminRoleUtil.getAscendants(child, contextId);
        if (parents != null && parents.size() > 0) {
            result = parents.contains(parent.toUpperCase());
        }
        return result;
    }

    static Set<String> getDescendants(String roleName, String contextId) {
        return HierUtil.getDescendants(roleName, AdminRoleUtil.getGraph(contextId));
    }

    public static Set<String> getAscendants(String roleName, String contextId) {
        return HierUtil.getAscendants(roleName, AdminRoleUtil.getGraph(contextId));
    }

    static Set<String> getParents(String roleName, String contextId) {
        return HierUtil.getParents(roleName, AdminRoleUtil.getGraph(contextId));
    }

    public static Set<String> getChildren(String roleName, String contextId) {
        return HierUtil.getChildren(roleName, AdminRoleUtil.getGraph(contextId));
    }

    static int numChildren(String roleName, String contextId) {
        return HierUtil.numChildren(roleName, AdminRoleUtil.getGraph(contextId));
    }

    public static Set<String> getInheritedRoles(List<UserAdminRole> uRoles, String contextId) {
        TreeSet<String> iRoles = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (CollectionUtils.isNotEmpty(uRoles)) {
            for (UserAdminRole uRole : uRoles) {
                String rleName = uRole.getName();
                iRoles.add(rleName);
                Set<String> parents = HierUtil.getAscendants(rleName, AdminRoleUtil.getGraph(contextId));
                if (!CollectionUtils.isNotEmpty(parents)) continue;
                iRoles.addAll(parents);
            }
        }
        return iRoles;
    }

    static void validateRelationship(AdminRole childRole, AdminRole parentRole, boolean mustExist) throws ValidationException {
        HierUtil.validateRelationship(AdminRoleUtil.getGraph(childRole.getContextId()), childRole.getName(), parentRole.getName(), mustExist);
    }

    static void updateHier(String contextId, Relationship relationship, Hier.Op op) throws SecurityException {
        HierUtil.updateHier(AdminRoleUtil.getGraph(contextId), relationship, op);
    }

    private static synchronized SimpleDirectedGraph<String, Relationship> loadGraph(String contextId) {
        Hier inHier = new Hier(Hier.Type.ROLE);
        inHier.setContextId(contextId);
        LOG.info("loadGraph initializing ADMIN ROLE context [{}]", (Object)inHier.getContextId());
        List<Graphable> descendants = null;
        try {
            descendants = adminRoleP.getAllDescendants(inHier.getContextId());
        }
        catch (SecurityException se) {
            LOG.info("loadGraph caught SecurityException={}", (Throwable)se);
        }
        Hier hier = HierUtil.loadHier(contextId, descendants);
        SimpleDirectedGraph<String, Relationship> graph = HierUtil.buildGraph(hier);
        adminRoleCache.put(AdminRoleUtil.getKey(contextId), graph);
        return graph;
    }

    private static SimpleDirectedGraph<String, Relationship> getGraph(String contextId) {
        String key = AdminRoleUtil.getKey(contextId);
        LOG.debug("Getting graph for key " + contextId);
        SimpleDirectedGraph graph = (SimpleDirectedGraph)adminRoleCache.get(key);
        if (graph == null) {
            LOG.debug("Graph was null, creating... " + contextId);
            return AdminRoleUtil.loadGraph(contextId);
        }
        LOG.debug("Graph found in cache, returning...");
        return graph;
    }

    private static String getKey(String contextId) {
        String key = HierUtil.Type.ARLE.toString();
        if (StringUtils.isNotEmpty((String)contextId) && !contextId.equalsIgnoreCase("null")) {
            key = key + ":" + contextId;
        }
        return key;
    }

    static {
        adminRoleP = new AdminRoleP();
        CLS_NM = AdminRoleUtil.class.getName();
        LOG = LoggerFactory.getLogger((String)CLS_NM);
        CacheMgr cacheMgr = CacheMgr.getInstance();
        adminRoleCache = cacheMgr.getCache("fortress.admin.roles");
    }
}

