/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static InputStream getInputStream(String _reference) {
        InputStream result = null;
        if (null != _reference && null == (result = ResourceUtil.getInputStreamForFileAbsolutePath(_reference))) {
            result = ResourceUtil.getInputStreamForFileInClassLoaderResources(_reference);
        }
        return result;
    }

    public static InputStream getInputStreamForFileAbsolutePath(String _path) {
        File file;
        FileInputStream result = null;
        if (null != _path && (file = new File(_path)).exists() && file.isAbsolute() && !file.isDirectory()) {
            try {
                result = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    private static InputStream getInputStreamForFileInClassLoaderResources(String _reference) {
        InputStream result = null;
        URL url = ResourceUtil.class.getClassLoader().getResource(_reference);
        if (null != url) {
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getPath());
                if (file.exists() && !file.isDirectory()) {
                    try {
                        result = new FileInputStream(file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
            } else if (url.getProtocol().equals("jar") && null != (result = ResourceUtil.class.getClassLoader().getResourceAsStream(_reference))) {
                PushbackInputStream pushbackInputStream = new PushbackInputStream(result);
                int b = -1;
                try {
                    b = pushbackInputStream.read();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (b != -1) {
                    result = pushbackInputStream;
                    try {
                        pushbackInputStream.unread(b);
                    }
                    catch (IOException e) {
                        result = null;
                    }
                }
            }
        }
        return result;
    }
}

