/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)LogUtil.class.getName());

    private LogUtil() {
    }

    public static void logIt(String msg) {
        if (LOG.isDebugEnabled() || LOG.isInfoEnabled() || LOG.isWarnEnabled() || LOG.isErrorEnabled()) {
            if (StringUtils.isNotEmpty((String)LogUtil.getContext())) {
                msg = LogUtil.getContext() + " " + msg;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            } else if (LOG.isInfoEnabled()) {
                LOG.info(msg);
            } else if (LOG.isWarnEnabled()) {
                LOG.warn(msg);
            } else if (LOG.isErrorEnabled()) {
                LOG.error(msg);
            }
        }
    }

    public static String getContext() {
        String contextId = null;
        String tenant = System.getProperty("tenant");
        if (StringUtils.isNotEmpty((String)tenant) && !tenant.equals("${tenant}")) {
            contextId = tenant;
        }
        return contextId;
    }
}

