/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.PwMessage;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.model.Warning;

@XmlRootElement(name="fortSession")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="session", propOrder={"user", "group", "isAuthenticated", "isGroupSession", "sessionId", "lastAccess", "timeout", "errorId", "expirationSeconds", "graceLogins", "message", "warnings"})
public class Session
extends FortEntity
implements PwMessage,
Serializable {
    private static final long serialVersionUID = 1L;
    private User user;
    private Group group;
    private String sessionId;
    private long lastAccess;
    private int timeout;
    private int errorId;
    private int graceLogins;
    private int expirationSeconds;
    private boolean isAuthenticated;
    private boolean isGroupSession;
    private String message;
    private List<Warning> warnings;

    @Override
    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public boolean isGroupSession() {
        return this.isGroupSession;
    }

    private void init() {
        UUID uuid = UUID.randomUUID();
        this.sessionId = uuid.toString();
    }

    public void copy(Session inSession) {
        this.user = inSession.getUser();
        this.group = inSession.getGroup();
        this.lastAccess = inSession.getLastAccess();
        this.timeout = inSession.getTimeout();
        this.errorId = inSession.getErrorId();
        this.graceLogins = inSession.getGraceLogins();
        this.expirationSeconds = inSession.expirationSeconds;
        this.isAuthenticated = inSession.isAuthenticated();
        this.isGroupSession = inSession.isGroupSession();
        this.message = inSession.getMsg();
        this.warnings = inSession.getWarnings();
    }

    public Session() {
        this.init();
        this.user = new User();
        this.isGroupSession = false;
    }

    public Session(User user) {
        this.init();
        this.user = user;
        this.isGroupSession = false;
    }

    public Session(Group group) {
        this.init();
        this.group = group;
        this.isGroupSession = true;
    }

    public Session(User user, String sessionId) {
        this.sessionId = sessionId;
        this.user = user;
        this.isGroupSession = false;
    }

    public Session(Group group, String sessionId) {
        this.sessionId = sessionId;
        this.group = group;
        this.isGroupSession = true;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public User getUser() {
        return this.user;
    }

    public Group getGroup() {
        return this.group;
    }

    @Override
    public String getUserId() {
        return this.user.getUserId();
    }

    public String getGroupName() {
        return this.group.getName();
    }

    public String getInternalUserId() {
        return this.user.getInternalId();
    }

    public List<UserRole> getRoles() {
        List<UserRole> roles = null;
        if (this.isGroupSession && this.group != null) {
            roles = this.group.getRoles();
        }
        if (!this.isGroupSession && this.user != null) {
            roles = this.user.getRoles();
        }
        return roles;
    }

    public List<UserAdminRole> getAdminRoles() {
        List<UserAdminRole> roles = null;
        if (!this.isGroupSession && this.user != null) {
            roles = this.user.getAdminRoles();
        }
        return roles;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    @Override
    public String getMsg() {
        return this.message;
    }

    @Override
    public int getGraceLogins() {
        return this.graceLogins;
    }

    @Override
    public int getExpirationSeconds() {
        return this.expirationSeconds;
    }

    private int getTimeout() {
        return this.timeout;
    }

    public boolean setAuthenticated() {
        return this.isAuthenticated;
    }

    @Override
    public int getErrorId() {
        return this.errorId;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public void setInternalUserId(String internalUserId) {
        this.user.setInternalId(internalUserId);
    }

    @Override
    public void setAuthenticated(boolean authenticated) {
        this.isAuthenticated = authenticated;
    }

    public void setGroupSession(boolean isGroupSession) {
        this.isGroupSession = isGroupSession;
    }

    @Override
    public void setUserId(String userId) {
        this.user.setUserId(userId);
    }

    public void setGroupName(String groupName) {
        this.group.setName(groupName);
    }

    public void setRoles(List<UserRole> roles) {
        if (this.isGroupSession) {
            this.group.setRoles(roles);
        } else {
            this.user.setRoles(roles);
        }
    }

    public void setRole(UserRole role) {
        if (this.isGroupSession) {
            this.group.getRoles().add(role);
        } else {
            this.user.setRole(role);
        }
    }

    private void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setLastAccess() {
        this.lastAccess = System.currentTimeMillis();
    }

    @Override
    public void setMsg(String message) {
        this.message = message;
    }

    @Override
    public void setErrorId(int error) {
        this.errorId = error;
    }

    @Override
    public void setGraceLogins(int grace) {
        this.graceLogins = grace;
    }

    @Override
    public void setExpirationSeconds(int expire) {
        this.expirationSeconds = expire;
    }

    @Override
    public List<Warning> getWarnings() {
        return this.warnings;
    }

    @Override
    public void setWarnings(List<Warning> warnings) {
        this.warnings = warnings;
    }

    @Override
    public void setWarning(Warning warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<Warning>();
        }
        this.warnings.add(warning);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Session object: \n");
        sb.append("    sessionId :").append(this.sessionId).append('\n');
        if (this.isGroupSession) {
            sb.append("    group :").append(this.group).append('\n');
        } else {
            sb.append("    user :").append(this.user).append('\n');
        }
        sb.append("    isAuthenticated :").append(this.isAuthenticated).append('\n');
        sb.append("    lastAccess :").append(this.lastAccess).append('\n');
        sb.append("    timeout :").append(this.timeout).append('\n');
        sb.append("    graceLogins :").append(this.graceLogins).append('\n');
        sb.append("    expirationSeconds :").append(this.expirationSeconds).append('\n');
        sb.append("    errorId :").append(this.errorId).append('\n');
        sb.append("    message :").append(this.message).append('\n');
        if (this.warnings != null) {
            sb.append("    warnings : ");
            boolean isFirst = true;
            for (Warning warning : this.warnings) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(warning);
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

