/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Props;

@XmlRootElement(name="fortObject")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="permObj", propOrder={"objName", "description", "internalId", "ou", "type", "props", "admin"})
public class PermObj
extends FortEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean admin;
    private String internalId;
    private String objName;
    private String description;
    private Props props = new Props();
    private String ou;
    private String type;
    @XmlTransient
    private String dn;

    public PermObj() {
    }

    public PermObj(String objName) {
        this.objName = objName;
    }

    public PermObj(String objName, String ou) {
        this.objName = objName;
        this.ou = ou;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public void setInternalId() {
        UUID uuid = UUID.randomUUID();
        this.internalId = uuid.toString();
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Props getProps() {
        return this.props;
    }

    public void setProps(Props value) {
        this.props = value;
    }

    public void addProperty(String key, String value) {
        Props.Entry entry = new Props.Entry();
        entry.setKey(key);
        entry.setValue(value);
        this.props.getEntry().add(entry);
    }

    public String getProperty(String key) {
        List<Props.Entry> props = this.props.getEntry();
        Props.Entry keyObj = new Props.Entry();
        keyObj.setKey(key);
        String value = null;
        int indx = props.indexOf(keyObj);
        if (indx != -1) {
            Props.Entry entry = props.get(props.indexOf(keyObj));
            value = entry.getValue();
        }
        return value;
    }

    public void addProperties(Properties props) {
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = props.getProperty(key);
                this.addProperty(key, val);
            }
        }
    }

    public Properties getProperties() {
        Properties properties = null;
        List<Props.Entry> props = this.props.getEntry();
        if (props.size() > 0) {
            properties = new Properties();
            for (Props.Entry entry : props) {
                String key = entry.getKey();
                String val = entry.getValue();
                properties.setProperty(key, val);
            }
        }
        return properties;
    }

    public void setOu(String ou) {
        this.ou = ou;
    }

    public String getOu() {
        return this.ou;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getDn() {
        return this.dn;
    }

    public int hashCode() {
        int result = this.admin ? 1 : 0;
        result = 31 * result + (this.internalId != null ? this.internalId.hashCode() : 0);
        result = 31 * result + (this.objName != null ? this.objName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.props != null ? this.props.hashCode() : 0);
        result = 31 * result + (this.ou != null ? this.ou.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.dn != null ? this.dn.hashCode() : 0);
        return result;
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.getObjName() == null) {
            return false;
        }
        if (!(thatObj instanceof PermObj)) {
            return false;
        }
        PermObj thatPermObj = (PermObj)thatObj;
        if (thatPermObj.getObjName() == null) {
            return false;
        }
        return thatPermObj.getObjName().equalsIgnoreCase(this.getObjName());
    }

    public String toString() {
        return "Permission Object {name='" + this.objName + '\'' + '}';
    }
}

