/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.PasswordException;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.AdminRoleP;
import org.apache.directory.fortress.core.impl.OrgUnitP;
import org.apache.directory.fortress.core.impl.PermP;
import org.apache.directory.fortress.core.impl.PolicyP;
import org.apache.directory.fortress.core.impl.UserDAO;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.Administrator;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PwPolicy;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UserP {
    private static final String CLS_NM = UserP.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private UserDAO uDao = new UserDAO();
    private PolicyP policyP = new PolicyP();
    private AdminRoleP admRoleP = new AdminRoleP();
    private OrgUnitP orgUnitP = new OrgUnitP();

    UserP() {
    }

    List<User> search(User user) throws SecurityException {
        return this.uDao.findUsers(user);
    }

    List<User> search(OrgUnit ou, boolean limitSize) throws SecurityException {
        return this.uDao.findUsers(ou, limitSize);
    }

    List<String> search(User user, int limit) throws SecurityException {
        return this.uDao.findUsers(user, limit);
    }

    List<User> getAuthorizedUsers(Role role) throws SecurityException {
        return this.uDao.getAuthorizedUsers(role);
    }

    Set<String> getAssignedUsers(Set<String> roles, String contextId) throws SecurityException {
        return this.uDao.getAssignedUsers(roles, contextId);
    }

    List<String> getAuthorizedUsers(Role role, int limit) throws SecurityException {
        return this.uDao.getAuthorizedUsers(role, limit);
    }

    List<User> getAssignedUsers(Role role) throws SecurityException {
        return this.uDao.getAssignedUsers(role, null);
    }

    List<User> getAssignedUsers(Role role, RoleConstraint roleConstraint) throws SecurityException {
        return this.uDao.getAssignedUsers(role, roleConstraint);
    }

    List<UserRole> getAssignedUsers(Role role, RoleConstraint.RCType rcType, String paSetName) throws SecurityException {
        return this.uDao.getUserRoles(role, rcType, paSetName);
    }

    List<String> getAssignedUserIds(Role role) throws SecurityException {
        return this.uDao.getAssignedUserIds(role);
    }

    List<User> getAssignedUsers(AdminRole role) throws SecurityException {
        return this.uDao.getAssignedUsers(role);
    }

    List<String> getAssignedRoles(User user) throws SecurityException {
        return this.uDao.getRoles(user);
    }

    User read(User user, boolean isRoles) throws SecurityException {
        return this.uDao.getUser(user, isRoles);
    }

    User add(User entity) throws SecurityException {
        return this.add(entity, true);
    }

    User add(User entity, boolean validate) throws SecurityException {
        if (validate) {
            this.validate(entity, false);
        }
        entity = this.uDao.create(entity);
        return entity;
    }

    User update(User entity) throws SecurityException {
        return this.update(entity, true);
    }

    User update(User entity, boolean validate) throws SecurityException {
        if (validate) {
            this.validate(entity, true);
        }
        entity = this.uDao.update(entity);
        return entity;
    }

    String softDelete(User user) throws SecurityException {
        User checkUser = this.read(user, true);
        if (checkUser.isSystem() != null && checkUser.isSystem().booleanValue()) {
            String warning = "softDelete userId [" + user.getUserId() + "] can't be removed due to policy violation, rc=" + 1011;
            throw new SecurityException(1011, warning);
        }
        user.setDescription("DELETED");
        User outUser = this.uDao.update(user);
        return outUser.getDn();
    }

    String delete(User user) throws SecurityException {
        User checkUser = this.read(user, true);
        if (checkUser.isSystem() != null && checkUser.isSystem().booleanValue()) {
            String warning = "delete userId [" + user.getUserId() + "] can't be removed due to policy violation, rc=" + 1011;
            throw new SecurityException(1011, warning);
        }
        return this.uDao.remove(user);
    }

    void deletePwPolicy(User user) throws SecurityException {
        this.uDao.deletePwPolicy(user);
    }

    Session authenticate(User user) throws SecurityException {
        Session session = this.uDao.checkPassword(user);
        if (!session.isAuthenticated()) {
            String info = "UserP.authenticate failed  for userId [" + user.getUserId() + "] reason code [" + session.getErrorId() + "] msg [" + session.getMsg() + "]";
            throw new PasswordException(session.getErrorId(), info);
        }
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.USER, false);
        return session;
    }

    Session createSession(User user, boolean trusted) throws SecurityException {
        Session session;
        if (trusted) {
            session = this.createSessionTrusted(user);
            VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.USER, false);
        } else {
            VUtil.assertNotNullOrEmpty(user.getPassword(), 1009, CLS_NM + ".createSession");
            session = this.createSession(user);
        }
        session.setContextId(user.getContextId());
        if (CollectionUtils.isNotEmpty(user.getRoles())) {
            List<UserRole> rlsActual = session.getRoles();
            ArrayList<UserRole> rlsFinal = new ArrayList<UserRole>();
            session.setRoles(rlsFinal);
            for (UserRole role : user.getRoles()) {
                int indx = rlsActual.indexOf(role);
                if (indx == -1) continue;
                UserRole candidateRole = rlsActual.get(indx);
                rlsFinal.add(candidateRole);
            }
        }
        if (user.getProps() != null) {
            session.getUser().addProperties(user.getProperties());
        }
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.ROLE, true);
        return session;
    }

    Session createSession(User user, List<RoleConstraint> constraints, boolean trusted) throws SecurityException {
        Properties props = new Properties();
        for (RoleConstraint constraint : constraints) {
            VUtil.assertNotNullOrEmpty(constraint.getKey(), 5103, CLS_NM + ".createSession");
            VUtil.assertNotNullOrEmpty(constraint.getValue(), 5101, CLS_NM + ".createSession");
            props.setProperty(constraint.getKey(), constraint.getValue());
        }
        user.addProperties(props);
        return this.createSession(user, trusted);
    }

    private Session createSession(User inUser) throws SecurityException {
        User user = this.read(inUser, true);
        user.setContextId(inUser.getContextId());
        Session session = this.authenticate(inUser);
        session.setUser(user);
        return session;
    }

    private Session createSessionTrusted(User inUser) throws SecurityException {
        User user = this.read(inUser, true);
        user.setContextId(inUser.getContextId());
        if (user.isLocked()) {
            String warning = "createSession failed for userId [" + inUser.getUserId() + "] reason user is locked";
            LOG.warn(warning);
            throw new SecurityException(1028, warning);
        }
        Session session = new ObjectFactory().createSession();
        session.setUserId(inUser.getUserId());
        session.setAuthenticated(false);
        session.setUser(user);
        return session;
    }

    void lock(User user) throws SecurityException {
        this.uDao.lock(user);
    }

    void unlock(User user) throws SecurityException {
        this.uDao.unlock(user);
    }

    void changePassword(User entity, String newPassword) throws SecurityException {
        String userId = entity.getUserId();
        boolean result = this.uDao.changePassword(entity, newPassword);
        if (!result) {
            LOG.warn("changePassword failed for user [{}]", (Object)userId);
        }
    }

    void resetPassword(User user) throws SecurityException {
        this.uDao.resetUserPassword(user);
    }

    String assign(UserRole uRole) throws SecurityException {
        this.validate(uRole);
        return this.uDao.assign(uRole);
    }

    void assign(UserRole uRole, RoleConstraint roleConstraint) throws SecurityException {
        this.validate(roleConstraint, uRole.getContextId());
        this.uDao.assign(uRole, roleConstraint);
    }

    void deassign(UserRole uRole, RoleConstraint roleConstraint) throws SecurityException {
        this.uDao.deassign(uRole, roleConstraint);
    }

    String deassign(UserRole uRole) throws SecurityException {
        this.validate(uRole);
        return this.uDao.deassign(uRole);
    }

    String assign(UserAdminRole uRole) throws SecurityException {
        this.validate(uRole);
        return this.uDao.assign(uRole);
    }

    String deassign(UserAdminRole uRole) throws SecurityException {
        this.validate(uRole);
        return this.uDao.deassign(uRole);
    }

    private void validate(UserRole uRole) throws ValidationException {
        if (StringUtils.isEmpty((String)uRole.getUserId())) {
            throw new ValidationException(1006, CLS_NM + ".validate userId is NULL");
        }
        if (StringUtils.isEmpty((String)uRole.getName())) {
            throw new ValidationException(5005, CLS_NM + ".validate name is NULL");
        }
    }

    private void validate(RoleConstraint rc, String contextId) throws ValidationException {
        if (rc.getType() != RoleConstraint.RCType.USER) {
            if (StringUtils.isEmpty((String)rc.getKey())) {
                throw new ValidationException(3036, CLS_NM + ".validate pa set name is NULL");
            }
            try {
                PermP permP = new PermP();
                permP.validatePaSet(rc.getKey(), contextId);
            }
            catch (SecurityException e) {
                String error = "validate - paSetName not found with name [" + rc.getKey() + "] caught SecurityException=" + e;
                throw new ValidationException(3035, error);
            }
        }
        if (rc.getType() == null) {
            throw new ValidationException(5100, CLS_NM + ".validate type is NULL");
        }
        if (StringUtils.isEmpty((String)rc.getValue())) {
            throw new ValidationException(5101, CLS_NM + ".validate value is NULL");
        }
    }

    private void validate(User entity, boolean isUpdate) throws SecurityException {
        OrgUnit ou;
        if (!isUpdate) {
            VUtil.userId(entity.getUserId());
            if (StringUtils.isNotEmpty((String)entity.getCn())) {
                VUtil.safeText(entity.getCn(), 80);
            }
            if (StringUtils.isNotEmpty((String)entity.getSn())) {
                VUtil.safeText(entity.getSn(), 80);
            }
            if (StringUtils.isNotEmpty((String)entity.getPassword())) {
                VUtil.safeText(entity.getPassword(), 50);
            }
            if (StringUtils.isEmpty((String)entity.getOu())) {
                String error = "OU validation failed, null or empty value";
                throw new ValidationException(8018, error);
            }
            VUtil.orgUnit(entity.getOu());
            ou = new OrgUnit(entity.getOu(), OrgUnit.Type.USER);
            ou.setContextId(entity.getContextId());
            if (!this.orgUnitP.isValid(ou)) {
                String error = "validate detected invalid orgUnit name [" + entity.getOu() + "] adding user with userId [" + entity.getUserId() + "]";
                throw new ValidationException(1035, error);
            }
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                VUtil.description(entity.getDescription());
            }
        } else {
            if (StringUtils.isNotEmpty((String)entity.getCn())) {
                VUtil.safeText(entity.getCn(), 80);
            }
            if (StringUtils.isNotEmpty((String)entity.getSn())) {
                VUtil.safeText(entity.getSn(), 80);
            }
            if (StringUtils.isNotEmpty((String)entity.getPassword())) {
                VUtil.safeText(entity.getPassword(), 50);
            }
            if (StringUtils.isNotEmpty((String)entity.getOu())) {
                VUtil.orgUnit(entity.getOu());
                ou = new OrgUnit(entity.getOu(), OrgUnit.Type.USER);
                ou.setContextId(entity.getContextId());
                if (!this.orgUnitP.isValid(ou)) {
                    String error = "validate detected invalid orgUnit name [" + entity.getOu() + "] updating user wth userId [" + entity.getUserId() + "]";
                    throw new ValidationException(1035, error);
                }
            }
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                VUtil.description(entity.getDescription());
            }
        }
        if (StringUtils.isNotEmpty((String)entity.getPwPolicy()) && (Config.getInstance().isOpenldap() || Config.getInstance().isApacheds())) {
            PwPolicy policy = new PwPolicy(entity.getPwPolicy());
            policy.setContextId(entity.getContextId());
            if (!this.policyP.isValid(policy)) {
                String error = "validate detected invalid OpenLDAP policy name [" + entity.getPwPolicy() + "] for userId [" + entity.getUserId() + "]. Assignment is optional for User but must be valid if specified.";
                throw new ValidationException(1034, error);
            }
        }
        ConstraintUtil.validate(entity);
    }

    void copyAdminAttrs(Administrator srcR, Administrator trgR) {
        trgR.setBeginInclusive(srcR.isBeginInclusive());
        trgR.setEndInclusive(srcR.isEndInclusive());
        trgR.setBeginRange(srcR.getBeginRange());
        trgR.setEndRange(srcR.getEndRange());
        trgR.setOsPSet(srcR.getOsPSet());
        trgR.setOsUSet(srcR.getOsUSet());
    }

    List<RoleConstraint> findRoleConstraints(Set<String> roles, User user, RoleConstraint.RCType rcType, Set<String> paSets) throws SecurityException {
        ArrayList<RoleConstraint> matchingConstraints = new ArrayList<RoleConstraint>();
        List<UserRole> userRoles = this.uDao.getUser(user, true).getRoles();
        for (UserRole ur : userRoles) {
            if (!roles.contains(ur.getName())) continue;
            for (RoleConstraint rc : ur.getRoleConstraints()) {
                if (!rc.getType().equals((Object)rcType) || !paSets.contains(rc.getKey())) continue;
                matchingConstraints.add(rc);
            }
        }
        return matchingConstraints;
    }
}

