/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.directory.fortress.annotation.AdminPermissionOperation;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.impl.PermP;
import org.apache.directory.fortress.core.impl.RoleP;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.impl.SdP;
import org.apache.directory.fortress.core.impl.UserP;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.PermissionAttributeSet;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public class ReviewMgrImpl
extends Manageable
implements ReviewMgr,
Serializable {
    private static final String CLS_NM = ReviewMgrImpl.class.getName();
    private UserP userP = new UserP();
    private RoleP roleP = new RoleP();
    private PermP permP = new PermP();
    private SdP ssdP = new SdP();

    @Override
    @AdminPermissionOperation
    public Permission readPermission(Permission permission) throws SecurityException {
        String methodName = "readPermission";
        this.assertContext(CLS_NM, methodName, permission, 3009);
        VUtil.assertNotNullOrEmpty(permission.getObjName(), 3027, CLS_NM + "." + methodName);
        VUtil.assertNotNullOrEmpty(permission.getOpName(), 3026, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        return this.permP.read(permission);
    }

    @Override
    @AdminPermissionOperation
    public PermObj readPermObj(PermObj permObj) throws SecurityException {
        String methodName = "readPermObj";
        this.assertContext(CLS_NM, methodName, permObj, 3010);
        VUtil.assertNotNull(permObj.getObjName(), 3027, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        return this.permP.read(permObj);
    }

    @Override
    @AdminPermissionOperation
    public PermissionAttributeSet readPermAttributeSet(PermissionAttributeSet permAttributeSet) throws SecurityException {
        String methodName = "readPermAttributeSet";
        this.assertContext(CLS_NM, methodName, permAttributeSet, 3030);
        VUtil.assertNotNull(permAttributeSet.getName(), 3036, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        return this.permP.read(permAttributeSet);
    }

    @Override
    @AdminPermissionOperation
    public List<Permission> findPermissions(Permission permission) throws SecurityException {
        String methodName = "findPermissions";
        this.assertContext(CLS_NM, methodName, permission, 3009);
        this.checkAccess(CLS_NM, methodName);
        return this.permP.search(permission);
    }

    @Override
    @AdminPermissionOperation
    public List<Permission> findPermsByObj(PermObj permObj) throws SecurityException {
        String methodName = "findPermsByObj";
        this.assertContext(CLS_NM, methodName, permObj, 3010);
        VUtil.assertNotNullOrEmpty(permObj.getObjName(), 3027, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        return this.permP.searchOperations(permObj);
    }

    @Override
    @AdminPermissionOperation
    public List<Permission> findAnyPermissions(Permission permission) throws SecurityException {
        String methodName = "findAnyPermissions";
        this.assertContext(CLS_NM, methodName, permission, 3009);
        this.checkAccess(CLS_NM, methodName);
        return this.permP.searchAny(permission);
    }

    @Override
    @AdminPermissionOperation
    public List<PermObj> findPermObjs(PermObj permObj) throws SecurityException {
        String methodName = "findPermObjs";
        this.assertContext(CLS_NM, methodName, permObj, 3010);
        this.checkAccess(CLS_NM, methodName);
        return this.permP.search(permObj);
    }

    @Override
    @AdminPermissionOperation
    public List<PermObj> findPermObjs(OrgUnit ou) throws SecurityException {
        String methodName = "findPermObjs";
        this.assertContext(CLS_NM, methodName, ou, 8068);
        this.checkAccess(CLS_NM, methodName);
        return this.permP.search(ou, false);
    }

    @Override
    @AdminPermissionOperation
    public Role readRole(Role role) throws SecurityException {
        String methodName = "readRole";
        this.assertContext(CLS_NM, methodName, role, 5007);
        VUtil.assertNotNullOrEmpty(role.getName(), 5005, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        return this.roleP.read(role);
    }

    @Override
    @AdminPermissionOperation
    public List<Role> findRoles(String searchVal) throws SecurityException {
        String methodName = "findRoles";
        VUtil.assertNotNull(searchVal, 5005, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        Role role = new Role(searchVal);
        role.setContextId(this.contextId);
        return this.roleP.search(role);
    }

    @Override
    @AdminPermissionOperation
    public List<String> findRoles(String searchVal, int limit) throws SecurityException {
        String methodName = "findRoles";
        VUtil.assertNotNull(searchVal, 5005, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        Role role = new Role(searchVal);
        role.setContextId(this.contextId);
        return this.roleP.search(role, limit);
    }

    @Override
    @AdminPermissionOperation
    public final User readUser(User user) throws SecurityException {
        String methodName = "readUser";
        this.assertContext(CLS_NM, methodName, user, 1008);
        VUtil.assertNotNullOrEmpty(user.getUserId(), 1006, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        return this.userP.read(user, true);
    }

    @Override
    @AdminPermissionOperation
    public final List<User> findUsers(User user) throws SecurityException {
        String methodName = "findUsers";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.checkAccess(CLS_NM, methodName);
        return this.userP.search(user);
    }

    @Override
    @AdminPermissionOperation
    public List<User> findUsers(OrgUnit ou) throws SecurityException {
        String methodName = "findUsers";
        this.assertContext(CLS_NM, methodName, ou, 8018);
        this.checkAccess(CLS_NM, methodName);
        return this.userP.search(ou, false);
    }

    @Override
    @AdminPermissionOperation
    public final List<String> findUsers(User user, int limit) throws SecurityException {
        String methodName = "findUsers";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.checkAccess(CLS_NM, methodName);
        return this.userP.search(user, limit);
    }

    @Override
    @AdminPermissionOperation
    public List<String> assignedUsers(Role role, int limit) throws SecurityException {
        String methodName = "assignedUsers";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.checkAccess(CLS_NM, methodName);
        List<String> users = null;
        if (Config.getInstance().isRoleOccupant()) {
            Role entity = this.roleP.read(role);
            users = entity.getOccupants();
            if (users != null && users.size() > limit) {
                users = users.subList(0, limit);
            }
        } else {
            users = this.userP.getAssignedUserIds(role);
        }
        if (users == null) {
            users = new ArrayList<String>();
        }
        return users;
    }

    @Override
    @AdminPermissionOperation
    public List<User> assignedUsers(Role role) throws SecurityException {
        String methodName = "assignedUsers";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.checkAccess(CLS_NM, methodName);
        return this.userP.getAssignedUsers(role);
    }

    @Override
    @AdminPermissionOperation
    public List<User> assignedUsers(Role role, RoleConstraint roleConstraint) throws SecurityException {
        String methodName = "assignedUsers";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.checkAccess(CLS_NM, methodName);
        return this.userP.getAssignedUsers(role, roleConstraint);
    }

    @Override
    @AdminPermissionOperation
    public List<UserRole> assignedUsers(Role role, RoleConstraint.RCType rcType, String keyName) throws SecurityException {
        String methodName = "assignedUsers";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.checkAccess(CLS_NM, methodName);
        return this.userP.getAssignedUsers(role, rcType, keyName);
    }

    @Override
    @AdminPermissionOperation
    public List<UserRole> assignedRoles(User user) throws SecurityException {
        String methodName = "assignedRoles";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.checkAccess(CLS_NM, methodName);
        User ue = this.userP.read(user, true);
        return ue.getRoles();
    }

    @Override
    @AdminPermissionOperation
    public List<String> assignedRoles(String userId) throws SecurityException {
        String methodName = "assignedRoles";
        VUtil.assertNotNullOrEmpty(userId, 1008, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        User user = new User(userId);
        user.setContextId(this.contextId);
        return this.userP.getAssignedRoles(user);
    }

    @Override
    @AdminPermissionOperation
    public List<User> authorizedUsers(Role role) throws SecurityException {
        String methodName = "authorizedUsers";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.checkAccess(CLS_NM, methodName);
        return this.userP.getAuthorizedUsers(role);
    }

    @Override
    @AdminPermissionOperation
    public Set<String> authorizedRoles(User user) throws SecurityException {
        String methodName = "authorizedRoles";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.checkAccess(CLS_NM, methodName);
        User ue = this.userP.read(user, true);
        List<UserRole> roles = ue.getRoles();
        Set<String> iRoles = null;
        if (CollectionUtils.isNotEmpty(roles)) {
            iRoles = RoleUtil.getInstance().getInheritedRoles(roles, this.contextId);
        }
        return iRoles;
    }

    @Override
    public List<Permission> rolePermissions(Role role) throws SecurityException {
        return this.rolePermissions(role, false);
    }

    @Override
    @AdminPermissionOperation
    public List<Permission> rolePermissions(Role role, boolean noInheritance) throws SecurityException {
        String methodName = "rolePermissions";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.checkAccess(CLS_NM, methodName);
        return this.permP.search(role, noInheritance);
    }

    @Override
    public List<PermissionAttributeSet> rolePermissionAttributeSets(Role role, boolean noInhertiance) throws SecurityException {
        HashMap<String, PermissionAttributeSet> permAttributeSets = new HashMap<String, PermissionAttributeSet>();
        List<Permission> permissions = this.rolePermissions(role, noInhertiance);
        for (Permission perm : permissions) {
            if (!CollectionUtils.isNotEmpty(perm.getPaSets())) continue;
            for (String paSetName : perm.getPaSets()) {
                if (permAttributeSets.containsKey(paSetName)) continue;
                PermissionAttributeSet paSet = new PermissionAttributeSet(paSetName);
                paSet.setContextId(this.contextId);
                PermissionAttributeSet permAttributeSet = this.permP.read(paSet);
                permAttributeSets.put(paSetName, permAttributeSet);
            }
        }
        return new ArrayList<PermissionAttributeSet>(permAttributeSets.values());
    }

    @Override
    @AdminPermissionOperation
    public List<Permission> userPermissions(User user) throws SecurityException {
        String methodName = "userPermissions";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.checkAccess(CLS_NM, methodName);
        user = this.readUser(user);
        user.setContextId(this.contextId);
        return this.permP.search(user);
    }

    @Override
    @AdminPermissionOperation
    public List<String> permissionRoles(Permission perm) throws SecurityException {
        String methodName = "permissionRoles";
        this.assertContext(CLS_NM, methodName, perm, 3010);
        this.checkAccess(CLS_NM, methodName);
        Permission pe = this.permP.read(perm);
        ArrayList<String> retVals = pe != null && CollectionUtils.isNotEmpty(pe.getRoles()) ? new ArrayList<String>(pe.getRoles()) : new ArrayList<String>();
        return retVals;
    }

    @Override
    @AdminPermissionOperation
    public Set<String> authorizedPermissionRoles(Permission perm) throws SecurityException {
        String methodName = "authorizedPermissionRoles";
        this.assertContext(CLS_NM, methodName, perm, 3009);
        this.checkAccess(CLS_NM, methodName);
        Permission pe = this.permP.read(perm);
        Set<String> authorizedRoles = this.authorizeRoles(pe.getRoles());
        return authorizedRoles;
    }

    @Override
    @AdminPermissionOperation
    public List<String> permissionUsers(Permission perm) throws SecurityException {
        String methodName = "permissionUsers";
        this.assertContext(CLS_NM, methodName, perm, 3009);
        this.checkAccess(CLS_NM, methodName);
        Permission pe = this.permP.read(perm);
        ArrayList<String> retVals = pe != null && CollectionUtils.isNotEmpty(pe.getUsers()) ? new ArrayList<String>(pe.getUsers()) : new ArrayList<String>();
        return retVals;
    }

    @Override
    @AdminPermissionOperation
    public Set<String> authorizedPermissionUsers(Permission perm) throws SecurityException {
        Set<String> assignedUsers;
        Set<String> authorizedUsers = null;
        String methodName = "authorizedPermissionUsers";
        this.assertContext(CLS_NM, methodName, perm, 3009);
        this.checkAccess(CLS_NM, methodName);
        Permission pe = this.permP.read(perm);
        Set<String> authorizedRoles = this.authorizeRoles(pe.getRoles());
        if (authorizedRoles != null) {
            authorizedUsers = this.userP.getAssignedUsers(authorizedRoles, this.contextId);
        }
        if ((assignedUsers = pe.getUsers()) != null) {
            if (authorizedUsers == null) {
                authorizedUsers = new HashSet<String>();
            }
            authorizedUsers.addAll(assignedUsers);
        }
        return authorizedUsers;
    }

    private Set<String> authorizeRoles(Set<String> assignedRoles) {
        Set<String> authorizedRoles = null;
        if (assignedRoles != null) {
            authorizedRoles = RoleUtil.getInstance().getDescendantRoles(assignedRoles, this.contextId);
        }
        return authorizedRoles;
    }

    @Override
    @AdminPermissionOperation
    public List<SDSet> ssdRoleSets(Role role) throws SecurityException {
        String methodName = "ssdRoleSets";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.checkAccess(CLS_NM, methodName);
        return this.ssdP.search(role, SDSet.SDType.STATIC);
    }

    @Override
    @AdminPermissionOperation
    public List<SDSet> ssdSets(SDSet ssd) throws SecurityException {
        String methodName = "ssdSets";
        ssd.setType(SDSet.SDType.STATIC);
        this.assertContext(CLS_NM, methodName, ssd, 5087);
        this.checkAccess(CLS_NM, methodName);
        return this.ssdP.search(ssd);
    }

    @Override
    @AdminPermissionOperation
    public SDSet ssdRoleSet(SDSet set) throws SecurityException {
        String methodName = "ssdRoleSet";
        this.assertContext(CLS_NM, methodName, set, 5087);
        this.checkAccess(CLS_NM, methodName);
        set.setType(SDSet.SDType.STATIC);
        return this.ssdP.read(set);
    }

    @Override
    @AdminPermissionOperation
    public Set<String> ssdRoleSetRoles(SDSet ssd) throws SecurityException {
        String methodName = "ssdRoleSetRoles";
        this.assertContext(CLS_NM, methodName, ssd, 5087);
        this.checkAccess(CLS_NM, methodName);
        ssd.setType(SDSet.SDType.STATIC);
        SDSet se = this.ssdP.read(ssd);
        return se.getMembers();
    }

    @Override
    @AdminPermissionOperation
    public int ssdRoleSetCardinality(SDSet ssd) throws SecurityException {
        String methodName = "ssdRoleSetCardinality";
        this.assertContext(CLS_NM, methodName, ssd, 5087);
        this.checkAccess(CLS_NM, methodName);
        SDSet se = this.ssdP.read(ssd);
        return se.getCardinality();
    }

    @Override
    @AdminPermissionOperation
    public List<SDSet> dsdRoleSets(Role role) throws SecurityException {
        String methodName = "dsdRoleSets";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.checkAccess(CLS_NM, methodName);
        return this.ssdP.search(role, SDSet.SDType.DYNAMIC);
    }

    @Override
    @AdminPermissionOperation
    public SDSet dsdRoleSet(SDSet set) throws SecurityException {
        String methodName = "dsdRoleSet";
        this.assertContext(CLS_NM, methodName, set, 5096);
        this.checkAccess(CLS_NM, methodName);
        set.setType(SDSet.SDType.DYNAMIC);
        return this.ssdP.read(set);
    }

    @Override
    @AdminPermissionOperation
    public List<SDSet> dsdSets(SDSet ssd) throws SecurityException {
        String methodName = "dsdSets";
        ssd.setType(SDSet.SDType.DYNAMIC);
        this.assertContext(CLS_NM, methodName, ssd, 5096);
        this.checkAccess(CLS_NM, methodName);
        return this.ssdP.search(ssd);
    }

    @Override
    @AdminPermissionOperation
    public Set<String> dsdRoleSetRoles(SDSet dsd) throws SecurityException {
        String methodName = "dsdRoleSetRoles";
        this.assertContext(CLS_NM, methodName, dsd, 5096);
        this.checkAccess(CLS_NM, methodName);
        dsd.setType(SDSet.SDType.DYNAMIC);
        SDSet se = this.ssdP.read(dsd);
        return se.getMembers();
    }

    @Override
    @AdminPermissionOperation
    public int dsdRoleSetCardinality(SDSet dsd) throws SecurityException {
        String methodName = "dsdRoleSetCardinality";
        this.assertContext(CLS_NM, methodName, dsd, 5096);
        this.checkAccess(CLS_NM, methodName);
        SDSet se = this.ssdP.read(dsd);
        return se.getCardinality();
    }

    @Override
    @AdminPermissionOperation
    public List<RoleConstraint> findRoleConstraints(User user, Permission permission, RoleConstraint.RCType rcType) throws SecurityException {
        String methodName = "findRoleConstraints";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.assertContext(CLS_NM, methodName, permission, 3008);
        this.checkAccess(CLS_NM, methodName);
        Permission pe = this.permP.read(permission);
        Set<String> authorizedRoles = this.authorizeRoles(pe.getRoles());
        return this.userP.findRoleConstraints(authorizedRoles, user, rcType, pe.getPaSets());
    }
}

