/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.directory.api.util.Strings;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.GroupDAO;
import org.apache.directory.fortress.core.impl.RoleP;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.VUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GroupP {
    private static final String CLS_NM = GroupP.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private GroupDAO gDao = new GroupDAO();

    GroupP() {
    }

    Group add(Group group) throws SecurityException {
        this.validate(group);
        Group outGroup = this.gDao.create(group);
        this.fillRoles(outGroup);
        return outGroup;
    }

    Group update(Group group) throws SecurityException {
        this.validate(group);
        return this.gDao.update(group);
    }

    Group delete(Group group) throws SecurityException {
        return this.gDao.remove(group);
    }

    Group add(Group group, String key, String value) throws SecurityException {
        return this.gDao.add(group, key, value);
    }

    Group delete(Group group, String key, String value) throws SecurityException {
        return this.gDao.delete(group, key, value);
    }

    Group assign(Group entity, String userDn) throws SecurityException {
        Group group = this.read(entity);
        group.setContextId(entity.getContextId());
        return this.gDao.assign(group, userDn);
    }

    Group deassign(Group entity, String userDn) throws SecurityException {
        Group group = this.read(entity);
        group.setContextId(entity.getContextId());
        return this.gDao.deassign(group, userDn);
    }

    Group read(Group group) throws SecurityException {
        Group outGroup = this.gDao.get(group);
        outGroup.setContextId(group.getContextId());
        this.fillRoles(outGroup);
        return outGroup;
    }

    List<Group> search(Group group) throws SecurityException {
        return this.gDao.find(group);
    }

    List<Group> search(User user) throws SecurityException {
        return this.gDao.find(user);
    }

    List<Group> roleGroups(Role role) throws SecurityException {
        return this.gDao.roleGroups(role);
    }

    List<UserRole> groupRoles(Group group) throws SecurityException {
        Group outGroup = this.read(group);
        this.fillRoles(outGroup);
        return outGroup.getRoles();
    }

    Session createSession(Group group) throws SecurityException {
        Session session = this.createSessionTrusted(group);
        if (CollectionUtils.isNotEmpty(group.getMembers())) {
            List<String> availableRoles = session.getGroup().getMembers();
            availableRoles.retainAll(group.getMembers());
        }
        this.fillRoles(session.getGroup());
        VUtil.getInstance().validateConstraints(session, VUtil.ConstraintType.ROLE, true);
        return session;
    }

    private Session createSessionTrusted(Group inGroup) throws SecurityException {
        Group group = this.read(inGroup);
        group.setContextId(inGroup.getContextId());
        if (group.getType() != Group.Type.ROLE) {
            String info = "createSession failed for Group [" + group.getName() + "], group must be of type ROLE.";
            throw new ValidationException(10314, info);
        }
        Session session = new Session(group);
        session.setAuthenticated(false);
        return session;
    }

    private void fillRoles(Group group) throws SecurityException {
        if (Group.Type.ROLE.equals((Object)group.getType())) {
            RoleP rp = new RoleP();
            ArrayList<UserRole> uRoles = new ArrayList<UserRole>();
            List<Role> roles = rp.search(group);
            for (Role inRole : roles) {
                UserRole ure = new UserRole(group.getName(), inRole.getName(), true);
                ConstraintUtil.validateOrCopy(inRole, ure);
                uRoles.add(ure);
            }
            group.setRoles(uRoles);
        }
    }

    private void validate(Group entity) throws SecurityException {
        if (Strings.isEmpty((String)entity.getName())) {
            String error = "validate name validation failed, null or empty value";
            LOG.warn(error);
            throw new ValidationException(10311, error);
        }
        if (entity.getName().length() > 40) {
            String name = entity.getName();
            String error = "validate name [" + name + "] invalid length [" + entity.getName().length() + "]";
            LOG.warn(error);
            throw new ValidationException(10312, error);
        }
        if (entity.getProtocol().length() > 40) {
            String error = "validate protocol [" + entity.getProtocol() + "] invalid length [" + entity.getProtocol().length() + "]";
            LOG.warn(error);
            throw new ValidationException(10313, error);
        }
        if (!Strings.isEmpty((String)entity.getDescription())) {
            VUtil.description(entity.getDescription());
        }
    }
}

