/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.directory.fortress.annotation.AdminPermissionOperation;
import org.apache.directory.fortress.core.GroupMgr;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.ReviewMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.GroupP;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.impl.SDUtil;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;

public class GroupMgrImpl
extends Manageable
implements GroupMgr,
Serializable {
    private static final String CLS_NM = GroupMgrImpl.class.getName();
    private GroupP groupP = new GroupP();

    @Override
    @AdminPermissionOperation
    public Group add(Group group) throws SecurityException {
        String methodName = "add";
        this.assertContext(CLS_NM, methodName, group, 10308);
        this.checkAccess(CLS_NM, methodName);
        if (!group.isMemberDn()) {
            if (group.getType() == Group.Type.ROLE) {
                this.loadRoleDns(group);
            } else {
                this.loadUserDns(group);
            }
            group.setMemberDn(true);
        }
        return this.groupP.add(group);
    }

    @Override
    @AdminPermissionOperation
    public Group update(Group group) throws SecurityException {
        String methodName = "update";
        this.assertContext(CLS_NM, methodName, group, 10308);
        this.checkAccess(CLS_NM, methodName);
        return this.groupP.update(group);
    }

    @Override
    @AdminPermissionOperation
    public Group delete(Group group) throws SecurityException {
        String methodName = "delete";
        this.assertContext(CLS_NM, methodName, group, 10308);
        this.checkAccess(CLS_NM, methodName);
        return this.groupP.delete(group);
    }

    @Override
    @AdminPermissionOperation(operationName="addProperty")
    public Group add(Group group, String key, String value) throws SecurityException {
        String methodName = "addProperty";
        this.assertContext(CLS_NM, methodName, group, 10308);
        this.checkAccess(CLS_NM, methodName);
        return this.groupP.add(group, key, value);
    }

    @Override
    @AdminPermissionOperation(operationName="deleteProperty")
    public Group delete(Group group, String key, String value) throws SecurityException {
        String methodName = "deleteProperty";
        this.assertContext(CLS_NM, methodName, group, 10308);
        this.checkAccess(CLS_NM, methodName);
        return this.groupP.delete(group, key, value);
    }

    @Override
    @AdminPermissionOperation
    public Group read(Group group) throws SecurityException {
        String methodName = "read";
        this.assertContext(CLS_NM, methodName, group, 10308);
        this.checkAccess(CLS_NM, methodName);
        return this.groupP.read(group);
    }

    @Override
    @AdminPermissionOperation
    public List<Group> find(Group group) throws SecurityException {
        String methodName = "find";
        this.assertContext(CLS_NM, methodName, group, 10308);
        this.checkAccess(CLS_NM, methodName);
        return this.groupP.search(group);
    }

    @Override
    @AdminPermissionOperation(operationName="findWithUsers")
    public List<Group> find(User user) throws SecurityException {
        String methodName = "findWithUsers";
        this.assertContext(CLS_NM, methodName, user, 1008);
        this.checkAccess(CLS_NM, methodName);
        this.loadUserDn(user);
        return this.groupP.search(user);
    }

    @Override
    @AdminPermissionOperation
    public List<Group> roleGroups(Role role) throws SecurityException {
        String methodName = "roleGroups";
        this.assertContext(CLS_NM, methodName, role, 5007);
        this.checkAccess(CLS_NM, methodName);
        this.loadRoleDn(role);
        return this.groupP.roleGroups(role);
    }

    @Override
    @AdminPermissionOperation
    public List<UserRole> groupRoles(Group group) throws SecurityException {
        String methodName = "groupRoles";
        this.assertContext(CLS_NM, methodName, group, 10308);
        this.checkAccess(CLS_NM, methodName);
        return this.groupP.groupRoles(group);
    }

    @Override
    @AdminPermissionOperation
    public Group assign(Group group, String member) throws SecurityException {
        String dn;
        String methodName = "assign";
        this.assertContext(CLS_NM, methodName, group, 10308);
        this.checkAccess(CLS_NM, methodName);
        ReviewMgr reviewMgr = ReviewMgrFactory.createInstance(this.contextId);
        if (group.getType() == Group.Type.ROLE) {
            Role inRole = new Role(member);
            inRole.setContextId(group.getContextId());
            Role role = reviewMgr.readRole(inRole);
            dn = role.getDn();
            SDUtil.getInstance().validateSSD(group, role);
        } else {
            User inUser = new User(member);
            inUser.setContextId(group.getContextId());
            User user = reviewMgr.readUser(inUser);
            dn = user.getDn();
        }
        return this.groupP.assign(group, dn);
    }

    @Override
    @AdminPermissionOperation
    public Group deassign(Group group, String member) throws SecurityException {
        String dn;
        String methodName = "deassign";
        this.assertContext(CLS_NM, methodName, group, 10308);
        this.checkAccess(CLS_NM, methodName);
        ReviewMgr reviewMgr = ReviewMgrFactory.createInstance(this.contextId);
        if (group.getType() == Group.Type.ROLE) {
            Role role = reviewMgr.readRole(new Role(member));
            dn = role.getDn();
        } else {
            User user = reviewMgr.readUser(new User(member));
            dn = user.getDn();
        }
        return this.groupP.deassign(group, dn);
    }

    private void loadUserDns(Group group) throws SecurityException {
        if (CollectionUtils.isNotEmpty(group.getMembers())) {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance(this.contextId);
            ArrayList<String> userDns = new ArrayList<String>();
            for (String member : group.getMembers()) {
                User user = reviewMgr.readUser(new User(member));
                userDns.add(user.getDn());
            }
            group.setMembers(userDns);
        }
    }

    private void loadRoleDns(Group group) throws SecurityException {
        if (CollectionUtils.isNotEmpty(group.getMembers())) {
            ReviewMgr reviewMgr = ReviewMgrFactory.createInstance(this.contextId);
            ArrayList<String> roleDns = new ArrayList<String>();
            for (String member : group.getMembers()) {
                Role role = reviewMgr.readRole(new Role(member));
                roleDns.add(role.getDn());
            }
            group.setMembers(roleDns);
        }
    }

    private void loadUserDn(User inUser) throws SecurityException {
        ReviewMgr reviewMgr = ReviewMgrFactory.createInstance(this.contextId);
        User outUser = reviewMgr.readUser(inUser);
        inUser.setDn(outUser.getDn());
    }

    private void loadRoleDn(Role inRole) throws SecurityException {
        ReviewMgr reviewMgr = ReviewMgrFactory.createInstance(this.contextId);
        Role outRole = reviewMgr.readRole(inRole);
        inRole.setDn(outRole.getDn());
    }
}

