/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.impl.AdminRoleUtil;
import org.apache.directory.fortress.core.impl.PropertyProvider;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.ldap.client.api.LdapConnection;

final class AdminRoleDAO
extends LdapDataProvider
implements PropertyProvider<AdminRole> {
    private static final String ROLE_OCCUPANT = "roleOccupant";
    private static final String ROLE_OSP = "ftOSP";
    private static final String ROLE_OSU = "ftOSU";
    private static final String ROLE_RANGE = "ftRange";
    private static final String POOLS_AUX_OBJECT_CLASS_NAME = "ftPools";
    private static final String[] ADMIN_ROLE_OBJ_CLASS = new String[]{"top", "ftRls", "ftProperties", "ftPools", "ftMods"};
    private static final String ROLE_NM = "ftRoleName";
    private static final String[] ROLE_NM_ATR = new String[]{"ftRoleName"};
    private static final String[] ROLE_ATRS = new String[]{"ftId", "ftRoleName", "description", "ftCstr", "roleOccupant", "ftOSP", "ftOSU", "ftRange", "ftParents"};

    AdminRoleDAO() {
    }

    AdminRole create(AdminRole entity) throws CreateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity);
        try {
            DefaultEntry entry = new DefaultEntry(dn);
            entry.add("objectClass", ADMIN_ROLE_OBJ_CLASS);
            entity.setId();
            entry.add("ftId", new String[]{entity.getId()});
            entry.add(ROLE_NM, new String[]{entity.getName()});
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                entry.add("description", new String[]{entity.getDescription()});
            }
            entry.add("cn", new String[]{entity.getName()});
            entry.add("ftCstr", new String[]{ConstraintUtil.setConstraint(entity)});
            this.loadAttrs(entity.getOsPSet(), (Entry)entry, ROLE_OSP);
            this.loadAttrs(entity.getOsUSet(), (Entry)entry, ROLE_OSU);
            String szRaw = entity.getRoleRangeRaw();
            if (StringUtils.isNotEmpty((String)szRaw)) {
                entry.add(ROLE_RANGE, new String[]{szRaw});
            }
            this.loadAttrs(entity.getParents(), (Entry)entry, "ftParents");
            ld = this.getAdminConnection();
            this.add(ld, (Entry)entry, entity);
        }
        catch (LdapException e) {
            try {
                String error = "create role [" + entity.getName() + "] caught LdapException=" + (Object)((Object)e);
                throw new CreateException(9002, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    AdminRole update(AdminRole entity) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity);
        try {
            String szRawData;
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "description", new String[]{entity.getDescription()}));
            }
            if (CollectionUtils.isNotEmpty(entity.getOccupants())) {
                for (String name : entity.getOccupants()) {
                    mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, ROLE_OCCUPANT, new String[]{name}));
                }
            }
            if (entity.isTemporalSet() && StringUtils.isNotEmpty((String)(szRawData = ConstraintUtil.setConstraint(entity)))) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftCstr", new String[]{szRawData}));
            }
            this.loadAttrs(entity.getOsUSet(), mods, ROLE_OSU);
            this.loadAttrs(entity.getOsPSet(), mods, ROLE_OSP);
            String szRaw = entity.getRoleRangeRaw();
            if (StringUtils.isNotEmpty((String)szRaw)) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, ROLE_RANGE, new String[]{szRaw}));
            }
            this.loadAttrs(entity.getParents(), mods, "ftParents");
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, dn, mods, (FortEntity)entity);
            }
        }
        catch (LdapException e) {
            try {
                String error = "update name [" + entity.getName() + "] caught LdapException=" + (Object)((Object)e);
                throw new UpdateException(9003, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    void deleteParent(AdminRole entity) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "ftParents"));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)entity);
        }
        catch (LdapException e) {
            try {
                String error = "deleteParent name [" + entity.getName() + "] caught LdapException=" + (Object)((Object)e);
                throw new UpdateException(9028, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    AdminRole assign(AdminRole entity, String userDn) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, ROLE_OCCUPANT, new String[]{userDn}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)entity);
        }
        catch (LdapException e) {
            try {
                String error = "assign role name [" + entity.getName() + "] user dn [" + userDn + "] caught LdapException=" + (Object)((Object)e);
                throw new UpdateException(9008, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    AdminRole deassign(AdminRole entity, String userDn) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, ROLE_OCCUPANT, new String[]{userDn}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)entity);
        }
        catch (LdapException e) {
            try {
                String error = "deassign role name [" + entity.getName() + "] user dn [" + userDn + "] caught LdapException=" + (Object)((Object)e);
                throw new UpdateException(9009, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    void remove(AdminRole role) throws RemoveException {
        LdapConnection ld = null;
        String dn = this.getDn(role);
        try {
            ld = this.getAdminConnection();
            this.delete(ld, dn, (FortEntity)role);
        }
        catch (LdapException e) {
            String error = "remove role name=" + role.getName() + " LdapException=" + (Object)((Object)e);
            throw new RemoveException(9004, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    AdminRole getRole(AdminRole adminRole) throws FinderException {
        AdminRole entity = null;
        LdapConnection ld = null;
        String dn = this.getDn(adminRole);
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, ROLE_ATRS);
            if (findEntry != null) {
                entity = this.unloadLdapEntry(findEntry, 0L, adminRole.getContextId());
            }
            if (entity == null) {
                String warning = "getRole name [" + adminRole.getName() + "] no entry found dn [" + dn + "]";
                throw new FinderException(9006, warning);
            }
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getRole name [" + adminRole.getName() + "] Obj COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(9006, warning, (Exception)((Object)e));
        }
        catch (LdapException e) {
            String error = "getRole dn [" + dn + "] LEXCD=" + (Object)((Object)e);
            throw new FinderException(9001, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<AdminRole> findRoles(AdminRole adminRole) throws FinderException {
        ArrayList<AdminRole> roleList = new ArrayList<AdminRole>();
        LdapConnection ld = null;
        String roleRoot = AdminRoleDAO.getRootDn(adminRole.getContextId(), "adminrole.root");
        try {
            String searchVal = this.encodeSafeText(adminRole.getName(), 40);
            String filter = "(&(objectClass=ftRls)(ftRoleName=" + searchVal + "*))";
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, roleRoot, SearchScope.ONELEVEL, filter, ROLE_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                roleList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++, adminRole.getContextId()));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findRoles name [" + adminRole.getName() + "] caught LdapException=" + (Object)((Object)e);
                throw new FinderException(9000, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findRoles name [" + adminRole.getName() + "] caught CursorException=" + e2.getMessage();
                    throw new FinderException(9000, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return roleList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> findRoles(AdminRole adminRole, int limit) throws FinderException {
        ArrayList<String> roleList = new ArrayList<String>();
        LdapConnection ld = null;
        String roleRoot = AdminRoleDAO.getRootDn(adminRole.getContextId(), "adminrole.root");
        String searchVal = null;
        try {
            searchVal = this.encodeSafeText(adminRole.getName(), 40);
            String filter = "(&(objectClass=ftRls)(ftRoleName=" + searchVal + "*))";
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, roleRoot, SearchScope.ONELEVEL, filter, ROLE_NM_ATR, false, limit);
            while (searchResults.next()) {
                Entry entry = searchResults.getEntry();
                roleList.add(this.getAttribute(entry, ROLE_NM));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findRoles name [" + searchVal + "] caught LdapException=" + (Object)((Object)e);
                throw new FinderException(9000, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findRoles name [" + searchVal + "] caught CursorException=" + e2.getMessage();
                    throw new FinderException(9000, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return roleList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<String> findAssignedRoles(String userDn, String contextId) throws FinderException {
        ArrayList<String> roleNameList = new ArrayList<String>();
        LdapConnection ld = null;
        String roleRoot = AdminRoleDAO.getRootDn(contextId, "adminrole.root");
        try {
            String filter = "(&(objectClass=ftRls)";
            filter = filter + "(roleOccupant=" + userDn + "))";
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, roleRoot, SearchScope.ONELEVEL, filter, ROLE_NM_ATR, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            while (searchResults.next()) {
                roleNameList.add(this.getAttribute(searchResults.getEntry(), ROLE_NM));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findAssignedRoles userDn [" + userDn + "] caught LdapException=" + (Object)((Object)e);
                throw new FinderException(9026, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findAssignedRoles userDn [" + userDn + "] caught CursorException=" + e2.getMessage();
                    throw new FinderException(9026, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return roleNameList;
    }

    List<Graphable> getAllDescendants(String contextId) throws FinderException {
        String[] DESC_ATRS = new String[]{ROLE_NM, "ftParents"};
        ArrayList<Graphable> descendants = new ArrayList<Graphable>();
        LdapConnection ld = null;
        String roleRoot = AdminRoleDAO.getRootDn(contextId, "adminrole.root");
        String filter = null;
        try {
            filter = "(&(objectClass=ftRls)(ftParents=*))";
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, roleRoot, SearchScope.ONELEVEL, filter, DESC_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                descendants.add(this.unloadDescendants(searchResults.getEntry(), sequence++));
            }
        }
        catch (LdapException e) {
            String error = "getAllDescendants filter [" + filter + "] caught LdapException=" + (Object)((Object)e);
            throw new FinderException(9000, error, (Exception)((Object)e));
        }
        catch (CursorException e) {
            String error = "getAllDescendants filter [" + filter + "] caught CursorException=" + e.getMessage();
            throw new FinderException(9000, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return descendants;
    }

    private Graphable unloadDescendants(Entry le, long sequence) throws LdapInvalidAttributeValueException {
        Role entity = new ObjectFactory().createRole();
        entity.setSequenceId(sequence);
        entity.setName(this.getAttribute(le, ROLE_NM));
        entity.setParents(this.getAttributeSet(le, "ftParents"));
        return entity;
    }

    private AdminRole unloadLdapEntry(Entry le, long sequence, String contextId) throws LdapInvalidAttributeValueException {
        AdminRole entity = new ObjectFactory().createAdminRole();
        entity.setSequenceId(sequence);
        entity.setId(this.getAttribute(le, "ftId"));
        entity.setDescription(this.getAttribute(le, "description"));
        entity.setOccupants(this.getAttributes(le, ROLE_OCCUPANT));
        entity.setOsPSet(this.getAttributeSet(le, ROLE_OSP));
        entity.setOsUSet(this.getAttributeSet(le, ROLE_OSU));
        entity.setName(this.getAttribute(le, "cn"));
        this.unloadTemporal(le, entity);
        entity.setRoleRangeRaw(this.getAttribute(le, ROLE_RANGE));
        entity.setParents(this.getAttributeSet(le, "ftParents"));
        entity.setChildren(AdminRoleUtil.getChildren(entity.getName().toUpperCase(), contextId));
        return entity;
    }

    @Override
    public String getDn(AdminRole adminRole) {
        return "cn=" + adminRole.getName() + "," + AdminRoleDAO.getRootDn(adminRole.getContextId(), "adminrole.root");
    }

    @Override
    public FortEntity getEntity(AdminRole entity) throws FinderException {
        return this.getRole(entity);
    }
}

