/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.cli;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.AccessMgr;
import org.apache.directory.fortress.core.AccessMgrFactory;
import org.apache.directory.fortress.core.AdminMgr;
import org.apache.directory.fortress.core.AdminMgrFactory;
import org.apache.directory.fortress.core.DelAdminMgr;
import org.apache.directory.fortress.core.DelAdminMgrFactory;
import org.apache.directory.fortress.core.GroupMgr;
import org.apache.directory.fortress.core.GroupMgrFactory;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.ReviewMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.cli.CmdLineParser;
import org.apache.directory.fortress.core.cli.Options;
import org.apache.directory.fortress.core.model.Address;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Relationship;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.PropUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineInterpreter {
    private static final String CLS_NM = CommandLineInterpreter.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private AdminMgr adminMgr;
    private ReviewMgr reviewMgr;
    private AccessMgr accessMgr;
    private DelAdminMgr delAdminMgr;
    private GroupMgr groupMgr;
    private static final String ADMIN = "admin";
    private static final String REVIEW = "review";
    private static final String SYSTEM = "system";
    private static final String DELEGATED_ADMIN = "dadmin";
    private static final String DELEGATED_REVIEW = "dreview";
    private static final String DELEGATED_SYSTEM = "dsystem";
    private static final String GROUP = "group";
    private static final String ADD_USER = "auser";
    private static final String UPDATE_USER = "uuser";
    private static final String DELETE_USER = "duser";
    private static final String READ_USER = "ruser";
    private static final String FIND_USERS = "fuser";
    private static final String ASSIGNED_USERS = "asgnuser";
    private static final String CHANGE_PASSWORD = "change";
    private static final String LOCK_USER_ACCOUNT = "lock";
    private static final String UNLOCK_USER_ACCOUNT = "unlock";
    private static final String RESET_PASSWORD = "reset";
    private static final String ADD_ROLE = "arole";
    private static final String UPDATE_ROLE = "urole";
    private static final String DELETE_ROLE = "drole";
    private static final String READ_ROLE = "rrole";
    private static final String FIND_ROLES = "frole";
    private static final String ASSIGN_ROLE = "asgnrole";
    private static final String DEASSIGN_ROLE = "dsgnrole";
    private static final String ADD_ROLE_INHERITANCE = "arel";
    private static final String DELETE_ROLE_INHERITANCE = "drel";
    private static final String CREATE_SSD_SET = "asset";
    private static final String DELETE_SSD_SET = "dsset";
    private static final String CREATE_DSD_SET = "adset";
    private static final String DELETE_DSD_SET = "ddset";
    private static final String ADD_POBJ = "aobj";
    private static final String UPDATE_POBJ = "uobj";
    private static final String DELETE_POBJ = "dobj";
    private static final String READ_POBJ = "robj";
    private static final String FIND_POBJS = "fobj";
    private static final String ADD_PERM = "aperm";
    private static final String UPDATE_PERM = "uperm";
    private static final String DELETE_PERM = "dperm";
    private static final String READ_PERM = "rperm";
    private static final String FIND_PERMS = "fperm";
    private static final String GRANT = "grant";
    private static final String REVOKE = "revoke";
    private static final String ADD_GROUP = "agroup";
    private static final String UPDATE_GROUP = "ugroup";
    private static final String DELETE_GROUP = "dgroup";
    private static final String READ_GROUP = "rgroup";
    private static final String FIND_GROUP = "fgroup";
    private static final String ASSIGN_GROUP = "asgngroup";
    private static final String DEASSIGN_GROUP = "dsgngroup";
    private static final String ADD_GROUP_PROP = "agprop";
    private static final String DELETE_GROUP_PROP = "dgprop";
    private static final String ADD_USERORG = "auou";
    private static final String UPDATE_USERORG = "uuou";
    private static final String DELETE_USERORG = "duou";
    private static final String ADD_USERORG_INHERITANCE = "aurel";
    private static final String DELETE_USERORG_INHERITANCE = "durel";
    private static final String ADD_PERMORG = "apou";
    private static final String UPDATE_PERMORG = "upou";
    private static final String DELETE_PERMORG = "dpou";
    private static final String ADD_PERMORG_INHERITANCE = "aprel";
    private static final String DELETE_PERMORG_INHERITANCE = "dprel";
    private static final String CREATE_SESSION = "createsession";
    private static final String AUTHENTICATE = "authenticate";
    private static final String ASSIGNED_ROLES = "assignedroles";
    private static final String CHECK_ACCESS = "checkaccess";

    public static void main(String[] args) {
        CommandLineInterpreter cli = new CommandLineInterpreter();
        cli.runInteractiveMode();
        System.exit(0);
    }

    private void runInteractiveMode() {
        if (!this.constructManagers()) {
            String error = "Startup to interactive mode failed, goodbye.";
            LOG.error(error);
            return;
        }
        LOG.info("Startup to interactive mode success...");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    LOG.info("CLI function groups include admin, review, system, dadmin, group");
                    LOG.info("Enter one from above or 'q' to quit");
                    String input = br.readLine();
                    if (!StringUtils.isNotEmpty((String)input)) continue;
                    if ("Q".equalsIgnoreCase(input)) {
                        LOG.info("Goodbye");
                        break block2;
                    }
                    String[] options = this.parseUserInput(input);
                    this.processUserInput(options);
                }
            }
            catch (Exception e) {
                String error = "runInteractiveMode caught Exception=" + e.toString();
                LOG.error(error);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void printUsage() {
        LOG.error("Usage: group function options");
        LOG.error("where group is: admin, review, system, dadmin or group");
        LOG.error("Check out the Command Line Reference manual for what the valid function and option combinations are.");
    }

    private void processCommand(Set<String> commands, Options options) {
        if (commands.contains(ADMIN)) {
            this.processAdminCommand(commands, options);
        } else if (commands.contains(REVIEW)) {
            this.processReviewCommand(commands, options);
        } else if (commands.contains(SYSTEM)) {
            this.processSystemCommand(commands, options);
        } else if (commands.contains(DELEGATED_ADMIN)) {
            this.processDelegatedAdminCommand(commands, options);
        } else if (commands.contains(GROUP)) {
            this.processGroupCommand(commands, options);
        } else {
            LOG.warn("unknown admin operation detected");
        }
    }

    private void processDelegatedAdminCommand(Set<String> commands, Options options) {
        try {
            String command;
            if (commands.contains(ADD_ROLE)) {
                command = ADD_ROLE;
                LOG.info(command);
                AdminRole role = options.getAdminRole();
                this.delAdminMgr.addRole(role);
            } else if (commands.contains(UPDATE_ROLE)) {
                command = UPDATE_ROLE;
                LOG.info(command);
                AdminRole role = options.getAdminRole();
                this.delAdminMgr.updateRole(role);
            } else if (commands.contains(DELETE_ROLE)) {
                command = DELETE_ROLE;
                LOG.info(command);
                AdminRole role = options.getAdminRole();
                this.delAdminMgr.deleteRole(role);
            } else if (commands.contains(ASSIGN_ROLE)) {
                command = ASSIGN_ROLE;
                LOG.info(command);
                Role role = options.getRole();
                String userId = options.getUserId();
                this.delAdminMgr.assignUser(new UserAdminRole(userId, role));
            } else if (commands.contains(DEASSIGN_ROLE)) {
                command = DEASSIGN_ROLE;
                LOG.info(command);
                Role role = options.getRole();
                String userId = options.getUserId();
                this.delAdminMgr.deassignUser(new UserAdminRole(userId, role));
            } else if (commands.contains(ADD_ROLE_INHERITANCE)) {
                command = ADD_ROLE_INHERITANCE;
                LOG.info(command);
                Relationship relationship = options.getRelationship();
                this.delAdminMgr.addInheritance(new AdminRole(relationship.getParent()), new AdminRole(relationship.getChild()));
            } else if (commands.contains(DELETE_ROLE_INHERITANCE)) {
                command = DELETE_ROLE_INHERITANCE;
                LOG.info(command);
                Relationship relationship = options.getRelationship();
                this.delAdminMgr.deleteInheritance(new AdminRole(relationship.getParent()), new AdminRole(relationship.getChild()));
            } else if (commands.contains(ADD_POBJ)) {
                command = ADD_POBJ;
                LOG.info(command);
                PermObj permObj = options.getPermObj();
                this.delAdminMgr.addPermObj(permObj);
            } else if (commands.contains(UPDATE_POBJ)) {
                command = UPDATE_POBJ;
                LOG.info(command);
                PermObj permObj = options.getPermObj();
                this.delAdminMgr.updatePermObj(permObj);
            } else if (commands.contains(DELETE_POBJ)) {
                command = DELETE_POBJ;
                LOG.info(command);
                PermObj permObj = options.getPermObj();
                this.delAdminMgr.deletePermObj(permObj);
            } else if (commands.contains(ADD_PERM)) {
                command = ADD_PERM;
                LOG.info(command);
                Permission perm = options.getPermission();
                this.delAdminMgr.addPermission(perm);
            } else if (commands.contains(UPDATE_PERM)) {
                command = UPDATE_PERM;
                LOG.info(command);
                Permission perm = options.getPermission();
                this.delAdminMgr.updatePermission(perm);
            } else if (commands.contains(DELETE_PERM)) {
                command = DELETE_PERM;
                LOG.info(command);
                Permission permObj = options.getPermission();
                this.delAdminMgr.deletePermission(permObj);
            } else if (commands.contains(GRANT)) {
                command = GRANT;
                LOG.info(command);
                Permission perm = options.getPermission();
                AdminRole role = options.getAdminRole();
                role.setName(options.getRoleNm());
                this.delAdminMgr.grantPermission(perm, role);
            } else if (commands.contains(REVOKE)) {
                command = REVOKE;
                LOG.info(command);
                Permission perm = options.getPermission();
                AdminRole role = options.getAdminRole();
                role.setName(options.getRoleNm());
                this.delAdminMgr.revokePermission(perm, role);
            } else if (commands.contains(ADD_USERORG)) {
                command = ADD_USERORG;
                LOG.info(command);
                OrgUnit orgUnit = options.getOrgUnit();
                orgUnit.setType(OrgUnit.Type.USER);
                this.delAdminMgr.add(orgUnit);
            } else if (commands.contains(UPDATE_USERORG)) {
                command = UPDATE_USERORG;
                LOG.info(command);
                OrgUnit orgUnit = options.getOrgUnit();
                orgUnit.setType(OrgUnit.Type.USER);
                this.delAdminMgr.update(orgUnit);
            } else if (commands.contains(DELETE_USERORG)) {
                command = DELETE_USERORG;
                LOG.info(command);
                OrgUnit orgUnit = options.getOrgUnit();
                orgUnit.setType(OrgUnit.Type.USER);
                this.delAdminMgr.delete(orgUnit);
            } else if (commands.contains(ADD_USERORG_INHERITANCE)) {
                command = ADD_USERORG_INHERITANCE;
                LOG.info(command);
                Relationship relationship = options.getRelationship();
                this.delAdminMgr.addInheritance(new OrgUnit(relationship.getParent(), OrgUnit.Type.USER), new OrgUnit(relationship.getChild(), OrgUnit.Type.USER));
            } else if (commands.contains(DELETE_USERORG_INHERITANCE)) {
                command = DELETE_USERORG_INHERITANCE;
                LOG.info(command);
                Relationship relationship = options.getRelationship();
                this.delAdminMgr.deleteInheritance(new OrgUnit(relationship.getParent(), OrgUnit.Type.USER), new OrgUnit(relationship.getChild(), OrgUnit.Type.USER));
            } else if (commands.contains(ADD_PERMORG)) {
                command = ADD_PERMORG;
                LOG.info(command);
                OrgUnit orgUnit = options.getOrgUnit();
                orgUnit.setType(OrgUnit.Type.PERM);
                this.delAdminMgr.add(orgUnit);
            } else if (commands.contains(UPDATE_PERMORG)) {
                command = UPDATE_PERMORG;
                LOG.info(command);
                OrgUnit orgUnit = options.getOrgUnit();
                orgUnit.setType(OrgUnit.Type.PERM);
                this.delAdminMgr.update(orgUnit);
            } else if (commands.contains(DELETE_PERMORG)) {
                command = DELETE_PERMORG;
                LOG.info(command);
                OrgUnit orgUnit = options.getOrgUnit();
                orgUnit.setType(OrgUnit.Type.PERM);
                this.delAdminMgr.delete(orgUnit);
            } else if (commands.contains(ADD_PERMORG_INHERITANCE)) {
                command = ADD_PERMORG_INHERITANCE;
                LOG.info(command);
                Relationship relationship = options.getRelationship();
                this.delAdminMgr.addInheritance(new OrgUnit(relationship.getParent(), OrgUnit.Type.PERM), new OrgUnit(relationship.getChild(), OrgUnit.Type.PERM));
            } else if (commands.contains(DELETE_PERMORG_INHERITANCE)) {
                command = DELETE_PERMORG_INHERITANCE;
                LOG.info(command);
                Relationship relationship = options.getRelationship();
                this.delAdminMgr.deleteInheritance(new OrgUnit(relationship.getParent(), OrgUnit.Type.PERM), new OrgUnit(relationship.getChild(), OrgUnit.Type.PERM));
            } else {
                LOG.warn("unknown delegated admin operation detected");
                return;
            }
            LOG.info("command:{} was successful", (Object)command);
        }
        catch (SecurityException se) {
            String error = "processDelegatedAdminCommand caught SecurityException=" + se + ", return code=" + se.getErrorId();
            LOG.error(error);
        }
    }

    private void processAdminCommand(Set<String> commands, Options options) {
        try {
            String command;
            if (commands.contains(ADD_USER)) {
                command = ADD_USER;
                LOG.info(command);
                User user = options.getUser();
                this.adminMgr.addUser(user);
            } else if (commands.contains(UPDATE_USER)) {
                command = UPDATE_USER;
                LOG.info(command);
                User user = options.getUser();
                this.adminMgr.updateUser(user);
            } else if (commands.contains(DELETE_USER)) {
                command = DELETE_USER;
                LOG.info(command);
                User user = options.getUser();
                this.adminMgr.deleteUser(user);
            } else if (commands.contains(ADD_ROLE)) {
                command = ADD_ROLE;
                LOG.info(command);
                Role role = options.getRole();
                this.adminMgr.addRole(role);
            } else if (commands.contains(UPDATE_ROLE)) {
                command = UPDATE_ROLE;
                LOG.info(command);
                Role role = options.getRole();
                this.adminMgr.updateRole(role);
            } else if (commands.contains(DELETE_ROLE)) {
                command = DELETE_ROLE;
                LOG.info(command);
                Role role = options.getRole();
                this.adminMgr.deleteRole(role);
            } else if (commands.contains(ASSIGN_ROLE)) {
                command = ASSIGN_ROLE;
                LOG.info(command);
                Role role = options.getRole();
                String userId = options.getUserId();
                this.adminMgr.assignUser(new UserRole(userId, role));
            } else if (commands.contains(DEASSIGN_ROLE)) {
                command = DEASSIGN_ROLE;
                LOG.info(command);
                Role role = options.getRole();
                String userId = options.getUserId();
                this.adminMgr.deassignUser(new UserRole(userId, role));
            } else if (commands.contains(ADD_ROLE_INHERITANCE)) {
                command = ADD_ROLE_INHERITANCE;
                LOG.info(command);
                Relationship relationship = options.getRelationship();
                this.adminMgr.addInheritance(new Role(relationship.getParent()), new Role(relationship.getChild()));
            } else if (commands.contains(DELETE_ROLE_INHERITANCE)) {
                command = DELETE_ROLE_INHERITANCE;
                LOG.info(command);
                Relationship relationship = options.getRelationship();
                this.adminMgr.deleteInheritance(new Role(relationship.getParent()), new Role(relationship.getChild()));
            } else if (commands.contains(ADD_POBJ)) {
                command = ADD_POBJ;
                LOG.info(command);
                PermObj permObj = options.getPermObj();
                this.adminMgr.addPermObj(permObj);
            } else if (commands.contains(UPDATE_POBJ)) {
                command = UPDATE_POBJ;
                LOG.info(command);
                PermObj permObj = options.getPermObj();
                this.adminMgr.updatePermObj(permObj);
            } else if (commands.contains(DELETE_POBJ)) {
                command = DELETE_POBJ;
                LOG.info(command);
                PermObj permObj = options.getPermObj();
                this.adminMgr.deletePermObj(permObj);
            } else if (commands.contains(ADD_PERM)) {
                command = ADD_PERM;
                LOG.info(command);
                Permission perm = options.getPermission();
                this.adminMgr.addPermission(perm);
            } else if (commands.contains(UPDATE_PERM)) {
                command = UPDATE_PERM;
                LOG.info(command);
                Permission perm = options.getPermission();
                this.adminMgr.updatePermission(perm);
            } else if (commands.contains(DELETE_PERM)) {
                command = DELETE_PERM;
                LOG.info(command);
                Permission permObj = options.getPermission();
                this.adminMgr.deletePermission(permObj);
            } else if (commands.contains(GRANT)) {
                command = GRANT;
                LOG.info(command);
                Permission perm = options.getPermission();
                Role role = options.getRole();
                role.setName(options.getRoleNm());
                this.adminMgr.grantPermission(perm, role);
            } else if (commands.contains(REVOKE)) {
                command = REVOKE;
                LOG.info(command);
                Permission perm = options.getPermission();
                Role role = options.getRole();
                role.setName(options.getRoleNm());
                this.adminMgr.revokePermission(perm, role);
            } else if (commands.contains(CREATE_SSD_SET)) {
                command = CREATE_SSD_SET;
                LOG.info(command);
                SDSet ssd = options.getSdSet();
                ssd.setType(SDSet.SDType.STATIC);
                this.adminMgr.createSsdSet(ssd);
            } else if (commands.contains(DELETE_SSD_SET)) {
                command = DELETE_SSD_SET;
                LOG.info(command);
                SDSet ssd = options.getSdSet();
                ssd.setType(SDSet.SDType.STATIC);
                this.adminMgr.deleteSsdSet(ssd);
            } else if (commands.contains(CREATE_DSD_SET)) {
                command = CREATE_DSD_SET;
                LOG.info(command);
                SDSet ssd = options.getSdSet();
                ssd.setType(SDSet.SDType.DYNAMIC);
                this.adminMgr.createDsdSet(ssd);
            } else if (commands.contains(DELETE_DSD_SET)) {
                command = DELETE_DSD_SET;
                LOG.info(command);
                SDSet ssd = options.getSdSet();
                ssd.setType(SDSet.SDType.DYNAMIC);
                this.adminMgr.deleteDsdSet(ssd);
            } else if (commands.contains(CHANGE_PASSWORD)) {
                command = CHANGE_PASSWORD;
                LOG.info(command);
                User user = options.getUser();
                String newPassword = options.getNewPassword();
                this.adminMgr.changePassword(user, newPassword);
            } else if (commands.contains(RESET_PASSWORD)) {
                command = RESET_PASSWORD;
                LOG.info(command);
                User user = options.getUser();
                String newPassword = options.getNewPassword();
                this.adminMgr.resetPassword(user, newPassword);
            } else if (commands.contains(LOCK_USER_ACCOUNT)) {
                command = LOCK_USER_ACCOUNT;
                LOG.info(command);
                User user = options.getUser();
                this.adminMgr.lockUserAccount(user);
            } else if (commands.contains(UNLOCK_USER_ACCOUNT)) {
                command = UNLOCK_USER_ACCOUNT;
                LOG.info(command);
                User user = options.getUser();
                this.adminMgr.unlockUserAccount(user);
            } else {
                LOG.warn("unknown admin operation detected");
                return;
            }
            LOG.info("command:{} was successful", (Object)command);
        }
        catch (SecurityException se) {
            String error = "processAdminCommand caught SecurityException=" + se + ", return code=" + se.getErrorId();
            LOG.error(error);
        }
    }

    private void processReviewCommand(Set<String> commands, Options options) {
        try {
            String command;
            if (commands.contains(READ_USER)) {
                command = READ_USER;
                LOG.info(READ_USER);
                User inUser = options.getUser();
                User outUser = this.reviewMgr.readUser(inUser);
                this.printUser(outUser);
            } else if (commands.contains(FIND_USERS)) {
                command = FIND_USERS;
                LOG.info(command);
                User user = options.getUser();
                List<User> outUsers = this.reviewMgr.findUsers(user);
                if (CollectionUtils.isNotEmpty(outUsers)) {
                    int ctr = 0;
                    for (User outUser : outUsers) {
                        this.printRow("U", "CTR ", "" + ctr++);
                        this.printUser(outUser);
                    }
                }
            } else if (commands.contains(ASSIGNED_USERS)) {
                command = ASSIGNED_USERS;
                LOG.info(command);
                Role inRole = options.getRole();
                List<User> outUsers = this.reviewMgr.assignedUsers(inRole);
                if (CollectionUtils.isNotEmpty(outUsers)) {
                    for (User outUser : outUsers) {
                        this.printUser(outUser);
                    }
                }
            } else if (commands.contains(READ_ROLE)) {
                command = READ_ROLE;
                LOG.info(command);
                Role inRole = options.getRole();
                Role outRole = this.reviewMgr.readRole(inRole);
                this.printRole(outRole);
            } else if (commands.contains(FIND_ROLES)) {
                command = FIND_ROLES;
                LOG.info(command);
                String inRoleNm = options.getName();
                List<Role> outRoles = this.reviewMgr.findRoles(inRoleNm);
                if (CollectionUtils.isNotEmpty(outRoles)) {
                    int ctr = 0;
                    for (Role outRole : outRoles) {
                        this.printSeparator();
                        this.printRow("R", "ROLE[" + ++ctr + "]", outRole.getName());
                        this.printRole(outRole);
                    }
                }
            } else if (commands.contains(ASSIGNED_ROLES)) {
                command = ASSIGNED_ROLES;
                LOG.info(command);
                String userId = options.getUserId();
                List<UserRole> uRoles = this.reviewMgr.assignedRoles(new User(userId));
                if (uRoles != null) {
                    for (UserRole ur : uRoles) {
                        this.printTemporal("R", ur, "RBACROLE");
                        this.printSeparator();
                    }
                }
            } else if (commands.contains(READ_POBJ)) {
                command = READ_POBJ;
                LOG.info(command);
                PermObj inPermObj = options.getPermObj();
                PermObj outPermObj = this.reviewMgr.readPermObj(inPermObj);
                this.printPermObj(outPermObj);
            } else if (commands.contains(FIND_POBJS)) {
                command = FIND_POBJS;
                LOG.info(command);
                PermObj inPermObj = options.getPermObj();
                List<PermObj> outPermObjs = this.reviewMgr.findPermObjs(inPermObj);
                if (CollectionUtils.isNotEmpty(outPermObjs)) {
                    int ctr = 0;
                    for (PermObj outPermObj : outPermObjs) {
                        this.printSeparator();
                        this.printRow("PO", "POBJ[" + ++ctr + "]", outPermObj.getObjName());
                        this.printPermObj(outPermObj);
                    }
                }
            } else if (commands.contains(READ_PERM)) {
                command = READ_PERM;
                LOG.info(command);
                Permission inPerm = options.getPermission();
                Permission outPerm = this.reviewMgr.readPermission(inPerm);
                this.printPermission(outPerm);
            } else if (commands.contains(FIND_PERMS)) {
                command = FIND_PERMS;
                LOG.info(command);
                Permission inPerm = options.getPermission();
                List<Permission> outPerms = this.reviewMgr.findPermissions(inPerm);
                if (CollectionUtils.isNotEmpty(outPerms)) {
                    int ctr = 0;
                    for (Permission outPerm : outPerms) {
                        this.printSeparator();
                        this.printRow("P", "PERM[" + ++ctr + "]", outPerm.getAbstractName());
                        this.printPermission(outPerm);
                    }
                }
            } else {
                LOG.warn("unknown review operation detected");
                return;
            }
            LOG.info("command:{} was successful", (Object)command);
        }
        catch (SecurityException se) {
            String error = "processReviewCommand caught SecurityException=" + se + ", return code=" + se.getErrorId();
            LOG.error(error);
        }
    }

    private void processSystemCommand(Set<String> commands, Options options) {
        try {
            String command;
            if (commands.contains(CREATE_SESSION)) {
                command = CREATE_SESSION;
                LOG.info(READ_USER);
                User inUser = options.getUser();
                Session session = this.accessMgr.createSession(inUser, false);
                this.printSession(session);
            } else if (commands.contains(AUTHENTICATE)) {
                command = AUTHENTICATE;
                LOG.info(command);
                User inUser = options.getUser();
                Session session = this.accessMgr.authenticate(inUser.getUserId(), inUser.getPassword());
                this.printSession(session);
            } else if (commands.contains(ASSIGNED_ROLES)) {
                command = ASSIGNED_ROLES;
                LOG.info(command);
                User inUser = options.getUser();
                Session session = this.accessMgr.createSession(inUser, true);
                List<UserRole> uRoles = this.accessMgr.sessionRoles(session);
                if (uRoles != null) {
                    for (UserRole ur : uRoles) {
                        this.printTemporal("R", ur, "RBACROLE");
                        this.printSeparator();
                    }
                }
            } else if (commands.contains(CHECK_ACCESS)) {
                command = CHECK_ACCESS;
                LOG.info(command);
                Permission inPerm = options.getPermission();
                User inUser = options.getUser();
                Session session = this.accessMgr.createSession(inUser, true);
                boolean result = this.accessMgr.checkAccess(session, inPerm);
                this.printRow("CA", "PERM", "" + result);
            } else {
                LOG.warn("unknown system operation detected");
                return;
            }
            LOG.info("command:{} was successful", (Object)command);
        }
        catch (SecurityException se) {
            String error = "processSystemCommand caught SecurityException=" + se + ", return code=" + se.getErrorId();
            LOG.error(error);
        }
    }

    private void processGroupCommand(Set<String> commands, Options options) {
        try {
            String command;
            if (commands.contains(ADD_GROUP)) {
                command = ADD_GROUP;
                LOG.info(command);
                Group group = options.getGroup();
                this.groupMgr.add(group);
            } else if (commands.contains(UPDATE_GROUP)) {
                command = UPDATE_GROUP;
                LOG.info(command);
                Group group = options.getGroup();
                this.groupMgr.update(group);
            } else if (commands.contains(DELETE_GROUP)) {
                command = DELETE_GROUP;
                LOG.info(command);
                Group group = options.getGroup();
                this.groupMgr.delete(group);
            } else if (commands.contains(READ_GROUP)) {
                command = READ_GROUP;
                LOG.info(command);
                Group group = options.getGroup();
                Group outGroup = this.groupMgr.read(group);
                this.printGroup(outGroup);
            } else if (commands.contains(FIND_GROUP)) {
                command = FIND_GROUP;
                LOG.info(command);
                Group inGroup = options.getGroup();
                List<Group> groups = this.groupMgr.find(inGroup);
                if (CollectionUtils.isNotEmpty(groups)) {
                    for (Group outGroup : groups) {
                        this.printGroup(outGroup);
                    }
                }
            } else if (commands.contains(ASSIGN_GROUP)) {
                command = ASSIGN_GROUP;
                LOG.info(command);
                Group group = options.getGroup();
                if (CollectionUtils.isNotEmpty(group.getMembers())) {
                    for (String member : group.getMembers()) {
                        this.groupMgr.assign(group, member);
                    }
                }
            } else if (commands.contains(DEASSIGN_GROUP)) {
                command = DEASSIGN_GROUP;
                LOG.info(command);
                Group group = options.getGroup();
                if (CollectionUtils.isNotEmpty(group.getMembers())) {
                    for (String member : group.getMembers()) {
                        this.groupMgr.deassign(group, member);
                    }
                }
            } else if (commands.contains(ADD_GROUP_PROP)) {
                command = ADD_GROUP_PROP;
                LOG.info(command);
                Group group = options.getGroup();
                if (PropUtil.isNotEmpty(group.getProperties())) {
                    Enumeration<?> e = group.getProperties().propertyNames();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String val = group.getProperty(key);
                        this.groupMgr.add(group, key, val);
                    }
                }
            } else if (commands.contains(DELETE_GROUP_PROP)) {
                command = DELETE_GROUP_PROP;
                LOG.info(command);
                Group group = options.getGroup();
                if (PropUtil.isNotEmpty(group.getProperties())) {
                    Enumeration<?> e = group.getProperties().propertyNames();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String val = group.getProperty(key);
                        this.groupMgr.delete(group, key, val);
                    }
                }
            } else {
                LOG.warn("unknown group operation detected");
                return;
            }
            LOG.info("command:{} was successful", (Object)command);
        }
        catch (SecurityException se) {
            String error = "processGroupCommand caught SecurityException=" + se + ", return code=" + se.getErrorId();
            LOG.error(error);
        }
    }

    private Options loadOptions(CmdLineParser parser) {
        return new Options(parser);
    }

    private String[] parseUserInput(String input) {
        ArrayList<String> options = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(input);
        boolean isPassword = false;
        while (regexMatcher.find()) {
            String arg = regexMatcher.group(1) != null ? regexMatcher.group(1) : (regexMatcher.group(2) != null ? regexMatcher.group(2) : regexMatcher.group());
            options.add(arg);
            if (!isPassword) {
                LOG.info("arg:{}", (Object)arg);
            } else {
                isPassword = false;
            }
            if (!"-p".equalsIgnoreCase(arg)) continue;
            isPassword = true;
        }
        return options.toArray(new String[options.size()]);
    }

    private void processUserInput(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        Options options = this.loadOptions(parser);
        Set<String> commands = null;
        try {
            parser.parse(args);
            commands = this.loadCommandSet(parser.getRemainingArgs());
        }
        catch (CmdLineParser.OptionException e) {
            String error = "processUserInput caught OptionException=" + e.toString();
            LOG.error(error);
            CommandLineInterpreter.printUsage();
        }
        if (commands != null && commands.size() > 0) {
            this.processCommand(commands, options);
        }
    }

    private Set<String> loadCommandSet(String[] otherArgs) {
        HashSet commands = null;
        if (ArrayUtils.isNotEmpty((Object[])otherArgs)) {
            commands = new HashSet();
            Collections.addAll(commands, otherArgs);
        }
        return commands;
    }

    private void printRole(Role role) {
        String type = "R";
        if (role != null) {
            this.printRow(type, "NAME", role.getName());
            this.printRow(type, "IID ", role.getId());
            if (CollectionUtils.isNotEmpty(role.getParents())) {
                for (String parentRole : role.getParents()) {
                    this.printRow(type, "PRLE", parentRole);
                }
            }
            if (CollectionUtils.isNotEmpty(role.getChildren())) {
                for (String childRole : role.getChildren()) {
                    this.printRow(type, "CRLE", childRole);
                }
            }
            this.printTemporal(type, role, "ROLE");
        }
    }

    private void printPermission(Permission perm) {
        String type = "P";
        if (perm != null) {
            this.printRow(type, "POBJ", perm.getObjName());
            this.printRow(type, "OPER", perm.getOpName());
            this.printRow(type, "IID", perm.getInternalId());
            this.printRow(type, "TYPE", perm.getType());
        }
        if (CollectionUtils.isNotEmpty(perm != null ? perm.getRoles() : null)) {
            for (String roleName : perm.getRoles()) {
                this.printRow("R", "ROLE", roleName);
            }
        }
        if (perm != null) {
            if (CollectionUtils.isNotEmpty(perm.getUsers())) {
                for (String userId : perm.getUsers()) {
                    this.printRow("U", "USER", userId);
                }
            }
            if (PropUtil.isNotEmpty(perm.getProperties())) {
                this.printSeparator();
                int ctr = 0;
                Enumeration<?> e = perm.getProperties().propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String val = perm.getProperty(key);
                    LOG.info("{}   KEY{} [{}]", new Object[]{type, ++ctr, key});
                    LOG.info("{}   VAL{} [{}]", new Object[]{type, ctr, val});
                }
            }
        }
    }

    private void printPermObj(PermObj permObj) {
        String type = "O";
        if (permObj != null) {
            this.printRow(type, "NAME", permObj.getObjName());
            this.printRow(type, "IID ", permObj.getInternalId());
            this.printRow(type, "TYPE", permObj.getType());
            this.printRow(type, "OU  ", permObj.getOu());
        }
        if (PropUtil.isNotEmpty(permObj != null ? permObj.getProperties() : null)) {
            this.printSeparator();
            int ctr = 0;
            Enumeration<?> e = permObj.getProperties().propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = permObj.getProperty(key);
                LOG.info("{}   KEY{} [{}]", new Object[]{type, ++ctr, key});
                LOG.info("{}   VAL{} [{}]", new Object[]{type, ctr, val});
            }
        }
    }

    private void printSession(Session session) {
        String type = "S";
        this.printRow(type, "UID ", session.getUserId());
        this.printRow(type, "IID ", session.getInternalUserId());
        this.printRow(type, "ERR ", "" + session.getErrorId());
        this.printRow(type, "WARN", "" + session.getWarnings());
        this.printRow(type, "MSG ", session.getMsg());
        this.printRow(type, "EXP ", "" + session.getExpirationSeconds());
        this.printRow(type, "GRAC", "" + session.getGraceLogins());
        this.printRow(type, "AUTH", "" + session.isAuthenticated());
        this.printRow(type, "LAST", "" + session.getLastAccess());
        this.printRow(type, "SID ", session.getSessionId());
        this.printSeparator();
        User user = session.getUser();
        if (user != null) {
            this.printUser(user);
        }
    }

    private void printUser(User user) {
        String type = "U";
        if (user != null) {
            this.printRow(type, "UID ", user.getUserId());
            this.printRow(type, "IID ", user.getInternalId());
            this.printRow(type, "CN  ", user.getCn());
            this.printRow(type, "DESC", user.getDescription());
            this.printRow(type, "OU  ", user.getOu());
            this.printRow(type, "SN  ", user.getSn());
            this.printRow(type, "BDTE", user.getBeginDate());
            this.printRow(type, "EDTE", user.getEndDate());
            this.printRow(type, "BLDT", user.getBeginLockDate());
            this.printRow(type, "ELDT", user.getEndLockDate());
            this.printRow(type, "DMSK", user.getDayMask());
            this.printRow(type, "TO  ", "" + user.getTimeout());
            this.printRow(type, "REST", "" + user.isReset());
            this.printTemporal(type, user, "USER");
            this.printAddress(type, user.getAddress(), "ADDR");
            this.printPhone(type, user.getPhones(), "PHNE");
            this.printPhone(type, user.getPhones(), "MOBL");
            if (CollectionUtils.isNotEmpty(user.getRoles())) {
                for (UserRole userRole : user.getRoles()) {
                    this.printSeparator();
                    this.printTemporal("R", userRole, "RBACROLE");
                    if (!CollectionUtils.isNotEmpty(userRole.getParents())) continue;
                    for (String parentRole : userRole.getParents()) {
                        this.printRow("R", "PRLE", parentRole);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(user.getAdminRoles())) {
                for (UserAdminRole userAdminRole : user.getAdminRoles()) {
                    this.printSeparator();
                    this.printTemporal("A", userAdminRole, "ADMINROLE");
                    this.printAdminRole("A", userAdminRole);
                }
            }
            if (PropUtil.isNotEmpty(user.getProperties())) {
                this.printSeparator();
                int ctr = 0;
                Enumeration<?> enumeration = user.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    String val = user.getProperty(key);
                    LOG.info("{}   KEY{} [{}]", new Object[]{type, ++ctr, key});
                    LOG.info("{}   VAL{} [{}]", new Object[]{type, ctr, val});
                }
            }
        }
    }

    private void printGroup(Group group) {
        String type = "G";
        if (group != null) {
            this.printSeparator();
            this.printRow(type, "GROUP DATA", group.getName());
            this.printRow(type, "NAME ", group.getName());
            this.printRow(type, "DESC", group.getDescription());
            this.printRow(type, "PROT", group.getProtocol());
            if (CollectionUtils.isNotEmpty(group.getMembers())) {
                int memctr = 0;
                for (String member : group.getMembers()) {
                    this.printRow(type, "MEMBER[" + ++memctr + "]", member);
                }
            }
            if (PropUtil.isNotEmpty(group.getProperties())) {
                int propctr = 0;
                Enumeration<?> e = group.getProperties().propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String val = group.getProperty(key);
                    this.printRow(type, "PROP[" + ++propctr + "]", key + "=" + val);
                }
            }
        }
    }

    private void printTemporal(String type, Constraint constraint, String label) {
        if (constraint != null) {
            this.printRow(type, "TYPE", label);
            this.printRow(type, "NAME", constraint.getName());
            this.printRow(type, "BTME", constraint.getBeginTime());
            this.printRow(type, "ETME", constraint.getEndTime());
            this.printRow(type, "BDTE", constraint.getBeginDate());
            this.printRow(type, "EDTE", constraint.getEndDate());
            this.printRow(type, "BLDT", constraint.getBeginLockDate());
            this.printRow(type, "ELDT", constraint.getEndLockDate());
            this.printRow(type, "DMSK", constraint.getDayMask());
            this.printRow(type, "TO  ", "" + constraint.getTimeout());
        }
    }

    private void printAddress(String type, Address address, String label) {
        if (address != null) {
            this.printRow(type, "TYPE", label);
            System.out.println(label);
            if (CollectionUtils.isNotEmpty(address.getAddresses())) {
                for (String addr : address.getAddresses()) {
                    this.printRow(type, "LINE", addr);
                }
            }
            this.printRow(type, "CITY", address.getCity());
            this.printRow(type, "PROV", address.getState());
            this.printRow(type, "ZIPC", address.getPostalCode());
            this.printRow(type, "PBOX", address.getPostOfficeBox());
        }
    }

    private void printPhone(String type, List<String> phones, String label) {
        if (phones != null) {
            this.printRow(type, "TYPE", label);
            for (String phone : phones) {
                this.printRow(type, "TELE", phone);
            }
        }
    }

    private void printAdminRole(String type, UserAdminRole ur) {
        if (ur != null) {
            this.printRow(type, "BEGR", ur.getBeginRange());
            this.printRow(type, "ENDR", ur.getEndRange());
            if (CollectionUtils.isNotEmpty(ur.getOsPSet())) {
                this.printRow(type, "POUS", "" + ur.getOsPSet());
            }
            if (CollectionUtils.isNotEmpty(ur.getOsUSet())) {
                this.printRow(type, "UOUS", "" + ur.getOsUSet());
            }
        }
    }

    private void printRow(String type, String name, String value) {
        LOG.info("{}   {} [{}]", new Object[]{type, name, value});
    }

    private void printSeparator() {
        LOG.info("------------------------------------------");
    }

    private boolean constructManagers() {
        String contextId = "HOME";
        boolean success = false;
        String tenant = System.getProperty("tenant");
        if (StringUtils.isNotEmpty((String)tenant) && !tenant.equals("${tenant}")) {
            contextId = tenant;
        }
        try {
            this.adminMgr = AdminMgrFactory.createInstance(contextId);
            this.reviewMgr = ReviewMgrFactory.createInstance(contextId);
            this.accessMgr = AccessMgrFactory.createInstance(contextId);
            this.accessMgr = AccessMgrFactory.createInstance(contextId);
            this.groupMgr = GroupMgrFactory.createInstance(contextId);
            this.delAdminMgr = DelAdminMgrFactory.createInstance(contextId);
            success = true;
        }
        catch (SecurityException se) {
            String error = "constructManagers caught SecurityException=" + se;
            LOG.error(error);
        }
        return success;
    }
}

