/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.parsers;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.parsers.OpenLdapSchemaParser;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.OpenLdapObjectIdentifierMacro;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaParser<T extends SchemaObject> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSchemaParser.class);
    protected OpenLdapSchemaParser fastParser = new OpenLdapSchemaParser();

    protected AbstractSchemaParser(Class<T> schemaObjectType, I18n errorCodeOnNull, I18n errorCodeOnParseExceptionWithPosition, I18n errorCodeOnParseException) {
    }

    public void setQuirksMode(boolean enabled) {
        this.fastParser.setQuirksMode(enabled);
    }

    public boolean isQuirksMode() {
        return this.fastParser.isQuirksMode();
    }

    public abstract T parse(String var1) throws ParseException;

    protected void updateSchemaName(SchemaObject schemaObject) {
        List<String> schemaExtension = schemaObject.getExtension("X-SCHEMA");
        if (schemaExtension != null) {
            String schemaName = schemaExtension.get(0);
            if (Strings.isEmpty((String)schemaName)) {
                schemaObject.setSchemaName("other");
            } else {
                schemaObject.setSchemaName(schemaName);
            }
        } else {
            schemaObject.setSchemaName("other");
        }
    }

    public Map<String, OpenLdapObjectIdentifierMacro> getObjectIdentifiers() {
        return this.fastParser.getObjectIdentifierMacros();
    }
}

