/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.modify;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddModifyRequestAttribute
extends GrammarAction<LdapMessageContainer<ModifyRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddModifyRequestAttribute.class);

    public AddModifyRequestAttribute() {
        super("Store Modify request operation type");
    }

    public void action(LdapMessageContainer<ModifyRequest> container) throws DecoderException {
        ModifyRequest modifyRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05123_TYPE_CANT_BE_NULL, (Object[])new Object[0]);
            LOG.error(msg);
            ModifyResponseImpl response = new ModifyResponseImpl(modifyRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, modifyRequest.getName(), null);
        }
        String type = Strings.utf8ToString((byte[])tlv.getValue().getData());
        DefaultAttribute currentAttribute = new DefaultAttribute(type);
        container.setCurrentAttribute((Attribute)currentAttribute);
        container.getCurrentModification().setAttribute((Attribute)currentAttribute);
        if (container.getCurrentModification().getOperation() == ModificationOperation.INCREMENT_ATTRIBUTE) {
            container.setGrammarEndAllowed(true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05128_MODIFYING_TYPE, (Object[])new Object[]{type}));
        }
    }
}

