/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.util.Strings;

public class IntermediateResponseDecorator
extends MessageDecorator<IntermediateResponse>
implements IntermediateResponse {
    private byte[] responseNameBytes;
    private int intermediateResponseLength;
    private byte[] encodedValueBytes;

    public IntermediateResponseDecorator(LdapApiService codec, IntermediateResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public String getResponseName() {
        return ((IntermediateResponse)this.getDecorated()).getResponseName();
    }

    public void setResponseName(String oid) {
        ((IntermediateResponse)this.getDecorated()).setResponseName(oid);
    }

    public byte[] getResponseValue() {
        return ((IntermediateResponse)this.getDecorated()).getResponseValue();
    }

    public void setResponseValue(byte[] value) {
        ((IntermediateResponse)this.getDecorated()).setResponseValue(value);
    }

    @Override
    public int computeLength() {
        this.intermediateResponseLength = 0;
        if (!Strings.isEmpty((String)this.getResponseName())) {
            this.responseNameBytes = Strings.getBytesUtf8((String)this.getResponseName());
            int responseNameLength = this.responseNameBytes.length;
            this.intermediateResponseLength += 1 + TLV.getNbBytes((int)responseNameLength) + responseNameLength;
        }
        this.encodedValueBytes = this.getResponseValue();
        if (this.encodedValueBytes != null) {
            this.intermediateResponseLength += 1 + TLV.getNbBytes((int)this.encodedValueBytes.length) + this.encodedValueBytes.length;
        }
        return 1 + TLV.getNbBytes((int)this.intermediateResponseLength) + this.intermediateResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)121);
            buffer.put(TLV.getBytes((int)this.intermediateResponseLength));
            if (this.responseNameBytes != null && this.responseNameBytes.length != 0) {
                buffer.put((byte)-128);
                buffer.put(TLV.getBytes((int)this.responseNameBytes.length));
                buffer.put(this.responseNameBytes);
            }
            if (this.encodedValueBytes != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes((int)this.encodedValueBytes.length));
                if (this.encodedValueBytes.length != 0) {
                    buffer.put(this.encodedValueBytes);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]), (Exception)boe);
        }
        return buffer;
    }
}

