/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp.io;

import java.nio.ByteBuffer;
import org.apache.directory.server.ntp.messages.LeapIndicatorType;
import org.apache.directory.server.ntp.messages.ModeType;
import org.apache.directory.server.ntp.messages.NtpMessage;
import org.apache.directory.server.ntp.messages.ReferenceIdentifier;

public class NtpMessageEncoder {
    public void encode(ByteBuffer byteBuffer, NtpMessage message) {
        byte header = 0;
        header = this.encodeLeapIndicator(message.getLeapIndicator(), header);
        header = this.encodeVersionNumber(message.getVersionNumber(), header);
        header = this.encodeMode(message.getMode(), header);
        byteBuffer.put(header);
        byteBuffer.put((byte)(message.getStratum().getOrdinal() & 0xFF));
        byteBuffer.put((byte)(message.getPollInterval() & 0xFF));
        byteBuffer.put((byte)(message.getPrecision() & 0xFF));
        byteBuffer.putInt(message.getRootDelay());
        byteBuffer.putInt(message.getRootDispersion());
        this.encodeReferenceIdentifier(message.getReferenceIdentifier(), byteBuffer);
        message.getReferenceTimestamp().writeTo(byteBuffer);
        message.getOriginateTimestamp().writeTo(byteBuffer);
        message.getReceiveTimestamp().writeTo(byteBuffer);
        message.getTransmitTimestamp().writeTo(byteBuffer);
    }

    private byte encodeLeapIndicator(LeapIndicatorType leapIndicator, byte header) {
        byte twoBits = (byte)(leapIndicator.getOrdinal() & 3);
        return (byte)(twoBits << 6 | header);
    }

    private byte encodeVersionNumber(int versionNumber, byte header) {
        byte threeBits = (byte)(versionNumber & 7);
        return (byte)(threeBits << 3 | header);
    }

    private byte encodeMode(ModeType mode, byte header) {
        byte threeBits = (byte)(mode.getOrdinal() & 7);
        return (byte)(threeBits | header);
    }

    private void encodeReferenceIdentifier(ReferenceIdentifier identifier, ByteBuffer byteBuffer) {
        char[] characters = identifier.getCode().toCharArray();
        for (int ii = 0; ii < characters.length; ++ii) {
            byteBuffer.put((byte)characters[ii]);
        }
    }
}

