/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Strings;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadKerberosTime<E extends Asn1Container>
extends GrammarAction<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadKerberosTime.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AbstractReadKerberosTime(String name) {
        super(name);
    }

    protected abstract void setKerberosTime(KerberosTime var1, E var2);

    @Override
    public final void action(E container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() != 15) {
            LOG.error(I18n.err(I18n.ERR_01308_ZERO_LENGTH_TLV, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_01309_EMPTY_TLV, new Object[0]));
        }
        BerValue value = tlv.getValue();
        String date = Strings.utf8ToString(value.getData());
        try {
            KerberosTime krbTime = new KerberosTime(date);
            if (IS_DEBUG) {
                LOG.debug("decoded kerberos time is : {}", (Object)krbTime);
            }
            this.setKerberosTime(krbTime, container);
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_01308_ZERO_LENGTH_TLV, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_01309_EMPTY_TLV, new Object[0]));
        }
    }
}

