/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.net.SocketAddress;
import java.security.Principal;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.i18n.I18n;

public final class LdapPrincipal
implements Principal,
Cloneable {
    private Dn dn = Dn.EMPTY_DN;
    private AuthenticationLevel authenticationLevel;
    private byte[][] userPasswords;
    private SchemaManager schemaManager;
    private SocketAddress clientAddress;
    private SocketAddress serverAddress;

    public LdapPrincipal(SchemaManager schemaManager, Dn dn, AuthenticationLevel authenticationLevel) {
        this.schemaManager = schemaManager;
        this.dn = dn;
        if (!dn.isSchemaAware()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_436, new Object[0]));
        }
        this.authenticationLevel = authenticationLevel;
        this.userPasswords = null;
    }

    public LdapPrincipal(SchemaManager schemaManager, Dn dn, AuthenticationLevel authenticationLevel, byte[] userPassword) {
        this.dn = dn;
        this.authenticationLevel = authenticationLevel;
        this.userPasswords = new byte[1][];
        this.userPasswords[0] = new byte[userPassword.length];
        System.arraycopy(userPassword, 0, this.userPasswords[0], 0, userPassword.length);
        this.schemaManager = schemaManager;
    }

    public LdapPrincipal() {
        this.authenticationLevel = AuthenticationLevel.NONE;
        this.userPasswords = null;
    }

    public LdapPrincipal(SchemaManager schemaManager) {
        this.authenticationLevel = AuthenticationLevel.NONE;
        this.userPasswords = null;
        this.schemaManager = schemaManager;
    }

    public Dn getDn() {
        return this.dn;
    }

    @Override
    public String getName() {
        return this.dn.getNormName();
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public byte[][] getUserPasswords() {
        return this.userPasswords;
    }

    public void setUserPassword(byte[] ... userPasswords) {
        this.userPasswords = new byte[userPasswords.length][];
        int pos = 0;
        for (byte[] userPassword : userPasswords) {
            this.userPasswords[pos] = new byte[userPassword.length];
            System.arraycopy(userPassword, 0, this.userPasswords[pos], 0, userPassword.length);
            ++pos;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LdapPrincipal clone = (LdapPrincipal)super.clone();
        if (this.userPasswords != null) {
            clone.setUserPassword(this.userPasswords);
        }
        return clone;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        if (!this.dn.isSchemaAware()) {
            try {
                this.dn = new Dn(schemaManager, this.dn);
            }
            catch (LdapInvalidDnException ldapInvalidDnException) {
                // empty catch block
            }
        }
    }

    public SocketAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(SocketAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    public SocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(SocketAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.dn.isSchemaAware()) {
            sb.append("(n)");
        }
        sb.append("['");
        sb.append(this.dn.getName());
        sb.append("'");
        if (this.clientAddress != null) {
            sb.append(", client@");
            sb.append(this.clientAddress);
        }
        if (this.serverAddress != null) {
            sb.append(", server@");
            sb.append(this.serverAddress);
        }
        sb.append("]");
        return sb.toString();
    }
}

