/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.cursor;

import java.io.IOException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyCursor<E>
extends AbstractCursor<E> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());

    public EmptyCursor() {
        if (LOG_CURSOR.isDebugEnabled()) {
            LOG_CURSOR.debug(I18n.msg(I18n.MSG_13103_CREATING_EMPTY_CURSOR, this));
        }
    }

    @Override
    public boolean available() {
        return false;
    }

    @Override
    public void before(E element) throws LdapException, CursorException {
        this.checkNotClosed();
    }

    @Override
    public void after(E element) throws LdapException, CursorException {
        this.checkNotClosed();
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed();
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed();
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public E get() throws CursorException {
        this.checkNotClosed();
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_13104_EMPTY_CURSOR, new Object[0]));
    }

    @Override
    public void close() throws IOException {
        if (LOG_CURSOR.isDebugEnabled()) {
            LOG_CURSOR.debug(I18n.msg(I18n.MSG_13100_CLOSING_EMPTY_CURSOR, this));
        }
        super.close();
    }

    @Override
    public void close(Exception cause) throws IOException {
        if (LOG_CURSOR.isDebugEnabled()) {
            LOG_CURSOR.debug(I18n.msg(I18n.MSG_13100_CLOSING_EMPTY_CURSOR, this));
        }
        super.close(cause);
    }
}

