/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.spi.invocation;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.deltaspike.core.util.interceptor.AbstractInvocationContext;
import org.apache.deltaspike.proxy.spi.invocation.DeltaSpikeProxyInvocationHandler;
import org.apache.deltaspike.proxy.spi.invocation.DeltaSpikeProxyInvocationWrapperException;

@Typed
public class DeltaSpikeProxyInvocationContext<T, H>
extends AbstractInvocationContext<T> {
    protected List<Interceptor<H>> interceptors;
    protected int interceptorIndex;
    protected DeltaSpikeProxyInvocationHandler invocationHandler;
    protected BeanManager beanManager;
    protected boolean proceedOriginal;
    protected Object proceedOriginalReturnValue;

    public DeltaSpikeProxyInvocationContext(DeltaSpikeProxyInvocationHandler invocationHandler, BeanManager beanManager, List<Interceptor<H>> interceptors, T target, Method method, Object[] parameters, Object timer) {
        super(target, method, parameters, timer);
        this.invocationHandler = invocationHandler;
        this.interceptors = interceptors;
        this.beanManager = beanManager;
        this.interceptorIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed() throws Exception {
        if (this.proceedOriginal) {
            return null;
        }
        if (this.interceptors.size() > this.interceptorIndex) {
            Object object;
            block9: {
                CreationalContext creationalContext;
                block10: {
                    Interceptor<H> interceptor = null;
                    creationalContext = null;
                    Object interceptorInstance = null;
                    try {
                        interceptor = this.interceptors.get(this.interceptorIndex++);
                        creationalContext = this.beanManager.createCreationalContext(interceptor);
                        interceptorInstance = interceptor.create(creationalContext);
                        object = interceptor.intercept(InterceptionType.AROUND_INVOKE, interceptorInstance, (InvocationContext)this);
                        if (creationalContext == null) break block9;
                        if (interceptorInstance == null || interceptor == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (creationalContext != null) {
                            if (interceptorInstance != null && interceptor != null) {
                                interceptor.destroy(interceptorInstance, creationalContext);
                            }
                            creationalContext.release();
                        }
                        throw throwable;
                    }
                    interceptor.destroy(interceptorInstance, creationalContext);
                }
                creationalContext.release();
            }
            return object;
        }
        try {
            this.proceedOriginal = true;
            this.proceedOriginalReturnValue = this.invocationHandler.proceed(this.target, this.method, this.parameters);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DeltaSpikeProxyInvocationWrapperException(e);
        }
        return this.proceedOriginalReturnValue;
    }

    public boolean isProceedOriginal() {
        return this.proceedOriginal;
    }

    public Object getProceedOriginalReturnValue() {
        return this.proceedOriginalReturnValue;
    }
}

