/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.criteria.predicate;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.deltaspike.data.impl.criteria.predicate.PredicateBuilder;

public class In<P, V>
implements PredicateBuilder<P> {
    private final SingularAttribute<? super P, V> singular;
    private final V[] values;

    public In(SingularAttribute<? super P, V> singular, V[] values) {
        this.singular = singular;
        this.values = Arrays.copyOf(values, values.length);
    }

    @Override
    public List<Predicate> build(CriteriaBuilder builder, Path<P> path) {
        Path p = path.get(this.singular);
        CriteriaBuilder.In in = builder.in((Expression)p);
        for (V value : this.values) {
            if (value == null) continue;
            in.value(value);
        }
        return Arrays.asList(in);
    }

    SingularAttribute<? super P, V> getSingular() {
        return this.singular;
    }

    V[] getValues() {
        return this.values;
    }
}

