/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import jakarta.enterprise.inject.Typed;
import java.util.HashMap;
import java.util.Map;
import org.apache.deltaspike.core.impl.config.BaseConfigSource;
import org.apache.deltaspike.core.impl.util.JndiUtils;

@Typed
class LocalJndiConfigSource
extends BaseConfigSource {
    private static final String BASE_NAME = "java:comp/env/deltaspike/";

    LocalJndiConfigSource() {
        this.initOrdinal(200);
    }

    public String getPropertyValue(String key) {
        try {
            return JndiUtils.lookup(this.getJndiKey(key), String.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getJndiKey(String key) {
        if (key.startsWith("java:comp/env")) {
            return key;
        }
        return BASE_NAME + key;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(JndiUtils.list(BASE_NAME, String.class));
        result.putAll(JndiUtils.list("java:comp/env", String.class));
        return result;
    }

    public String getConfigName() {
        return BASE_NAME;
    }

    public boolean isScannable() {
        return false;
    }
}

