/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import jakarta.enterprise.inject.Typed;
import java.lang.reflect.Constructor;

@Typed
public abstract class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static RuntimeException throwAsRuntimeException(Throwable throwable) {
        new ExceptionHelper().throwException(throwable);
        return null;
    }

    public static void changeAndThrowException(Throwable throwable, String customMessage) {
        Throwable newThrowable = ExceptionUtils.createNewException(throwable, customMessage);
        new ExceptionHelper().throwException(newThrowable);
    }

    private static Throwable createNewException(Throwable throwable, String message) {
        Class<?> throwableClass = throwable.getClass();
        try {
            Constructor<?> constructor = throwableClass.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            Throwable result = (Throwable)constructor.newInstance(message);
            result.initCause(throwable.getCause());
            return result;
        }
        catch (Exception e) {
            return throwable;
        }
    }

    private static class ExceptionHelper<T extends Throwable> {
        private ExceptionHelper() {
        }

        private void throwException(Throwable exception) throws T {
            try {
                throw exception;
            }
            catch (ClassCastException e) {
                if (e.getStackTrace()[0].toString().contains(this.getClass().getName())) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new RuntimeException(exception);
                }
                throw e;
            }
        }
    }
}

