/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.message;

import jakarta.enterprise.inject.Typed;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.deltaspike.core.api.message.Message;
import org.apache.deltaspike.core.impl.message.MessageBundleInvocationHandler;

@Typed
public class JsfMessageBundleInvocationHandler
implements InvocationHandler {
    private final FacesMessage.Severity severity;
    private final String clientId;
    private final MessageBundleInvocationHandler invocationHandler;

    public JsfMessageBundleInvocationHandler(FacesMessage.Severity severity, String clientId, MessageBundleInvocationHandler invocationHandler) {
        this.severity = severity;
        this.clientId = clientId;
        this.invocationHandler = invocationHandler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object message = this.invocationHandler.invoke(proxy, method, args);
        if (this.severity == null) {
            if (message instanceof Message) {
                return message;
            }
            return this.getMessageCategory(message, "summary");
        }
        String summary = this.getMessageCategory(message, "summary");
        String detail = this.getMessageCategory(message, "detail");
        FacesContext.getCurrentInstance().addMessage(this.clientId, new FacesMessage(this.severity, summary, detail));
        return message;
    }

    private String getMessageCategory(Object message, String category) {
        if (message == null) {
            return null;
        }
        if (message instanceof String) {
            return (String)message;
        }
        if (message instanceof Message) {
            return ((Message)message).toString(category);
        }
        throw new IllegalArgumentException("message must be of either type String or Message but was: " + message.getClass() + " value: " + message);
    }
}

