/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.spi.descriptor.xml;

import jakarta.enterprise.inject.Typed;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.deltaspike.jpa.spi.descriptor.xml.AbstractEntityDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.Descriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.DescriptorReader;
import org.apache.deltaspike.jpa.spi.descriptor.xml.EntityDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.EntityMappingsDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.MappedSuperclassDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Typed
public class EntityMappingsDescriptorParser
extends DescriptorReader {
    public static final String DEFAULT_ORM_PATH = "META-INF/orm.xml";

    public EntityMappingsDescriptor readAll(String baseUrl, String resource) throws IOException {
        Document document = this.read(baseUrl, resource).getDocument();
        return this.readFromDocument(document);
    }

    public EntityMappingsDescriptor readDefaultOrm(String baseUrl) throws IOException {
        try {
            Descriptor desc = this.read(baseUrl, DEFAULT_ORM_PATH);
            return this.readFromDocument(desc.getDocument());
        }
        catch (Exception e) {
            return new EntityMappingsDescriptor(Collections.emptyList(), Collections.emptyList(), null);
        }
    }

    protected EntityMappingsDescriptor readFromDocument(Document doc) {
        String packageName = this.parsePackageName(doc);
        List<MappedSuperclassDescriptor> mappedSuperclassDescriptors = this.parseMappedSuperclassDescriptors(doc, packageName);
        List<EntityDescriptor> entityDescriptors = this.parseEntityDescriptors(doc, packageName);
        return new EntityMappingsDescriptor(mappedSuperclassDescriptors, entityDescriptors, packageName);
    }

    protected String extractNodeAttribute(Element element, String childName, String attribute) {
        NodeList list = element.getElementsByTagName(childName);
        if (list.getLength() == 0) {
            return null;
        }
        return this.extractAttribute(list.item(0), attribute);
    }

    protected String extractAttribute(Node item, String name) {
        Node node = item.getAttributes().getNamedItem(name);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    protected String[] extractNodeAttributes(Element element, String childName, String attribute) {
        NodeList list = element.getElementsByTagName(childName);
        if (list.getLength() == 0) {
            return null;
        }
        return this.extractAttributes(list, attribute);
    }

    protected String[] extractAttributes(NodeList list, String name) {
        String[] values = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i).getAttributes().getNamedItem(name);
            if (node == null) continue;
            if (values == null) {
                values = new String[list.getLength()];
            }
            values[i] = node.getTextContent();
        }
        return values;
    }

    protected String extractNodeContent(Element element, String name) {
        NodeList list = element.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(0).getTextContent();
    }

    protected String parsePackageName(Document doc) {
        return this.extractNodeContent(doc.getDocumentElement(), "package");
    }

    protected List<MappedSuperclassDescriptor> parseMappedSuperclassDescriptors(Document doc, String packageName) {
        LinkedList<MappedSuperclassDescriptor> result = new LinkedList<MappedSuperclassDescriptor>();
        NodeList mappings = doc.getElementsByTagName("mapped-superclass");
        for (int i = 0; i < mappings.getLength(); ++i) {
            Node node = mappings.item(i);
            MappedSuperclassDescriptor entityDescriptor = new MappedSuperclassDescriptor();
            this.parseCommonEntityDescriptorAttributes(packageName, entityDescriptor, node);
            result.add(entityDescriptor);
        }
        return result;
    }

    protected List<EntityDescriptor> parseEntityDescriptors(Document doc, String packageName) {
        LinkedList<EntityDescriptor> result = new LinkedList<EntityDescriptor>();
        NodeList mappings = doc.getElementsByTagName("entity");
        for (int i = 0; i < mappings.getLength(); ++i) {
            Node node = mappings.item(i);
            EntityDescriptor entityDescriptor = new EntityDescriptor();
            this.parseCommonEntityDescriptorAttributes(packageName, entityDescriptor, node);
            entityDescriptor.setTableName(this.extractNodeAttribute((Element)node, "table", "name"));
            result.add(entityDescriptor);
        }
        return result;
    }

    protected void parseCommonEntityDescriptorAttributes(String packageName, AbstractEntityDescriptor entityDescriptor, Node node) {
        String idClass;
        entityDescriptor.setName(this.extractAttribute(node, "name"));
        entityDescriptor.setVersion(this.extractNodeAttribute((Element)node, "version", "name"));
        String[] id = this.extractNodeAttributes((Element)node, "id", "name");
        if (id != null) {
            entityDescriptor.setId(id);
        } else {
            String embeddedId = this.extractNodeAttribute((Element)node, "embedded-id", "name");
            if (embeddedId != null) {
                entityDescriptor.setId(new String[]{embeddedId});
            }
        }
        String className = this.extractAttribute(node, "class");
        if (className != null) {
            try {
                entityDescriptor.setEntityClass(Class.forName(this.buildClassName(className, packageName)));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Can't get class " + this.buildClassName(className, packageName), e);
            }
        }
        if ((idClass = this.extractNodeAttribute((Element)node, "id-class", "class")) != null) {
            try {
                entityDescriptor.setIdClass(Class.forName(this.buildClassName(idClass, packageName)));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Can't get class " + this.buildClassName(className, packageName), e);
            }
        }
    }

    protected String buildClassName(String clazzName, String packageName) {
        if (clazzName == null && packageName == null) {
            return null;
        }
        return packageName != null && !this.isClassNameQualified(clazzName) ? packageName + "." + clazzName : clazzName;
    }

    protected boolean isClassNameQualified(String name) {
        return name.contains(".");
    }
}

