/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.outlet.OutletSaxHandler;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.qname.QualifiedName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class JavaOutletSaxHandler
extends OutletSaxHandler {
    private static Log log = LogFactory.getLog(JavaOutletSaxHandler.class);
    private String propertyName;
    private StringBuilder propertyValue;
    private int level = 0;

    public JavaOutletSaxHandler(QualifiedName outletName, ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) throws SAXException {
        super(outletName, configurationProvider, unitDescriptor, configurationHandlers);
    }

    @Override
    protected Outlet createOutlet(QualifiedName outletName, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        Outlet result;
        Class<?> outletClass;
        String className;
        if (outletName == null) {
            String nameAttribute = attributes.getValue("name");
            if (nameAttribute == null) {
                throw new SAXException("The attribute name must be set on the element " + rawName + " for Java Outlets");
            }
            outletName = new QualifiedName(nameAttribute);
        }
        if ((className = attributes.getValue("class")) == null) {
            throw new SAXException("The attribute class must be set on the element " + rawName + " for java Outlets");
        }
        try {
            ClassLoader classLoader = this.getUnitDescriptor().getClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            outletClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new SAXException("Error  while initializing the java outlet " + String.valueOf(outletName) + " : Could not load class " + className, e);
        }
        catch (ExceptionInInitializerError e) {
            log.error((Object)("Error  while initializing the java outlet " + String.valueOf(outletName) + " : Could not initialize class " + className + " : " + e.getMessage()));
            throw e;
        }
        catch (LinkageError e) {
            log.error((Object)("Error  while initializing the java outlet " + String.valueOf(outletName) + " : Could not link class " + className + " : " + e.getMessage()));
            throw e;
        }
        try {
            Constructor<?> constructor = outletClass.getConstructor(QualifiedName.class);
            result = (Outlet)constructor.newInstance(outletName);
        }
        catch (NoSuchMethodException e) {
            throw new SAXException("Error  while instantiating the java outlet " + String.valueOf(outletName) + " : The class " + className + " has no constructor which takes a qualified name", e);
        }
        catch (ClassCastException e) {
            throw new SAXException("Error  while instantiating the java outlet " + String.valueOf(outletName) + " : The class " + className + " is not an instance of " + Outlet.class.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException("Error  while instantiating the java outlet " + String.valueOf(outletName) + " : The constructor of class " + className + " could not be accessed", e);
        }
        catch (InvocationTargetException e) {
            throw new SAXException("Error  while instantiating the java outlet " + String.valueOf(outletName) + " : The constructor of class " + className + " could not be called", e);
        }
        catch (InstantiationException e) {
            throw new SAXException("Error  while instantiating the java outlet " + String.valueOf(outletName) + " : The class " + className + " represents an abstract class, an interface, an array class, a primitive type, or void, or the class has no parameterless constructor, or the instantiation fails for some other reason.", e);
        }
        catch (SecurityException e) {
            throw new SAXException("Error  while instantiating the java outlet " + String.valueOf(outletName) + " : The security manager denies instantiation", e);
        }
        return result;
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        ++this.level;
        if (this.level == 2 && "mergepoint".equals(rawName) || super.isProcessingMergepointTag()) {
            super.startElement(uri, localName, rawName, attributes);
        } else if (this.level == 2 && "input".equals(rawName)) {
            super.startElement(uri, localName, rawName, attributes);
        } else if (this.level > 1) {
            this.propertyName = rawName;
            this.propertyValue = new StringBuilder();
        } else {
            super.startElement(uri, localName, rawName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        --this.level;
        if (this.propertyName != null) {
            if (!PropertyUtils.isWriteable((Object)this.getOutlet(), (String)this.propertyName)) {
                throw new SAXException("No setter found for property " + this.propertyName + " in class " + this.getOutlet().getClass().getName());
            }
            try {
                BeanUtils.copyProperty((Object)this.getOutlet(), (String)this.propertyName, (Object)this.propertyValue.toString());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SAXException("error while setting Property " + this.propertyName + " for java outlet " + String.valueOf(this.getOutlet().getName()) + " with value " + this.propertyValue.toString(), e);
            }
            this.propertyName = null;
            this.propertyValue = null;
        } else {
            super.endElement(uri, localName, rawName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.propertyName == null) {
            return;
        }
        for (int i = start; i < start + length; ++i) {
            this.propertyValue.append(ch[i]);
        }
    }
}

