/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.platform;

import java.util.Arrays;
import java.util.Date;
import org.apache.torque.templates.platform.PlatformDefaultImpl;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;

public class PlatformMysqlImpl
extends PlatformDefaultImpl {
    private static final String DATE_FORMAT = "''yyyy-MM-dd''";
    private static final String TIMESTAMP_FORMAT = "''yyyy-MM-dd HH:mm:ss.SSS''";

    public PlatformMysqlImpl() {
        this.initialize();
    }

    private void initialize() {
        this.setSchemaTypeToSqlTypeMapping(SchemaType.NUMERIC, new SqlType("DECIMAL"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.LONGVARCHAR, new SqlType("MEDIUMTEXT"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.TIMESTAMP, new SqlType("DATETIME"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BINARY, new SqlType("BLOB"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.VARBINARY, new SqlType("MEDIUMBLOB"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.LONGVARBINARY, new SqlType("LONGBLOB"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BLOB, new SqlType("LONGBLOB"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.CLOB, new SqlType("LONGTEXT"));
    }

    @Override
    public String getAutoIncrement() {
        return "AUTO_INCREMENT";
    }

    @Override
    public boolean hasSize(String sqlType) {
        return !Arrays.asList("MEDIUMTEXT", "LONGTEXT", "BLOB", "MEDIUMBLOB", "LONGBLOB").contains(sqlType);
    }

    @Override
    public boolean hasScale(String sqlType) {
        return Arrays.asList("TIMESTAMP", "DATETIME", "DATE", "TIME").contains(sqlType);
    }

    @Override
    protected boolean escapeBackslashes() {
        return true;
    }

    @Override
    public String getDateString(Date date) {
        return this.formatDateTimeString(date, DATE_FORMAT);
    }

    @Override
    public String getTimestampString(Date date) {
        return this.formatDateTimeString(date, TIMESTAMP_FORMAT);
    }

    @Override
    public boolean hasUniqueConstraintSize() {
        return true;
    }
}

