/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.AbstractConfigurationProvider;
import org.apache.torque.generator.configuration.ClasspathConfigurationProvider;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.DirectoryConfigurationProvider;
import org.apache.torque.generator.configuration.JarConfigurationProvider;
import org.apache.torque.generator.configuration.UnitConfiguration;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.controller.ControlConfiguration;
import org.apache.torque.generator.configuration.controller.ControlConfigurationXmlParser;
import org.apache.torque.generator.configuration.controller.Output;
import org.apache.torque.generator.configuration.option.OptionsConfiguration;
import org.apache.torque.generator.configuration.outlet.OutletConfiguration;
import org.apache.torque.generator.configuration.outlet.OutletConfigurationXmlParser;
import org.apache.torque.generator.configuration.source.EntityReferences;
import org.apache.torque.generator.option.Option;
import org.apache.torque.generator.option.Options;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.qname.QualifiedName;

class UnitConfigurationReader {
    private static Log log = LogFactory.getLog(UnitConfigurationReader.class);

    UnitConfigurationReader() {
    }

    public UnitConfiguration read(UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) throws ConfigurationException {
        if (unitDescriptor == null) {
            throw new NullPointerException("unitDescriptor must not be null");
        }
        if (configurationHandlers == null) {
            throw new NullPointerException("configurationHandlers must not be null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start reading unitConfiguration for unit " + this.getUnitDisplayName(unitDescriptor)));
        }
        UnitConfiguration unitConfiguration = new UnitConfiguration();
        unitConfiguration.setConfigurationHandlers(configurationHandlers);
        unitConfiguration.setOutputDirectoryMap(unitDescriptor.getProjectPaths().getOutputDirectoryMap());
        unitConfiguration.setWorkDirectory(unitDescriptor.getProjectPaths().getWorkDirectory());
        unitConfiguration.setCacheDirectory(unitDescriptor.getProjectPaths().getCacheDirectory());
        unitConfiguration.setOverrideSourceProvider(unitDescriptor.getOverrideSourceProvider());
        unitConfiguration.setClassLoader(unitDescriptor.getClassLoader());
        unitConfiguration.setRunOnlyOnSourceChange(unitDescriptor.isRunOnlyOnSourceChange());
        StringBuilder name = new StringBuilder().append(unitDescriptor.getPackaging().toString()).append(":");
        if (unitDescriptor.getProjectPaths().getConfigurationPackage() != null) {
            name.append(unitDescriptor.getProjectPaths().getConfigurationPackage());
        } else {
            name.append(unitDescriptor.getProjectPaths().getConfigurationPath());
        }
        unitConfiguration.setTemplateSetName(name.toString());
        ConfigurationProvider configurationProvider = this.createConfigurationProvider(unitDescriptor);
        this.readControlConfiguration(unitConfiguration, unitDescriptor, configurationHandlers, configurationProvider);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start reading outlet configuration");
        }
        OutletConfiguration outletConfiguration = new OutletConfigurationXmlParser().readOutletConfiguration(configurationProvider, configurationHandlers, unitDescriptor);
        unitConfiguration.setOutletConfiguration(outletConfiguration);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sucessfully read unitConfiguration for unit " + this.getUnitDisplayName(unitDescriptor)));
        }
        if (unitDescriptor.getInheritsFrom() == null) {
            outletConfiguration = unitConfiguration.getOutletConfiguration();
            outletConfiguration.resolveMergepointMappings();
            return unitConfiguration;
        }
        UnitConfiguration inherited = this.read(unitDescriptor.getInheritsFrom(), configurationHandlers);
        unitConfiguration.getLoglevel().apply();
        this.mergeInheritedOutletConfiguration(unitDescriptor, unitConfiguration, inherited);
        this.mergeInheritedOptionConfiguration(unitConfiguration, inherited);
        this.mergeInheritedOutputFiles(unitConfiguration, inherited);
        this.mergeInheritedEntityRefernces(unitConfiguration, inherited);
        return unitConfiguration;
    }

    private void mergeInheritedOutputFiles(UnitConfiguration unitConfiguration, UnitConfiguration inheritedConfiguration) {
        ArrayList<Output> outputFiles = new ArrayList<Output>();
        HashSet<QualifiedName> qualifiedNames = new HashSet<QualifiedName>();
        for (Output output : inheritedConfiguration.getOutputList()) {
            outputFiles.add(output);
            qualifiedNames.add(output.getName());
        }
        for (Output output : unitConfiguration.getOutputList()) {
            if (qualifiedNames.contains(output.getName())) {
                Iterator addedOutputIt = outputFiles.iterator();
                while (addedOutputIt.hasNext()) {
                    if (!((Output)addedOutputIt.next()).getName().equals(output.getName())) continue;
                    addedOutputIt.remove();
                    log.info((Object)("Output with name " + String.valueOf(output.getName()) + " is overridden in child and is replaced."));
                    break;
                }
            }
            outputFiles.add(output);
        }
        unitConfiguration.setOutputList(outputFiles);
    }

    private void mergeInheritedEntityRefernces(UnitConfiguration unitConfiguration, UnitConfiguration inheritedConfiguration) {
        EntityReferences entityReferences = unitConfiguration.getEntityReferences();
        Map<String, byte[]> inheritedReferences = inheritedConfiguration.getEntityReferences().getEntityReferences();
        for (Map.Entry<String, byte[]> inheritedReference : inheritedReferences.entrySet()) {
            String systemId = inheritedReference.getKey();
            if (!entityReferences.containsSystemId(systemId)) {
                entityReferences.addEntityReference(systemId, inheritedReference.getValue());
                log.debug((Object)("entityReferences with system id " + systemId + " is inherited from the parent."));
                continue;
            }
            log.debug((Object)("entityReferences with system id " + systemId + " is overidden in the child."));
        }
    }

    private void mergeInheritedOptionConfiguration(UnitConfiguration unitConfiguration, UnitConfiguration inheritedConfiguration) {
        Options options = unitConfiguration.getOptions();
        Options inheritedOptions = inheritedConfiguration.getOptions();
        for (Map.Entry<QualifiedName, Option> entry : inheritedOptions.getGlobalScope().entrySet()) {
            QualifiedName optionName = entry.getKey();
            Option option = entry.getValue();
            if (options.getGlobalScope().containsKey(optionName)) continue;
            options.setGlobalOption(option);
        }
    }

    private void mergeInheritedOutletConfiguration(UnitDescriptor unitDescriptor, UnitConfiguration unitConfiguration, UnitConfiguration inheritedConfiguration) throws ConfigurationException {
        OutletConfiguration outletConfiguration = unitConfiguration.getOutletConfiguration();
        OutletConfiguration inheritedOutletConfiguration = inheritedConfiguration.getOutletConfiguration();
        Map<QualifiedName, Outlet> inheritedOutlets = inheritedOutletConfiguration.getOutlets();
        for (Map.Entry<QualifiedName, Outlet> entry : inheritedOutlets.entrySet()) {
            if (outletConfiguration.outletExists(entry.getKey())) continue;
            outletConfiguration.addOutlet(entry.getValue(), unitDescriptor);
        }
        outletConfiguration.resolveMergepointMappings();
    }

    private void readControlConfiguration(UnitConfiguration unitConfiguration, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers, ConfigurationProvider configurationProvider) throws ConfigurationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start reading control configuration");
        }
        ControlConfiguration controlConfiguration = new ControlConfigurationXmlParser().readControllerConfiguration(configurationProvider, unitDescriptor, configurationHandlers);
        if (unitDescriptor.getLoglevel() == null) {
            unitConfiguration.setLoglevel(controlConfiguration.getLoglevel());
            controlConfiguration.getLoglevel().apply();
        }
        unitConfiguration.setOutputList(controlConfiguration.getOutputFiles());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start reading options");
        }
        ArrayList<OptionsConfiguration> optionConfigurations = new ArrayList<OptionsConfiguration>();
        optionConfigurations.addAll(controlConfiguration.getOptionsConfigurations());
        if (unitDescriptor.getOverrideOptions() != null) {
            optionConfigurations.add(unitDescriptor.getOverrideOptions());
        }
        Options options = new Options();
        for (OptionsConfiguration optionConfiguration : optionConfigurations) {
            options.addGlobalOptions(optionConfiguration.getOptions(configurationProvider));
        }
        unitConfiguration.setOptions(options);
        log.debug((Object)"End reading options");
        unitConfiguration.setEntityReferences(controlConfiguration.getEntityReferences());
        unitConfiguration.setDefaultOutputEncoding(unitDescriptor.getDefaultOutputEncoding());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Control configuration successfully read.");
        }
    }

    private ConfigurationProvider createConfigurationProvider(UnitDescriptor unitDescriptor) throws ConfigurationException {
        AbstractConfigurationProvider configurationProvider;
        if (UnitDescriptor.Packaging.DIRECTORY == unitDescriptor.getPackaging()) {
            configurationProvider = new DirectoryConfigurationProvider(unitDescriptor.getProjectPaths(), unitDescriptor.getConfigurationPaths());
        } else if (UnitDescriptor.Packaging.JAR == unitDescriptor.getPackaging()) {
            configurationProvider = new JarConfigurationProvider(unitDescriptor.getProjectPaths(), unitDescriptor.getConfigurationPaths());
        } else if (UnitDescriptor.Packaging.CLASSPATH == unitDescriptor.getPackaging()) {
            configurationProvider = new ClasspathConfigurationProvider(unitDescriptor);
        } else {
            throw new ConfigurationException("Unknown Unit type " + String.valueOf((Object)unitDescriptor.getPackaging()));
        }
        return configurationProvider;
    }

    private String getUnitDisplayName(UnitDescriptor unitDescriptor) {
        if (UnitDescriptor.Packaging.CLASSPATH == unitDescriptor.getPackaging()) {
            return unitDescriptor.getProjectPaths().getConfigurationPackage();
        }
        return unitDescriptor.getProjectPaths().getConfigurationPath().toString();
    }
}

