/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer;

import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.stream.FileSource;
import org.apache.torque.generator.source.stream.StreamSourceFormat;
import org.apache.torque.generator.source.stream.XmlSourceFormat;
import org.apache.torque.generator.source.transform.SourceElementToModelTransformer;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.model.Database;
import org.apache.torque.templates.model.ExternalSchema;
import org.apache.torque.templates.transformer.om.DatabaseAttributeName;
import org.apache.torque.templates.transformer.om.DatabaseChildElementName;
import org.apache.torque.templates.transformer.om.mapInit.DatabaseMapInitTransformer;

public class LoadExternalSchemaTransformer
implements SourceTransformer {
    private static Log log = LogFactory.getLog(LoadExternalSchemaTransformer.class);
    private File baseDir;
    private final SourceElementToModelTransformer toModelTransformer = new SourceElementToModelTransformer(Database.class);

    public LoadExternalSchemaTransformer() {
    }

    public LoadExternalSchemaTransformer(File baseDir) {
        this.baseDir = baseDir;
    }

    public SourceElement transform(Object modelRoot, ControllerState controllerState) throws SourceTransformerException {
        SourceElement allViews;
        SourceElement root = (SourceElement)modelRoot;
        List externalSchemaElementList = root.getChildren((SourceElementName)TorqueSchemaElementName.EXTERNAL_SCHEMA);
        SourceElement allTables = root.getChild((SourceElementName)DatabaseChildElementName.ALL_TABLES);
        if (allTables == null) {
            allTables = new SourceElement((SourceElementName)DatabaseChildElementName.ALL_TABLES);
            root.getChildren().add(allTables);
        }
        if ((allViews = root.getChild((SourceElementName)DatabaseChildElementName.ALL_VIEWS)) == null) {
            allViews = new SourceElement((SourceElementName)DatabaseChildElementName.ALL_VIEWS);
            root.getChildren().add(allViews);
        }
        String rootDatabaseName = (String)root.getAttribute((SourceAttributeName)DatabaseAttributeName.ROOT_DATABASE_NAME);
        for (SourceElement externalSchemaElement : externalSchemaElementList) {
            File externalSchemaBaseDir;
            if (this.baseDir == null) {
                File currentSourceFile = controllerState.getSourceFile();
                externalSchemaBaseDir = currentSourceFile.getParentFile();
            } else {
                externalSchemaBaseDir = this.baseDir;
            }
            String relativePath = externalSchemaElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FILENAME).toString();
            File externalSchemaPath = new File(externalSchemaBaseDir, relativePath);
            try {
                FileSource fileSource = new FileSource((StreamSourceFormat)new XmlSourceFormat(), externalSchemaPath, controllerState);
                SourceElement externalSchemaRootElement = fileSource.getRootElement();
                externalSchemaRootElement.setAttribute((SourceAttributeName)DatabaseAttributeName.ROOT_DATABASE_NAME, (Object)rootDatabaseName);
                DatabaseMapInitTransformer.setDatabaseMapInitClassNameAttributes(externalSchemaRootElement, rootDatabaseName, controllerState);
                this.transform(externalSchemaRootElement, controllerState);
                externalSchemaElement.getChildren().add(externalSchemaRootElement);
                SourceElement externalAllTables = externalSchemaRootElement.getChild((SourceElementName)DatabaseChildElementName.ALL_TABLES);
                for (SourceElement externalTable : externalAllTables.getChildren((SourceElementName)TorqueSchemaElementName.TABLE)) {
                    allTables.getChildren().add(externalTable);
                }
                for (SourceElement externalView : externalAllTables.getChildren((SourceElementName)TorqueSchemaElementName.VIEW)) {
                    allViews.getChildren().add(externalView);
                }
            }
            catch (SourceException e) {
                log.error((Object)("Could not construct source from schema file " + externalSchemaPath), (Throwable)e);
                throw new SourceTransformerException((Throwable)e);
            }
        }
        for (SourceElement table : root.getChildren((SourceElementName)TorqueSchemaElementName.TABLE)) {
            allTables.getChildren().add(table);
        }
        for (SourceElement view : root.getChildren((SourceElementName)TorqueSchemaElementName.VIEW)) {
            allViews.getChildren().add(view);
        }
        return root;
    }

    public Database transform(Database database, ControllerState controllerState) throws SourceTransformerException {
        for (ExternalSchema externalSchema : database.externalSchemaList) {
            File externalSchemaBaseDir;
            if (this.baseDir == null) {
                File currentSourceFile = controllerState.getSourceFile();
                externalSchemaBaseDir = currentSourceFile.getParentFile();
            } else {
                externalSchemaBaseDir = this.baseDir;
            }
            File externalSchemaPath = new File(externalSchemaBaseDir, externalSchema.filename);
            try {
                FileSource fileSource = new FileSource((StreamSourceFormat)new XmlSourceFormat(), externalSchemaPath, controllerState);
                SourceElement externalSchemaRootElement = fileSource.getRootElement();
                Database externalDatabase = (Database)this.toModelTransformer.transform((Object)externalSchemaRootElement, controllerState);
                externalDatabase.rootDatabaseName = database.rootDatabaseName;
                DatabaseMapInitTransformer.setDatabaseMapInitClassNameAttributes(externalSchemaRootElement, database.rootDatabaseName, controllerState);
                this.transform(externalDatabase, controllerState);
                externalSchema.database = externalDatabase;
                database.allTables.addAll(externalDatabase.allTables);
                database.allViews.addAll(externalDatabase.allViews);
            }
            catch (SourceException e) {
                log.error((Object)("Could not construct source from schema file " + externalSchemaPath), (Throwable)e);
                throw new SourceTransformerException((Throwable)e);
            }
        }
        database.allTables.addAll(database.tableList);
        database.allViews.addAll(database.viewList);
        return database;
    }
}

