/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.file.WildcardFilter;

public class Fileset {
    private static Log log = LogFactory.getLog(Fileset.class);
    private File basedir;
    private Collection<String> includes;
    private Collection<String> excludes;

    public Fileset() {
    }

    public Fileset(File basedir, Collection<String> includes, Collection<String> excludes) {
        this.basedir = basedir;
        this.includes = includes;
        this.excludes = excludes;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public Collection<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection<String> includes) {
        this.includes = includes;
    }

    public Collection<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection<String> excludes) {
        this.excludes = excludes;
    }

    public List<File> getFiles() throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        if (this.includes == null || this.includes.isEmpty()) {
            Fileset.getAllFiles(this.basedir, result);
        } else {
            for (String includePattern : this.includes) {
                int wildcardFreeSeparatorPos = Fileset.getWildcardFreeSeparatorPos(includePattern);
                String wildcardFreeIncludePart = Fileset.getPathPartBefore(includePattern, wildcardFreeSeparatorPos);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("getFiles() : traversing directory " + wildcardFreeIncludePart + " in base dir " + this.basedir));
                }
                File wildcardFreeBaseDir = new File(this.basedir, wildcardFreeIncludePart);
                String wildcardPattern = Fileset.getPathPartAfter(includePattern, wildcardFreeSeparatorPos);
                String[] wildcardParts = StringUtils.split((String)wildcardPattern, (String)"\\/");
                List<String> wildcardPartList = Arrays.asList(wildcardParts);
                List<File> includeFiles = Fileset.getFiles(wildcardFreeBaseDir, wildcardPartList);
                result.addAll(includeFiles);
            }
        }
        if (this.excludes == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"getFiles() : no excludes are defined.");
            }
            return result;
        }
        Iterator fileIt = result.iterator();
        while (fileIt.hasNext()) {
            File file = (File)fileIt.next();
            if (log.isTraceEnabled()) {
                log.trace((Object)("getFiles() : checking excludes for file " + file.getPath()));
            }
            boolean excluded = false;
            for (String excludePattern : this.excludes) {
                File excludePatternFile = new File(this.basedir, excludePattern);
                if (Fileset.matchesPattern(file, excludePatternFile.getPath())) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("getFiles() : exclude pattern " + excludePatternFile.getPath() + " matches, file is excluded"));
                    }
                    excluded = true;
                    break;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("getFiles() : exclude pattern " + excludePatternFile.getPath() + " does not match"));
            }
            if (!excluded) continue;
            fileIt.remove();
        }
        Collections.sort(result);
        return result;
    }

    static void getAllFiles(File currentBaseDir, List<File> toAddTo) throws IOException {
        Object[] filesInDir;
        if (currentBaseDir == null) {
            currentBaseDir = new File(".");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("getAllFiles() : traversing directory " + currentBaseDir.getAbsolutePath()));
        }
        if ((filesInDir = currentBaseDir.listFiles(new WildcardFilter("*", false, true))) == null) {
            throw new IOException("Could not list files in the following Directory while reading the sources: " + currentBaseDir.getAbsolutePath());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("getAllFiles() : Adding files " + Arrays.toString(filesInDir) + " to candidate list"));
        }
        toAddTo.addAll(Arrays.asList(filesInDir));
        File[] dirsInDir = currentBaseDir.listFiles(new WildcardFilter("*", true, false));
        if (dirsInDir != null) {
            for (File dir : dirsInDir) {
                Fileset.getAllFiles(dir, toAddTo);
            }
        }
    }

    static List<File> getFiles(File currentBaseDir, List<String> pathPartList) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getFiles(File, List) : traversing directory " + currentBaseDir.getAbsolutePath() + ", current path parts: " + pathPartList));
        }
        ArrayList<String> partsCopy = new ArrayList<String>(pathPartList);
        String includeToProcess = (String)partsCopy.remove(0);
        if (partsCopy.size() == 0) {
            File[] matches = currentBaseDir.listFiles(new WildcardFilter(includeToProcess, false, true));
            if (matches == null) {
                throw new IOException("Could not list files in the following Directory while reading the sources: " + currentBaseDir.getAbsolutePath());
            }
            List<File> result = Arrays.asList(matches);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getFiles(File, List) : Returning files " + result));
            }
            return result;
        }
        if ("..".equals(includeToProcess)) {
            return Fileset.getFiles(currentBaseDir.getParentFile(), partsCopy);
        }
        File[] matchingDirs = currentBaseDir.listFiles(new WildcardFilter(includeToProcess, true, false));
        ArrayList<File> result = new ArrayList<File>();
        if (matchingDirs != null) {
            for (File dir : matchingDirs) {
                result.addAll(Fileset.getFiles(dir, partsCopy));
            }
        }
        return result;
    }

    static int getWildcardFreeSeparatorPos(String path) {
        int asteriskIndex = path.indexOf("*");
        int questionMarkIndex = path.indexOf("?");
        if (asteriskIndex != -1) {
            if (questionMarkIndex != -1) {
                int min = Math.min(asteriskIndex, questionMarkIndex);
                return Fileset.getLargestSeparatorPos(path, min);
            }
            return Fileset.getLargestSeparatorPos(path, asteriskIndex);
        }
        return Fileset.getLargestSeparatorPos(path, questionMarkIndex);
    }

    static int getLargestSeparatorPos(String path, int maxIndex) {
        String baseString = maxIndex == -1 ? path : path.substring(0, maxIndex);
        return FilenameUtils.indexOfLastSeparator((String)baseString);
    }

    static String getPathPartBefore(String path, int cutPosition) {
        if (cutPosition == -1) {
            return ".";
        }
        String resultString = path.substring(0, cutPosition);
        if ("".equals(resultString)) {
            resultString = ".";
        }
        return resultString;
    }

    static String getPathPartAfter(String path, int cutPosition) {
        String resultString = path.substring(cutPosition + 1);
        return resultString;
    }

    static boolean matchesPattern(File file, String pattern) {
        String filePath = file.getPath();
        List<String> fileParts = Fileset.splitAndNormalize(filePath);
        List<String> patternParts = Fileset.splitAndNormalize(pattern);
        if (fileParts.size() != patternParts.size()) {
            return false;
        }
        Iterator<String> patternPartIt = patternParts.iterator();
        for (String filePart : fileParts) {
            String patternPart;
            if (FilenameUtils.wildcardMatch((String)filePart, (String)(patternPart = patternPartIt.next()), (IOCase)IOCase.SENSITIVE)) continue;
            return false;
        }
        return true;
    }

    static List<String> splitAndNormalize(String path) {
        String[] parts = StringUtils.split((String)path, (String)"\\/");
        ArrayList<String> normalizedParts = new ArrayList<String>();
        for (String part : parts) {
            if (".".equals(part)) continue;
            if ("..".equals(part) && !normalizedParts.isEmpty()) {
                normalizedParts.remove(normalizedParts.size() - 1);
                continue;
            }
            normalizedParts.add(part);
        }
        return normalizedParts;
    }

    public String toString() {
        return "Fileset [basedir=" + this.basedir + ", excludes=" + this.excludes + ", includes=" + this.includes + "]";
    }
}

