/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.transformer.om.InheritanceAttributeName;
import org.apache.torque.templates.transformer.om.TableAttributeName;

public class OMInheritanceTransformer {
    public void transform(SourceElement inheritanceElement, ControllerState controllerState) throws SourceTransformerException {
        if (!TorqueSchemaElementName.INHERITANCE.getName().equals(inheritanceElement.getName())) {
            throw new IllegalArgumentException("Illegal element Name " + inheritanceElement.getName());
        }
        String key = (String)inheritanceElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.KEY);
        if (key == null) {
            throw new IllegalArgumentException("Attribute \"" + (Object)((Object)TorqueSchemaAttributeName.KEY) + "\" not set in Element " + (Object)((Object)TorqueSchemaElementName.INHERITANCE));
        }
        inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.CLASSKEY_CONSTANT, (Object)("CLASSKEY_" + key.toUpperCase()));
        SourceElement tableElement = inheritanceElement.getParent().getParent();
        String className = (String)inheritanceElement.getAttribute(TorqueSchemaAttributeName.CLASS.getName());
        if (className == null) {
            className = (String)tableElement.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME);
        }
        inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.CLASS_NAME, (Object)className);
        inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.PACKAGE, tableElement.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_PACKAGE));
        String extendsAttribute = (String)inheritanceElement.getAttribute(TorqueSchemaAttributeName.EXTENDS.getName());
        String beanExtends = (String)inheritanceElement.getAttribute((SourceAttributeName)InheritanceAttributeName.BEAN_EXTENDS);
        if (extendsAttribute == null) {
            extendsAttribute = (String)tableElement.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME);
            inheritanceElement.setAttribute(TorqueSchemaAttributeName.EXTENDS.getName(), (Object)extendsAttribute);
            inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.BEAN_EXTENDS, tableElement.getAttribute((SourceAttributeName)TableAttributeName.BEAN_CLASS_NAME));
        } else if (beanExtends == null) {
            int lastDot = extendsAttribute.lastIndexOf(".");
            String unqualifiedClassname = lastDot != -1 ? extendsAttribute.substring(lastDot + 1) : extendsAttribute;
            beanExtends = controllerState.getOption("torque.om.className.beanClassNamePrefix") + unqualifiedClassname + controllerState.getOption("torque.om.className.beanClassNameSuffix");
            inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.BEAN_EXTENDS, (Object)beanExtends);
        }
        int lastDot = className.lastIndexOf(".");
        String unqualifiedClassname = lastDot != -1 ? className.substring(lastDot + 1) : className;
        String beanClassName = controllerState.getOption("torque.om.className.beanClassNamePrefix") + unqualifiedClassname + controllerState.getOption("torque.om.className.beanClassNameSuffix");
        inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.BEAN_CLASS_NAME, (Object)beanClassName);
        inheritanceElement.setAttribute((SourceAttributeName)InheritanceAttributeName.BEAN_PACKAGE, tableElement.getAttribute((SourceAttributeName)TableAttributeName.BEAN_PACKAGE));
    }
}

