/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

class FS_Win32
extends FS {
    FS_Win32() {
    }

    FS_Win32(FS src) {
        super(src);
    }

    public FS newInstance() {
        return new FS_Win32(this);
    }

    public boolean supportsExecute() {
        return false;
    }

    public boolean canExecute(File f) {
        return false;
    }

    public boolean setExecute(File f, boolean canExec) {
        return false;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean retryFailedLockFileCommit() {
        return true;
    }

    protected File discoverGitPrefix() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_Win32.searchPath(path, "git.exe", "git.cmd");
        if (gitExe != null) {
            return gitExe.getParentFile().getParentFile();
        }
        String w = FS_Win32.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
        if (w != null && (gitExe = this.resolve(null, w)) != null) {
            return gitExe.getParentFile().getParentFile();
        }
        return null;
    }

    protected File userHomeImpl() {
        String home = SystemReader.getInstance().getenv("HOME");
        if (home != null) {
            return this.resolve(null, home);
        }
        String homeDrive = SystemReader.getInstance().getenv("HOMEDRIVE");
        if (homeDrive != null) {
            String homePath = SystemReader.getInstance().getenv("HOMEPATH");
            return new File(homeDrive, homePath);
        }
        String homeShare = SystemReader.getInstance().getenv("HOMESHARE");
        if (homeShare != null) {
            return new File(homeShare);
        }
        return super.userHomeImpl();
    }

    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(3 + args.length);
        argv.add("cmd.exe");
        argv.add("/c");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }
}

