/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.RefDirectory;
import org.eclipse.jgit.storage.file.RefDirectoryUpdate;
import org.eclipse.jgit.util.FileUtils;

class RefDirectoryRename
extends RefRename {
    private final RefDirectory refdb;
    private ObjectId objId;
    private boolean updateHEAD;
    private RefDirectoryUpdate tmp;

    RefDirectoryRename(RefDirectoryUpdate src, RefDirectoryUpdate dst) {
        super(src, dst);
        this.refdb = src.getRefDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RefUpdate.Result doRename() throws IOException {
        if (this.source.getRef().isSymbolic()) {
            return RefUpdate.Result.IO_FAILURE;
        }
        this.objId = this.source.getOldObjectId();
        this.updateHEAD = this.needToUpdateHEAD();
        this.tmp = this.refdb.newTemporaryUpdate();
        RevWalk rw = new RevWalk(this.refdb.getRepository());
        try {
            this.tmp.setNewObjectId(this.objId);
            this.tmp.setForceUpdate(true);
            this.tmp.disableRefLog();
            switch (this.tmp.update(rw)) {
                case NEW: 
                case FORCED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    RefUpdate.Result result = this.tmp.getResult();
                    return result;
                }
            }
            if (!this.renameLog(this.source, this.tmp)) {
                RefUpdate.Result result = RefUpdate.Result.IO_FAILURE;
                return result;
            }
            RefUpdate dst = this.destination;
            if (this.updateHEAD) {
                if (!this.linkHEAD(this.destination)) {
                    this.renameLog(this.tmp, this.source);
                    RefUpdate.Result result = RefUpdate.Result.LOCK_FAILURE;
                    return result;
                }
                dst = this.refdb.newUpdate("HEAD", false);
                dst.setRefLogIdent(this.destination.getRefLogIdent());
                dst.setRefLogMessage(this.destination.getRefLogMessage(), false);
            }
            this.source.setExpectedOldObjectId(this.objId);
            this.source.setForceUpdate(true);
            this.source.disableRefLog();
            if (this.source.delete(rw) != RefUpdate.Result.FORCED) {
                this.renameLog(this.tmp, this.source);
                if (this.updateHEAD) {
                    this.linkHEAD(this.source);
                }
                RefUpdate.Result result = this.source.getResult();
                return result;
            }
            if (!this.renameLog(this.tmp, this.destination)) {
                this.renameLog(this.tmp, this.source);
                this.source.setExpectedOldObjectId(ObjectId.zeroId());
                this.source.setNewObjectId(this.objId);
                this.source.update(rw);
                if (this.updateHEAD) {
                    this.linkHEAD(this.source);
                }
                RefUpdate.Result result = RefUpdate.Result.IO_FAILURE;
                return result;
            }
            dst.setExpectedOldObjectId(ObjectId.zeroId());
            dst.setNewObjectId(this.objId);
            if (dst.update(rw) != RefUpdate.Result.NEW) {
                if (this.renameLog(this.destination, this.tmp)) {
                    this.renameLog(this.tmp, this.source);
                }
                this.source.setExpectedOldObjectId(ObjectId.zeroId());
                this.source.setNewObjectId(this.objId);
                this.source.update(rw);
                if (this.updateHEAD) {
                    this.linkHEAD(this.source);
                }
                RefUpdate.Result result = dst.getResult();
                return result;
            }
            RefUpdate.Result result = RefUpdate.Result.RENAMED;
            return result;
        }
        finally {
            try {
                this.refdb.delete(this.tmp);
            }
            catch (IOException err) {
                FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
            }
            rw.release();
        }
    }

    private boolean renameLog(RefUpdate src, RefUpdate dst) {
        File srcLog = this.refdb.getLogWriter().logFor(src.getName());
        File dstLog = this.refdb.getLogWriter().logFor(dst.getName());
        if (!srcLog.exists()) {
            return true;
        }
        if (!RefDirectoryRename.rename(srcLog, dstLog)) {
            return false;
        }
        try {
            int levels = RefDirectory.levelsIn(src.getName()) - 2;
            RefDirectory.delete(srcLog, levels);
            return true;
        }
        catch (IOException e) {
            RefDirectoryRename.rename(dstLog, srcLog);
            return false;
        }
    }

    private static boolean rename(File src, File dst) {
        if (src.renameTo(dst)) {
            return true;
        }
        File dir = dst.getParentFile();
        if (!(!dir.exists() && dir.mkdirs() || dir.isDirectory())) {
            return false;
        }
        return src.renameTo(dst);
    }

    private boolean linkHEAD(RefUpdate target) {
        try {
            RefDirectoryUpdate u = this.refdb.newUpdate("HEAD", false);
            u.disableRefLog();
            switch (u.link(target.getName())) {
                case NEW: 
                case FORCED: 
                case NO_CHANGE: {
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

