/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StashApplyCommand
extends GitCommand<ObjectId> {
    private static final String DEFAULT_REF = "stash@{0}";
    private String stashRef;

    public StashApplyCommand(Repository repo) {
        super(repo);
    }

    public StashApplyCommand setStashRef(String stashRef) {
        this.stashRef = stashRef;
        return this;
    }

    private boolean isEqualEntry(AbstractTreeIterator iter1, AbstractTreeIterator iter2) {
        if (!iter1.getEntryFileMode().equals(iter2.getEntryFileMode())) {
            return false;
        }
        ObjectId id1 = iter1.getEntryObjectId();
        ObjectId id2 = iter2.getEntryObjectId();
        return id1 != null ? id1.equals(id2) : id2 == null;
    }

    private boolean isConflict(AbstractTreeIterator stashIndexIter, AbstractTreeIterator stashWorkingTreeIter, AbstractTreeIterator headIter, AbstractTreeIterator indexIter, AbstractTreeIterator workingTreeIter) {
        boolean workingTreeDirty;
        boolean indexDirty = indexIter != null && (headIter == null || !this.isEqualEntry(indexIter, headIter));
        boolean bl = workingTreeDirty = workingTreeIter != null && (headIter == null || !this.isEqualEntry(workingTreeIter, headIter));
        if (indexDirty && stashIndexIter != null && indexIter != null && !this.isEqualEntry(stashIndexIter, indexIter)) {
            return true;
        }
        return workingTreeDirty && stashWorkingTreeIter != null && workingTreeIter != null && !this.isEqualEntry(stashWorkingTreeIter, workingTreeIter);
    }

    private ObjectId getHeadTree() throws GitAPIException {
        ObjectId headTree;
        try {
            headTree = this.repo.resolve("HEAD^{tree}");
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().cannotReadTree, e);
        }
        if (headTree == null) {
            throw new NoHeadException(JGitText.get().cannotReadTree);
        }
        return headTree;
    }

    private ObjectId getStashId() throws GitAPIException {
        ObjectId stashId;
        String revision = this.stashRef != null ? this.stashRef : DEFAULT_REF;
        try {
            stashId = this.repo.resolve(revision);
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision), e);
        }
        if (stashId == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision));
        }
        return stashId;
    }

    private void scanForConflicts(TreeWalk treeWalk) throws IOException {
        File workingTree = this.repo.getWorkTree();
        while (treeWalk.next()) {
            AbstractTreeIterator workingIter;
            AbstractTreeIterator indexIter;
            AbstractTreeIterator headIter;
            AbstractTreeIterator stashWorkingIter;
            AbstractTreeIterator stashIndexIter = treeWalk.getTree(1, AbstractTreeIterator.class);
            if (!this.isConflict(stashIndexIter, stashWorkingIter = treeWalk.getTree(2, AbstractTreeIterator.class), headIter = treeWalk.getTree(3, AbstractTreeIterator.class), indexIter = treeWalk.getTree(4, AbstractTreeIterator.class), workingIter = treeWalk.getTree(5, AbstractTreeIterator.class))) continue;
            String path = treeWalk.getPathString();
            File file = new File(workingTree, path);
            throw new CheckoutConflictException(file.getAbsolutePath());
        }
    }

    private void applyChanges(TreeWalk treeWalk, DirCache cache, DirCacheEditor editor) throws IOException {
        File workingTree = this.repo.getWorkTree();
        while (treeWalk.next()) {
            String path = treeWalk.getPathString();
            File file = new File(workingTree, path);
            AbstractTreeIterator stashHeadIter = treeWalk.getTree(0, AbstractTreeIterator.class);
            AbstractTreeIterator stashIndexIter = treeWalk.getTree(1, AbstractTreeIterator.class);
            AbstractTreeIterator stashWorkingIter = treeWalk.getTree(2, AbstractTreeIterator.class);
            if (stashWorkingIter != null && stashIndexIter != null) {
                DirCacheEntry entry = cache.getEntry(path);
                if (entry == null) {
                    entry = new DirCacheEntry(treeWalk.getRawPath());
                }
                entry.setFileMode(stashIndexIter.getEntryFileMode());
                entry.setObjectId(stashIndexIter.getEntryObjectId());
                DirCacheCheckout.checkoutEntry(this.repo, file, entry, treeWalk.getObjectReader());
                final DirCacheEntry updatedEntry = entry;
                editor.add(new DirCacheEditor.PathEdit(path){

                    public void apply(DirCacheEntry ent) {
                        ent.copyMetaData(updatedEntry);
                    }
                });
                if (stashWorkingIter.idEqual(stashIndexIter)) continue;
                entry = new DirCacheEntry(treeWalk.getRawPath());
                entry.setObjectId(stashWorkingIter.getEntryObjectId());
                DirCacheCheckout.checkoutEntry(this.repo, file, entry, treeWalk.getObjectReader());
                continue;
            }
            if (stashIndexIter == null || stashHeadIter != null && !stashIndexIter.idEqual(stashHeadIter)) {
                editor.add(new DirCacheEditor.DeletePath(path));
            }
            FileUtils.delete(file, 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectId call() throws GitAPIException, WrongRepositoryStateException {
        this.checkCallable();
        if (this.repo.getRepositoryState() != RepositoryState.SAFE) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().stashApplyOnUnsafeRepository, new Object[]{this.repo.getRepositoryState()}));
        }
        ObjectId headTree = this.getHeadTree();
        ObjectId stashId = this.getStashId();
        ObjectReader reader = this.repo.newObjectReader();
        try {
            RevWalk revWalk = new RevWalk(reader);
            RevCommit stashCommit = revWalk.parseCommit(stashId);
            if (stashCommit.getParentCount() != 2) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().stashCommitMissingTwoParents, stashId.name()));
            }
            RevTree stashWorkingTree = stashCommit.getTree();
            RevTree stashIndexTree = revWalk.parseCommit(stashCommit.getParent(1)).getTree();
            RevTree stashHeadTree = revWalk.parseCommit(stashCommit.getParent(0)).getTree();
            CanonicalTreeParser stashWorkingIter = new CanonicalTreeParser();
            stashWorkingIter.reset(reader, stashWorkingTree);
            CanonicalTreeParser stashIndexIter = new CanonicalTreeParser();
            stashIndexIter.reset(reader, stashIndexTree);
            CanonicalTreeParser stashHeadIter = new CanonicalTreeParser();
            stashHeadIter.reset(reader, stashHeadTree);
            CanonicalTreeParser headIter = new CanonicalTreeParser();
            headIter.reset(reader, headTree);
            DirCache cache = this.repo.lockDirCache();
            DirCacheEditor editor = cache.editor();
            try {
                DirCacheIterator indexIter = new DirCacheIterator(cache);
                FileTreeIterator workingIter = new FileTreeIterator(this.repo);
                TreeWalk treeWalk = new TreeWalk(reader);
                treeWalk.setRecursive(true);
                treeWalk.setFilter(new StashDiffFilter());
                treeWalk.addTree(stashHeadIter);
                treeWalk.addTree(stashIndexIter);
                treeWalk.addTree(stashWorkingIter);
                treeWalk.addTree(headIter);
                treeWalk.addTree(indexIter);
                treeWalk.addTree(workingIter);
                this.scanForConflicts(treeWalk);
                treeWalk.reset();
                stashWorkingIter.reset(reader, stashWorkingTree);
                stashIndexIter.reset(reader, stashIndexTree);
                stashHeadIter.reset(reader, stashHeadTree);
                treeWalk.addTree(stashHeadIter);
                treeWalk.addTree(stashIndexIter);
                treeWalk.addTree(stashWorkingIter);
                this.applyChanges(treeWalk, cache, editor);
            }
            finally {
                editor.commit();
                cache.unlock();
            }
        }
        catch (JGitInternalException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashApplyFailed, e);
        }
        finally {
            reader.release();
        }
        return stashId;
    }

    private static class StashDiffFilter
    extends TreeFilter {
        private StashDiffFilter() {
        }

        public boolean include(TreeWalk walker) {
            int m = walker.getRawMode(0);
            if (walker.getRawMode(1) != m || !walker.idEqual(1, 0)) {
                return true;
            }
            return walker.getRawMode(2) != m || !walker.idEqual(2, 0);
        }

        public boolean shouldBeRecursive() {
            return false;
        }

        public TreeFilter clone() {
            return this;
        }

        public String toString() {
            return "STASH_DIFF";
        }
    }
}

