/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control.existingtargetstrategy;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.UnitConfiguration;
import org.apache.torque.generator.control.ControllerException;
import org.apache.torque.generator.control.ControllerHelper;
import org.apache.torque.generator.control.existingtargetstrategy.ExistingTargetStrategy;
import org.apache.torque.generator.outlet.OutletResult;

public class AppendToTargetFileStrategy
implements ExistingTargetStrategy {
    public static final String STRATEGY_NAME = "append";

    public boolean beforeGeneration(String outputDirKey, String outputPath, String encoding, UnitConfiguration unitConfiguration) {
        return true;
    }

    public void afterGeneration(String outputDirKey, String outputPath, String encoding, OutletResult generationResult, UnitConfiguration unitConfiguration) throws GeneratorException {
        File outputFile = ControllerHelper.getOutputFile(outputDirKey, outputPath, unitConfiguration);
        try {
            if (generationResult.isStringResult()) {
                String originalContent = "";
                if (outputFile.exists()) {
                    originalContent = FileUtils.readFileToString((File)outputFile, (String)encoding);
                }
                FileUtils.writeStringToFile((File)outputFile, (String)(originalContent + generationResult.getStringResult()), (String)encoding);
            } else {
                byte[] originalContent = new byte[]{};
                if (outputFile.exists()) {
                    originalContent = FileUtils.readFileToByteArray((File)outputFile);
                }
                byte[] result = new byte[originalContent.length + generationResult.getByteArrayResult().length];
                System.arraycopy(originalContent, 0, result, 0, originalContent.length);
                System.arraycopy(generationResult.getByteArrayResult(), 0, result, originalContent.length, generationResult.getByteArrayResult().length);
                FileUtils.writeByteArrayToFile((File)outputFile, (byte[])result);
            }
        }
        catch (IOException e) {
            throw new ControllerException("Could not write file \"" + outputFile.getAbsolutePath() + "\"", e);
        }
    }

    public String getStrategyName() {
        return STRATEGY_NAME;
    }
}

