/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.block;

import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.jcs.auxiliary.disk.block.BlockDisk;
import org.apache.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.block.BlockDiskKeyStore;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class BlockDiskCache
extends AbstractDiskCache {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$block$BlockDiskCache == null ? (class$org$apache$jcs$auxiliary$disk$block$BlockDiskCache = BlockDiskCache.class$("org.apache.jcs.auxiliary.disk.block.BlockDiskCache")) : class$org$apache$jcs$auxiliary$disk$block$BlockDiskCache));
    private final String logCacheName;
    private String fileName;
    private BlockDisk dataFile;
    private BlockDiskCacheAttributes blockDiskCacheAttributes;
    private File rootDirectory;
    private BlockDiskKeyStore keyStore;
    private WriterPreferenceReadWriteLock storageLock = new WriterPreferenceReadWriteLock();
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$block$BlockDiskCache;

    public BlockDiskCache(BlockDiskCacheAttributes cacheAttributes) {
        super(cacheAttributes);
        this.blockDiskCacheAttributes = cacheAttributes;
        this.logCacheName = "Region [" + this.getCacheName() + "] ";
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Constructing BlockDiskCache with attributes " + cacheAttributes));
        }
        this.fileName = this.getCacheName();
        String rootDirName = cacheAttributes.getDiskPath();
        this.rootDirectory = new File(rootDirName);
        this.rootDirectory.mkdirs();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Cache file root directory: [" + rootDirName + "]"));
        }
        try {
            this.dataFile = this.blockDiskCacheAttributes.getBlockSizeBytes() > 0 ? new BlockDisk(new File(this.rootDirectory, this.fileName + ".data"), this.blockDiskCacheAttributes.getBlockSizeBytes()) : new BlockDisk(new File(this.rootDirectory, this.fileName + ".data"));
            this.keyStore = new BlockDiskKeyStore(this.blockDiskCacheAttributes, this);
            boolean alright = this.verifyDisk();
            if (this.keyStore.size() == 0 || !alright) {
                this.reset();
            }
            this.alive = true;
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Block Disk Cache is alive."));
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure initializing for fileName: " + this.fileName + " and root directory: " + rootDirName), (Throwable)e);
        }
        ShutdownHook shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    protected boolean verifyDisk() {
        boolean alright = false;
        try {
            int maxToTest = 100;
            Set keySet = this.keyStore.entrySet();
            Iterator it = keySet.iterator();
            for (int count = 0; it.hasNext() && count < maxToTest; ++count) {
                Map.Entry entry = (Map.Entry)it.next();
                Serializable data = this.dataFile.read((int[])entry.getValue());
                if (data != null) continue;
                throw new Exception("Couldn't find data for key [" + entry.getKey() + "]");
            }
            alright = true;
        }
        catch (Exception e) {
            log.warn((Object)("Problem verifying disk.  Message [" + e.getMessage() + "]"));
            alright = false;
        }
        return alright;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGroupKeys(String groupName) {
        GroupId groupId = new GroupId(this.cacheName, groupName);
        HashSet<Object> keys = new HashSet<Object>();
        try {
            this.storageLock.readLock().acquire();
            Iterator itr = this.keyStore.keySet().iterator();
            while (itr.hasNext()) {
                Object k = itr.next();
                if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(groupId)) continue;
                keys.add(((GroupAttrName)k).attrName);
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure getting from disk, group = " + groupName), (Throwable)e);
        }
        finally {
            this.storageLock.readLock().release();
        }
        return keys;
    }

    public int getSize() {
        return this.keyStore.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICacheElement doGet(Serializable key) {
        if (!this.alive) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.logCacheName + "No longer alive so returning null for key = " + key));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.logCacheName + "Trying to get from disk: " + key));
        }
        ICacheElement object = null;
        try {
            this.storageLock.readLock().acquire();
            try {
                int[] ded = this.keyStore.get(key);
                if (ded != null) {
                    object = (ICacheElement)this.dataFile.read(ded);
                }
            }
            finally {
                this.storageLock.readLock().release();
            }
        }
        catch (IOException ioe) {
            log.error((Object)(this.logCacheName + "Failure getting from disk--IOException, key = " + key), (Throwable)ioe);
            this.reset();
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure getting from disk, key = " + key), (Throwable)e);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpdate(ICacheElement element) {
        if (!this.alive) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.logCacheName + "No longer alive; aborting put of key = " + element.getKey()));
            }
            return;
        }
        int[] old = null;
        try {
            this.storageLock.writeLock().acquire();
            try {
                old = this.keyStore.get(element.getKey());
                if (old != null) {
                    this.dataFile.freeBlocks(old);
                }
                int[] blocks = this.dataFile.write(element);
                this.keyStore.put(element.getKey(), blocks);
            }
            finally {
                this.storageLock.writeLock().release();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.logCacheName + "Put to file [" + this.fileName + "] key [" + element.getKey() + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure updating element, key: " + element.getKey() + " old: " + old), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.logCacheName + "Storing element on disk, key: " + element.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRemove(Serializable key) {
        if (!this.alive) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.logCacheName + "No longer alive so returning false for key = " + key));
            }
            return false;
        }
        boolean reset = false;
        boolean removed = false;
        try {
            this.storageLock.writeLock().acquire();
            if (key instanceof String && key.toString().endsWith(":")) {
                Iterator iter = this.keyStore.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Object k = entry.getKey();
                    if (!(k instanceof String) || !k.toString().startsWith(key.toString())) continue;
                    int[] ded = this.keyStore.get(key);
                    this.dataFile.freeBlocks(ded);
                    iter.remove();
                    removed = true;
                }
            } else if (key instanceof GroupId) {
                Iterator iter = this.keyStore.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Object k = entry.getKey();
                    if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(key)) continue;
                    int[] ded = this.keyStore.get(key);
                    this.dataFile.freeBlocks(ded);
                    iter.remove();
                    removed = true;
                }
            } else {
                int[] ded = this.keyStore.remove(key);
                boolean bl = removed = ded != null;
                if (ded != null) {
                    this.dataFile.freeBlocks(ded);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.logCacheName + "Disk removal: Removed from key hash, key [" + key + "] removed = " + removed));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Problem removing element."), (Throwable)e);
            reset = true;
        }
        finally {
            this.storageLock.writeLock().release();
        }
        if (reset) {
            this.reset();
        }
        return removed;
    }

    protected void doRemoveAll() {
        try {
            this.reset();
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Problem removing all."), (Throwable)e);
            this.reset();
        }
    }

    public void doDispose() {
        Runnable disR = new Runnable(){

            public void run() {
                try {
                    BlockDiskCache.this.disposeInternal();
                }
                catch (InterruptedException e) {
                    log.warn((Object)"Interrupted while diposing.");
                }
            }
        };
        Thread t = new Thread(disR, "BlockDiskCache-DisposalThread");
        t.start();
        try {
            t.join(60000L);
        }
        catch (InterruptedException ex) {
            log.error((Object)(this.logCacheName + "Interrupted while waiting for disposal thread to finish."), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeInternal() throws InterruptedException {
        if (!this.alive) {
            log.error((Object)(this.logCacheName + "Not alive and dispose was called, filename: " + this.fileName));
            return;
        }
        this.storageLock.writeLock().acquire();
        try {
            this.alive = false;
            this.keyStore.saveKeys();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.logCacheName + "Closing files, base filename: " + this.fileName));
                }
                this.dataFile.close();
            }
            catch (IOException e) {
                log.error((Object)(this.logCacheName + "Failure closing files in dispose, filename: " + this.fileName), (Throwable)e);
            }
        }
        finally {
            this.storageLock.writeLock().release();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Shutdown complete."));
        }
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.blockDiskCacheAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        if (log.isWarnEnabled()) {
            log.warn((Object)(this.logCacheName + "Reseting cache"));
        }
        try {
            this.storageLock.writeLock().acquire();
            if (this.dataFile != null) {
                this.dataFile.close();
            }
            File dataFileTemp = new File(this.rootDirectory, this.fileName + ".data");
            dataFileTemp.delete();
            this.dataFile = this.blockDiskCacheAttributes.getBlockSizeBytes() > 0 ? new BlockDisk(new File(this.rootDirectory, this.fileName + ".data"), this.blockDiskCacheAttributes.getBlockSizeBytes()) : new BlockDisk(new File(this.rootDirectory, this.fileName + ".data"));
            this.keyStore.reset();
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure reseting state"), (Throwable)e);
        }
        finally {
            this.storageLock.writeLock().release();
        }
    }

    protected void freeBlocks(int[] blocksToFree) {
        this.dataFile.freeBlocks(blocksToFree);
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Block Disk Cache");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Is Alive");
        se.setData("" + this.alive);
        elems.add(se);
        se = new StatElement();
        se.setName("Key Map Size");
        se.setData("" + this.keyStore.size());
        elems.add(se);
        try {
            se = new StatElement();
            se.setName("Data File Length");
            if (this.dataFile != null) {
                se.setData("" + this.dataFile.length());
            } else {
                se.setData("-1");
            }
            elems.add(se);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        se = new StatElement();
        se.setName("Block Size Bytes");
        se.setData("" + this.dataFile.getBlockSizeBytes());
        elems.add(se);
        se = new StatElement();
        se.setName("Number Of Blocks");
        se.setData("" + this.dataFile.getNumberOfBlocks());
        elems.add(se);
        se = new StatElement();
        se.setName("Average Put Size Bytes");
        se.setData("" + this.dataFile.getAveragePutSizeBytes());
        elems.add(se);
        se = new StatElement();
        se.setName("Empty Blocks");
        se.setData("" + this.dataFile.getEmptyBlocks());
        elems.add(se);
        IStats sStats = super.getStatistics();
        IStatElement[] sSEs = sStats.getStatElements();
        List<IStatElement> sL = Arrays.asList(sSEs);
        elems.addAll(sL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        public void run() {
            if (BlockDiskCache.this.alive) {
                log.warn((Object)(BlockDiskCache.this.logCacheName + "Disk cache not shutdown properly, shutting down now."));
                BlockDiskCache.this.doDispose();
            }
        }
    }
}

