/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.PoolBackedDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.impl.IdentityTokenized;
import com.mchange.v2.coalesce.CoalesceChecker;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.util.HashSet;
import java.util.Set;

public final class C3P0Registry {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$C3P0Registry == null ? (class$com$mchange$v2$c3p0$C3P0Registry = C3P0Registry.class$("com.mchange.v2.c3p0.C3P0Registry")) : class$com$mchange$v2$c3p0$C3P0Registry);
    static boolean banner_printed = false;
    private static CoalesceChecker CC = new CoalesceChecker(){

        public boolean checkCoalesce(Object a, Object b) {
            IdentityTokenized aa = (IdentityTokenized)a;
            IdentityTokenized bb = (IdentityTokenized)b;
            String ta = aa.getIdentityToken();
            String tb = bb.getIdentityToken();
            if (ta == null || tb == null) {
                throw new NullPointerException("[c3p0 bug] An IdentityTokenized object has no identity token set?!?! " + (ta == null ? ta : tb));
            }
            return ta.equals(tb);
        }

        public int coalesceHash(Object a) {
            String t = ((IdentityTokenized)a).getIdentityToken();
            return t != null ? t.hashCode() : 0;
        }
    };
    private static Coalescer idtCoalescer = CoalescerFactory.createCoalescer(CC, false, true);
    private static HashSet topLevelPooledDataSources = new HashSet();
    static /* synthetic */ Class class$com$mchange$v2$c3p0$C3P0Registry;

    private static synchronized void banner() {
        if (!banner_printed) {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Initializing c3p0-0.9.0.2 [built 26-September-2005 12:55:26 -0400; debug? true; trace: 10]");
            }
            banner_printed = true;
        }
    }

    private static synchronized void addToTopLevelPooledDataSources(IdentityTokenized idt) {
        if (idt instanceof PoolBackedDataSource) {
            if (((PoolBackedDataSource)idt).owner() == null) {
                topLevelPooledDataSources.add(idt);
            }
        } else if (idt instanceof PooledDataSource) {
            topLevelPooledDataSources.add(idt);
        }
    }

    static void register(IdentityTokenized idt) {
        C3P0Registry.banner();
        if (idt.getIdentityToken() == null) {
            throw new RuntimeException("[c3p0 issue] The identityToken of a registered object should be set prior to registration.");
        }
        if (idtCoalescer.coalesce(idt) != idt) {
            throw new RuntimeException("[c3p0 bug] Only brand new IdentityTokenized's, with their identities just set, should be registered!!!");
        }
        C3P0Registry.addToTopLevelPooledDataSources(idt);
    }

    public static Set getPooledDataSources() {
        return (Set)topLevelPooledDataSources.clone();
    }

    public static Object coalesce(IdentityTokenized idt) {
        Object out = idtCoalescer.coalesce(idt);
        return out;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

