/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers.backed;

import java.io.ObjectStreamException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.flush.MapClearOperation;
import org.datanucleus.flush.MapPutOperation;
import org.datanucleus.flush.MapRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.store.types.wrappers.backed.Collection;
import org.datanucleus.store.types.wrappers.backed.Set;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Properties
extends org.datanucleus.store.types.wrappers.Properties
implements BackedSCO {
    protected transient MapStore backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;

    public Properties(ObjectProvider op, AbstractMemberMetaData mmd) {
        super(op, mmd);
        this.delegate = new java.util.Properties();
        ExecutionContext ec = this.ownerOP.getExecutionContext();
        this.useCache = SCOUtils.useContainerCache(this.ownerOP, mmd);
        if (!SCOUtils.mapHasSerialisedKeysAndValues(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            this.backingStore = (MapStore)((BackedSCOStoreManager)((Object)this.ownerOP.getStoreManager())).getBackingStoreForField(clr, mmd, Map.class);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(this.ownerOP, this.ownerMmd.getName(), this, this.useCache, this.allowNulls, SCOUtils.useCachedLazyLoading(this.ownerOP, this.ownerMmd)));
        }
    }

    @Override
    public void initialise(java.util.Properties m, boolean forInsert, boolean forUpdate) {
        if (m != null) {
            if (SCOUtils.mapHasSerialisedKeysAndValues(this.ownerMmd) && (this.ownerMmd.getMap().keyIsPersistent() || this.ownerMmd.getMap().valueIsPersistent())) {
                ExecutionContext ec = this.ownerOP.getExecutionContext();
                for (Map.Entry<Object, Object> entry : m.entrySet()) {
                    ObjectProvider<Object> objSM;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (this.ownerMmd.getMap().keyIsPersistent() && (objSM = ec.findObjectProvider(key)) == null) {
                        objSM = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, key, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                    }
                    if (!this.ownerMmd.getMap().valueIsPersistent() || (objSM = ec.findObjectProvider(value)) != null) continue;
                    objSM = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, value, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("023007", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + m.size()));
                }
                this.makeDirty();
                if (this.useCache) {
                    this.loadFromStore();
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                        for (Map.Entry<Object, Object> entry : m.entrySet()) {
                            this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, entry.getKey(), entry.getValue()));
                        }
                    } else {
                        this.backingStore.putAll(this.ownerOP, m);
                    }
                }
                this.delegate.putAll((Map<?, ?>)m);
            } else if (forUpdate) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("023008", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + m.size()));
                }
                this.delegate.clear();
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                        if (this.ownerOP.isFlushedToDatastore()) {
                            this.ownerOP.getExecutionContext().addOperationToQueue(new MapClearOperation(this.ownerOP, this.backingStore));
                        }
                    } else {
                        this.backingStore.clear(this.ownerOP);
                    }
                }
                if (this.useCache) {
                    this.loadFromStore();
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                        if (this.ownerOP.isFlushedToDatastore()) {
                            for (Map.Entry<Object, Object> entry : m.entrySet()) {
                                this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, entry.getKey(), entry.getValue()));
                            }
                        }
                    } else {
                        this.backingStore.putAll(this.ownerOP, m);
                    }
                }
                this.delegate.putAll((Map<?, ?>)m);
                this.makeDirty();
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("023007", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + m.size()));
                }
                this.delegate.clear();
                this.delegate.putAll((Map<?, ?>)m);
            }
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerOP, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    @Override
    public java.util.Properties getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("023006", this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName()));
            }
            this.delegate.clear();
            SCOUtils.populateMapDelegateWithStoreData(this.delegate, this.backingStore, this.ownerOP);
            this.isCacheLoaded = true;
        }
    }

    @Override
    public Store getBackingStore() {
        return this.backingStore;
    }

    @Override
    public void updateEmbeddedKey(Object key, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedKey(this.ownerOP, key, fieldNumber, newValue);
        }
    }

    @Override
    public void updateEmbeddedValue(Object value, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedValue(this.ownerOP, value, fieldNumber, newValue);
        }
    }

    @Override
    public synchronized void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public synchronized Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsKey(key);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsKey(this.ownerOP, key);
        }
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsValue(value);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsValue(this.ownerOP, value);
        }
        return this.delegate.containsValue(value);
    }

    @Override
    public java.util.Set entrySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerOP, this.ownerMmd, false, this.backingStore.entrySetStore());
        }
        return this.delegate.entrySet();
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        return this.entrySet().equals(m.entrySet());
    }

    @Override
    public synchronized Object get(Object key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerOP, key);
        }
        return this.delegate.get(key);
    }

    @Override
    public String getProperty(String key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            Object val = this.backingStore.get(this.ownerOP, key);
            String strVal = val instanceof String ? (String)val : null;
            return strVal == null && this.defaults != null ? this.defaults.getProperty(key) : strVal;
        }
        return this.delegate.getProperty(key);
    }

    @Override
    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
        return this.delegate.hashCode();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public java.util.Set keySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerOP, this.ownerMmd, false, this.backingStore.keySetStore());
        }
        return this.delegate.keySet();
    }

    @Override
    public synchronized int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.entrySetStore().size(this.ownerOP);
        }
        return this.delegate.size();
    }

    @Override
    public java.util.Collection values() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Collection(this.ownerOP, this.ownerMmd, true, this.backingStore.valueCollectionStore());
        }
        return this.delegate.values();
    }

    @Override
    public synchronized void clear() {
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapClearOperation(this.ownerOP, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerOP);
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (!this.allowNulls) {
            if (key == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.ownerMmd.getName() + " but key is null");
            }
            if (value == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.ownerMmd.getName() + " but value is null");
            }
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        this.makeDirty();
        Object oldValue = null;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, key, value));
            } else {
                oldValue = this.backingStore.put(this.ownerOP, key, value);
            }
        }
        Object delegateOldValue = this.delegate.put(key, value);
        if (this.backingStore == null) {
            oldValue = delegateOldValue;
        } else if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
            oldValue = delegateOldValue;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return oldValue;
    }

    @Override
    public synchronized void putAll(Map m) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                for (Map.Entry entry : m.entrySet()) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.backingStore, entry.getKey(), entry.getValue()));
                }
            } else {
                this.backingStore.putAll(this.ownerOP, m);
            }
        }
        this.delegate.putAll((Map<?, ?>)m);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public synchronized Object remove(Object key) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        Object removed = null;
        Object delegateRemoved = this.delegate.remove(key);
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapRemoveOperation(this.ownerOP, this.backingStore, key, delegateRemoved));
                removed = delegateRemoved;
            } else {
                removed = this.backingStore.remove(this.ownerOP, key);
            }
        } else {
            removed = delegateRemoved;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return removed;
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new Hashtable<Object, Object>(this.delegate);
        }
        return new Hashtable<Object, Object>(this.delegate);
    }
}

