/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.StoreCostResult;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_AccessRow;
import org.apache.derbyTesting.unitTests.store.T_StoreCostResult;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_AccessFactory
extends T_Generic {
    private static final String testService = "accessTest";
    AccessFactory store = null;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.access.AccessFactory";
    }

    @Override
    protected void runTests() throws T_Fail {
        TransactionController tc = null;
        boolean pass = false;
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            this.store = (AccessFactory)T_AccessFactory.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        if (this.store == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        this.REPORT("(unitTestMain) Testing accessTest");
        try {
            ContextManager cm = T_AccessFactory.getContextService().getCurrentContextManager();
            tc = this.store.getAndNameTransaction(cm, "UserTransaction");
            if (this.dropTest(tc) && this.holdCursor(tc) && this.readUncommitted(tc) && this.updatelocks(tc) && this.nestedUserTransaction(tc) && this.positionAtRowLocation(tc) && this.sortCost(tc) && this.storeCost(tc) && this.partialScan(tc) && this.scanInfo(tc) && this.insertAndUpdateExample(tc) && this.insertAndFetchExample(tc) && this.scanExample(tc) && this.alterTable(tc, false) && this.alterTable(tc, true) && this.tempTest(tc) && this.getTableProperties(tc) && this.insert_bench(tc) && this.transactionalProperties(tc) && this.commitTest(tc)) {
                pass = true;
            }
            tc.commitNoSync(1);
            tc.destroy();
            if (!pass) {
                throw T_Fail.testFailMsg("test failed");
            }
        }
        catch (StandardException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = ((Object)((Object)e)).getClass().getName();
            }
            this.REPORT(msg);
            e.printStackTrace();
            throw T_Fail.exceptionFail(e);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void flush_cache() throws StandardException {
        RawStoreFactory rawstore = (RawStoreFactory)T_AccessFactory.findServiceModule(this.store, "org.apache.derby.iapi.store.raw.RawStoreFactory");
        rawstore.checkpoint();
    }

    protected boolean insertAndFetchExample(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(insertAndFetchExample)");
        try {
            long conglomid = tc.createConglomerate("heap", null, null, null, null, 0);
            throw T_Fail.testFailMsg("Allowed heap create without template.");
        }
        catch (Throwable conglomid) {
            T_AccessRow template_row = new T_AccessRow(1);
            long conglomid2 = tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
            return this.insertAndFetch(tc, conglomid2, 33) && this.insertAndFetch(tc, conglomid2, -1) && this.insertAndFetch(tc, conglomid2, -1000000000);
        }
    }

    protected boolean insertAndFetch(TransactionController tc, long conglomid, int value) throws StandardException, T_Fail {
        StaticCompiledOpenConglomInfo static_info = tc.getStaticCompiledConglomInfo(conglomid);
        DynamicCompiledOpenConglomInfo dynamic_info = tc.getDynamicCompiledConglomInfo(conglomid);
        String curr_xact_name = tc.getTransactionIdString();
        this.REPORT("(insertAndFetch) xact id = " + curr_xact_name);
        ConglomerateController cc = tc.openCompiledConglomerate(false, 4, 6, 5, static_info, dynamic_info);
        T_AccessRow r1 = new T_AccessRow(1);
        SQLInteger c1 = new SQLInteger(value);
        r1.setCol(0, (DataValueDescriptor)c1);
        RowLocation rowloc = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc);
        Hashtable<RowLocation, RowLocation> test_rowloc_hash = new Hashtable<RowLocation, RowLocation>();
        test_rowloc_hash.put(rowloc, rowloc);
        RowLocation hash_find = (RowLocation)test_rowloc_hash.get(rowloc);
        if (!hash_find.equals((Object)rowloc)) {
            throw T_Fail.testFailMsg("(insertAndFetch) bad hash lookup 1");
        }
        hash_find = (RowLocation)test_rowloc_hash.remove(rowloc);
        if (!hash_find.equals((Object)rowloc)) {
            throw T_Fail.testFailMsg("(insertAndFetch) bad hash lookup 2");
        }
        hash_find = (RowLocation)test_rowloc_hash.remove(rowloc);
        if (hash_find != null) {
            throw T_Fail.testFailMsg("(insertAndFetch) bad hash lookup 3");
        }
        T_AccessRow r2 = new T_AccessRow(1);
        SQLInteger c2 = new SQLInteger(0);
        r2.setCol(0, (DataValueDescriptor)c2);
        if (!cc.fetch(rowloc, r2.getRowArray(), (FormatableBitSet)null)) {
            throw T_Fail.testFailMsg("(insertAndFetch) fetch found no row.");
        }
        SQLInteger c3 = new SQLInteger(0);
        FormatableBitSet singleColumn = new FormatableBitSet(1);
        singleColumn.set(0);
        DataValueDescriptor[] c3row = new DataValueDescriptor[]{c3};
        if (!cc.fetch(rowloc, c3row, singleColumn)) {
            throw T_Fail.testFailMsg("(insertAndFetch) fetch found no row.");
        }
        cc.close();
        if (c2.getInt() != value) {
            throw T_Fail.testFailMsg("(insertAndFetch) Fetched value != inserted value.");
        }
        if (c3.getInt() != value) {
            throw T_Fail.testFailMsg("(insertAndFetch) Fetched value != inserted value.");
        }
        return true;
    }

    protected boolean insertAndUpdateExample(TransactionController tc) throws StandardException, T_Fail {
        long conglomid = tc.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 0);
        this.REPORT("(insertAndUpdateExample)");
        return this.insertAndUpdate(tc, conglomid, -1, -1003152) && this.insertAndUpdate(tc, conglomid, 0, 2000000000) && this.deletetest(tc, conglomid, 1, 2);
    }

    protected boolean deletetest(TransactionController tc, long conglomid, int value1, int value2) throws StandardException, T_Fail {
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        T_AccessRow r1 = new T_AccessRow(1);
        r1.setCol(0, (DataValueDescriptor)new SQLInteger(value1));
        RowLocation rowloc = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc);
        if (!cc.delete(rowloc)) {
            throw T_Fail.testFailMsg("(deleteTest) delete of row failed");
        }
        DataValueDescriptor[] update_row = new DataValueDescriptor[1];
        FormatableBitSet update_desc = new FormatableBitSet(1);
        update_desc.set(0);
        if (cc.replace(rowloc, update_row, update_desc)) {
            throw T_Fail.testFailMsg("(deleteTest) partial column row replace returned true on del row");
        }
        if (cc.replace(rowloc, r1.getRowArray(), (FormatableBitSet)null)) {
            throw T_Fail.testFailMsg("(deleteTest) update returned true on del row");
        }
        if (cc.delete(rowloc)) {
            throw T_Fail.testFailMsg("(deleteTest) delete returned true on del row");
        }
        cc.close();
        return true;
    }

    protected boolean insertAndUpdate(TransactionController tc, long conglomid, int value1, int value2) throws StandardException, T_Fail {
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        T_AccessRow r1 = new T_AccessRow(1);
        r1.setCol(0, (DataValueDescriptor)new SQLInteger(value1));
        RowLocation rowloc = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc);
        DataValueDescriptor[] update_row = new DataValueDescriptor[]{new SQLInteger(value2)};
        FormatableBitSet update_desc = new FormatableBitSet(1);
        update_desc.set(0);
        cc.replace(rowloc, update_row, update_desc);
        T_AccessRow r2 = new T_AccessRow(1);
        SQLInteger c2 = new SQLInteger(0);
        r2.setCol(0, (DataValueDescriptor)c2);
        if (!cc.fetch(rowloc, r2.getRowArray(), (FormatableBitSet)null)) {
            throw T_Fail.testFailMsg("(insertAndUpdate) Fetch val not there.");
        }
        cc.close();
        if (c2.getInt() != value2) {
            throw T_Fail.testFailMsg("(insertAndUpdate) Fetch value != updated value.");
        }
        return true;
    }

    protected boolean scanExample(TransactionController tc) throws StandardException, T_Fail {
        tc.commit();
        if (!tc.isPristine() || !tc.isIdle() || tc.isGlobal()) {
            throw T_Fail.testFailMsg("(scanExample) bad xact state after commit.");
        }
        if (tc.countOpens(5) > 0 || tc.countOpens(1) > 0 || tc.countOpens(2) > 0 || tc.countOpens(3) > 0 || tc.countOpens(4) > 0) {
            System.out.println("OPENED 0:\n" + tc.debugOpened());
            return this.FAIL("unexpected open count.");
        }
        long conglomid = tc.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 0);
        this.REPORT("(scanExample) starting");
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        int[] values = new int[]{11, 22, 33, 44, 55, 66};
        T_AccessRow row = new T_AccessRow(1);
        for (int i = 0; i < values.length; ++i) {
            row.setCol(0, (DataValueDescriptor)new SQLInteger(values[i]));
            if (cc.insert(row.getRowArray()) == 0) continue;
            throw T_Fail.testFailMsg("(scanExample after insert) insert failed ");
        }
        this.REPORT("(scanExample) debug output testing: " + tc.debugOpened());
        cc.close();
        if (tc.countOpens(5) > 0 || tc.countOpens(1) > 0 || tc.countOpens(2) > 0 || tc.countOpens(3) > 0 || tc.countOpens(4) > 0) {
            System.out.println("OPENED 1:\n" + tc.debugOpened());
            return this.FAIL("unexpected open count.");
        }
        this.REPORT("(scanExample) rows inserted");
        int scanindex = 0;
        SQLInteger col = new SQLInteger(0);
        row.setCol(0, (DataValueDescriptor)col);
        this.flush_cache();
        StaticCompiledOpenConglomInfo static_info = tc.getStaticCompiledConglomInfo(conglomid);
        ScanController scan1 = tc.openCompiledScan(false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0, static_info, tc.getDynamicCompiledConglomInfo(conglomid));
        if (scan1.getEstimatedRowCount() != 6L) {
            throw T_Fail.testFailMsg("(scanExample) estimated row count not 6:" + scan1.getEstimatedRowCount());
        }
        scan1.setEstimatedRowCount(5L);
        if (scan1.getEstimatedRowCount() != 5L) {
            throw T_Fail.testFailMsg("(scanExample) estimated row count not 5");
        }
        while (scan1.next()) {
            scan1.fetch(row.getRowArray());
            if (col.getInt() != values[scanindex]) {
                throw T_Fail.testFailMsg("(scanExample after insert) Row " + scanindex + " should have been " + values[scanindex] + ", was " + col.getInt());
            }
            ++scanindex;
        }
        if (scan1.next()) {
            throw T_Fail.testFailMsg("(scanExample after insert) should continue to return false after reaching end of scan");
        }
        scan1.reopenScan(null, 0, null, null, 0);
        scan1.next();
        scan1.next();
        scan1.next();
        RowLocation third_row_rowloc = scan1.newRowLocationTemplate();
        scan1.fetchLocation(third_row_rowloc);
        scan1.reopenScanByRowLocation(third_row_rowloc, null);
        scanindex = 2;
        while (scan1.next()) {
            scan1.fetch(row.getRowArray());
            if (col.getInt() != values[scanindex]) {
                throw T_Fail.testFailMsg("(scanExample after insert) Row " + scanindex + " should have been " + values[scanindex] + ", was " + col.getInt());
            }
            ++scanindex;
        }
        scan1.close();
        if (scanindex != values.length) {
            throw T_Fail.testFailMsg("(scanExample after insert) Expected " + values.length + "rows, got " + scanindex);
        }
        this.REPORT("(scanExample) rows present and accounted for");
        ScanController scan2 = tc.openScan(conglomid, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        int[] newvalues = new int[]{22, 33, 444, 55, 6666};
        block9: while (scan2.next()) {
            scan2.fetch(row.getRowArray());
            switch (((SQLInteger)row.getCol(0)).getInt()) {
                case 11: {
                    if (scan2.delete()) continue block9;
                    throw T_Fail.testFailMsg("(scanExample) delete failed.");
                }
                case 22: 
                case 33: 
                case 55: {
                    continue block9;
                }
                case 44: {
                    DataValueDescriptor[] update_row = new DataValueDescriptor[]{new SQLInteger(444)};
                    FormatableBitSet update_desc = new FormatableBitSet(1);
                    update_desc.set(0);
                    if (scan2.replace(update_row, update_desc)) continue block9;
                    throw T_Fail.testFailMsg("(scanExample) partial column row replace failed.");
                }
                case 66: {
                    row.setCol(0, (DataValueDescriptor)new SQLInteger(6666));
                    if (scan2.replace(row.getRowArray(), (FormatableBitSet)null)) continue block9;
                    throw T_Fail.testFailMsg("(scanExample) replace failed.");
                }
            }
            throw T_Fail.testFailMsg("(scanExample) Read unexpected value.");
        }
        scan2.close();
        this.REPORT("(scanExample) rows fiddled with");
        ScanController scan3 = tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        scanindex = 0;
        row.setCol(0, (DataValueDescriptor)col);
        while (scan3.next()) {
            scan3.fetch(row.getRowArray());
            this.REPORT("(scanExample) scan3 fetched " + col.getInt());
            if (col.getInt() != newvalues[scanindex]) {
                throw T_Fail.testFailMsg("(scanExample after changes) Row " + scanindex + " should have been " + newvalues[scanindex] + ", was " + col.getInt());
            }
            ++scanindex;
        }
        scan3.close();
        scan3 = tc.openScan(conglomid, false, 0, 6, 1, (FormatableBitSet)null, null, 0, null, null, 0);
        scanindex = 0;
        row.setCol(0, (DataValueDescriptor)col);
        while (scan3.next()) {
            scan3.fetch(row.getRowArray());
            this.REPORT("(scanExample) scan3 fetched " + col.getInt());
            if (col.getInt() != newvalues[scanindex]) {
                throw T_Fail.testFailMsg("(scanExample after changes) Row " + scanindex + " should have been " + newvalues[scanindex] + ", was " + col.getInt());
            }
            ++scanindex;
        }
        scan3.close();
        if (scanindex != newvalues.length) {
            throw T_Fail.testFailMsg("(scanExample after changes) Expected " + newvalues.length + "rows, got " + scanindex);
        }
        this.REPORT("(scanExample) fiddled rows present and accounted for");
        this.REPORT("(scanExample) testing expected delete errors");
        ScanController scan4 = tc.openScan(conglomid, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        while (scan4.next()) {
            scan4.fetch(row.getRowArray());
            if (!scan4.doesCurrentPositionQualify()) {
                throw T_Fail.testFailMsg("(scanExample doesCurrentPositionQualify() errors) Expected requalify of current row to succeed");
            }
            if (((SQLInteger)row.getCol(0)).getInt() != 22) continue;
            if (scan4.delete()) break;
            throw T_Fail.testFailMsg("(scanExample delete errors) Delete failed.");
        }
        if (scan4.doesCurrentPositionQualify()) {
            throw T_Fail.testFailMsg("(scanExample doesCurrentPositionQualify() errors) Expected qualify of deleted row to FAIL");
        }
        DataValueDescriptor[] update_row = new DataValueDescriptor[1];
        FormatableBitSet update_desc = new FormatableBitSet(1);
        update_desc.set(0);
        if (scan4.replace(update_row, update_desc)) {
            throw T_Fail.testFailMsg("(scanExample delete errors) Expected partial column replace to FAIL");
        }
        if (scan4.replace(row.getRowArray(), (FormatableBitSet)null)) {
            throw T_Fail.testFailMsg("(scanExample after changes) Expected replace to FAIL");
        }
        if (scan4.delete()) {
            throw T_Fail.testFailMsg("(scanExample after changes) Expected delete to FAIL");
        }
        scan4.close();
        if (tc.countOpens(5) > 0 || tc.countOpens(1) > 0 || tc.countOpens(2) > 0 || tc.countOpens(3) > 0 || tc.countOpens(4) > 0) {
            System.out.println("OPENED:\n" + tc.debugOpened());
            return this.FAIL("unexpected open count.");
        }
        this.REPORT("(scanExample) completed");
        return true;
    }

    protected boolean dropTest(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(dropTest) starting");
        long orig_conglomid = tc.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 0);
        tc.commit();
        tc.dropConglomerate(orig_conglomid);
        try {
            ConglomerateController cc = tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
            throw T_Fail.testFailMsg("Open conglom on deleted conglom worked.");
        }
        catch (StandardException e) {
            if (!e.getMessageId().equals("XSAI2.S")) {
                throw e;
            }
            try {
                ConglomerateController cc = tc.openConglomerate(42424242L, false, 4, 6, 5);
                throw T_Fail.testFailMsg("Open conglom on deleted conglom worked.");
            }
            catch (StandardException e22) {
                if (!e22.getMessageId().equals("XSAI2.S")) {
                    throw e22;
                }
                try {
                    tc.dropConglomerate(orig_conglomid);
                    throw T_Fail.testFailMsg("Delete conglom on deleted conglom worked.");
                }
                catch (StandardException e22) {
                    long conglomid = tc.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 0);
                    ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
                    tc.abort();
                    cc = tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
                    cc.close();
                    return true;
                }
            }
        }
    }

    protected boolean getTableProperties(TransactionController tc) throws StandardException, T_Fail {
        Properties prop = new Properties();
        prop.put("derby.storage.pageSize", "8192");
        prop.put("derby.storage.pageReservedSpace", "99");
        prop.put("derby.storage.minimumRecordSize", "42");
        prop.put("derby.storage.initialPages", "22");
        T_AccessRow template_row = new T_AccessRow(1);
        long conglomid = tc.createConglomerate("heap", template_row.getRowArray(), null, null, prop, 0);
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        Properties ret_prop = tc.getUserCreateConglomPropList();
        cc.getTableProperties(ret_prop);
        if (ret_prop.getProperty("derby.storage.pageSize").compareTo("8192") != 0 || ret_prop.getProperty("derby.storage.pageReservedSpace").compareTo("99") != 0 || ret_prop.getProperty("derby.storage.minimumRecordSize").compareTo("42") != 0 || ret_prop.getProperty("derby.storage.initialPages").compareTo("22") != 0) {
            throw T_Fail.testFailMsg("(getTableProperties) Did not get expected table propertes(1).\nGot pageSize = " + ret_prop.getProperty("derby.storage.pageSize") + "\nGot reserved = " + ret_prop.getProperty("derby.storage.pageReservedSpace") + "\nGot minimum record size = " + ret_prop.getProperty("derby.storage.minimumRecordSize") + "\nGot initial pages = " + ret_prop.getProperty("derby.storage.initialPages"));
        }
        ret_prop = cc.getInternalTablePropertySet(null);
        if (ret_prop.getProperty("derby.storage.pageSize").compareTo("8192") != 0 || ret_prop.getProperty("derby.storage.pageReservedSpace").compareTo("99") != 0 || ret_prop.getProperty("derby.storage.minimumRecordSize").compareTo("42") != 0 || ret_prop.getProperty("derby.storage.initialPages").compareTo("22") != 0) {
            throw T_Fail.testFailMsg("(getTableProperties) Did not get expected table propertes(2).\nGot pageSize = " + ret_prop.getProperty("derby.storage.pageSize") + "\nGot reserved = " + ret_prop.getProperty("derby.storage.pageReservedSpace") + "\nGot minimum record size = " + ret_prop.getProperty("derby.storage.minimumRecordSize") + "\nGot initial pages = " + ret_prop.getProperty("derby.storage.initialPages"));
        }
        ret_prop = new Properties();
        if ((ret_prop = cc.getInternalTablePropertySet(ret_prop)).getProperty("derby.storage.pageSize").compareTo("8192") != 0 || ret_prop.getProperty("derby.storage.pageReservedSpace").compareTo("99") != 0 || ret_prop.getProperty("derby.storage.minimumRecordSize").compareTo("42") != 0 || ret_prop.getProperty("derby.storage.initialPages").compareTo("22") != 0) {
            throw T_Fail.testFailMsg("(getTableProperties) Did not get expected table propertes(3).\nGot pageSize = " + ret_prop.getProperty("derby.storage.pageSize") + "\nGot reserved = " + ret_prop.getProperty("derby.storage.pageReservedSpace") + "\nGot minimum record size = " + ret_prop.getProperty("derby.storage.minimumRecordSize") + "\nGot initial pages = " + ret_prop.getProperty("derby.storage.initialPages"));
        }
        return true;
    }

    private boolean alterTable(TransactionController tc, boolean temporary) throws StandardException, T_Fail {
        this.REPORT("(alterTable) starting");
        T_AccessRow template_row = new T_AccessRow(1);
        int temporaryFlag = temporary ? 1 : 0;
        long conglomid = tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, temporaryFlag);
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        T_AccessRow r1 = new T_AccessRow(1);
        SQLInteger c1 = new SQLInteger(1);
        r1.setCol(0, (DataValueDescriptor)c1);
        RowLocation rowloc1 = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc1);
        r1.setCol(0, (DataValueDescriptor)new SQLInteger(2));
        RowLocation rowloc2 = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc2);
        try {
            T_AccessRow two_column_row = new T_AccessRow(2);
            SQLInteger col1 = new SQLInteger(3);
            SQLInteger col2 = new SQLInteger(3);
            cc.insert(two_column_row.getRowArray());
            throw T_Fail.testFailMsg("(alterTable) Allowed insert of bad row.");
        }
        catch (StandardException two_column_row) {
            try {
                T_AccessRow two_column_row2 = new T_AccessRow(2);
                if (!cc.fetch(rowloc1, two_column_row2.getRowArray(), (FormatableBitSet)null)) {
                    throw T_Fail.testFailMsg("(alterTable) Allowed fetch of bad row, bad ret val.");
                }
                throw T_Fail.testFailMsg("(alterTable) Allowed fetch of bad row.");
            }
            catch (StandardException two_column_row2) {
                try {
                    DataValueDescriptor[] third_column_row = new DataValueDescriptor[3];
                    third_column_row[2] = new SQLInteger(3);
                    FormatableBitSet fetch_desc = new FormatableBitSet(3);
                    fetch_desc.set(2);
                    if (!cc.fetch(rowloc1, third_column_row, fetch_desc)) {
                        throw T_Fail.testFailMsg("(alterTable) Allowed fetch of bad row, bad ret val.");
                    }
                    throw T_Fail.testFailMsg("(alterTable) Allowed fetch of bad row.");
                }
                catch (StandardException third_column_row) {
                    try {
                        T_AccessRow two_column_row3 = new T_AccessRow(2);
                        SQLInteger col1 = new SQLInteger(3);
                        SQLInteger col2 = new SQLInteger(3);
                        cc.replace(rowloc1, two_column_row3.getRowArray(), null);
                        throw T_Fail.testFailMsg("(alterTable) Allowed replace of bad row.");
                    }
                    catch (StandardException two_column_row3) {
                        try {
                            DataValueDescriptor[] second_column_row = new DataValueDescriptor[2];
                            second_column_row[1] = new SQLInteger(3);
                            FormatableBitSet update_desc = new FormatableBitSet(2);
                            update_desc.set(1);
                            cc.replace(rowloc1, second_column_row, update_desc);
                            throw T_Fail.testFailMsg("(alterTable) Allowed partial row update of bad column.");
                        }
                        catch (StandardException second_column_row) {
                            int key_value;
                            tc.commitNoSync(1);
                            tc.addColumnToConglomerate(conglomid, 1, (Storable)c1, 0);
                            cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
                            T_AccessRow two_column_row4 = new T_AccessRow(2);
                            SQLInteger col1 = new SQLInteger(3);
                            SQLInteger col2 = new SQLInteger(3);
                            if (!cc.fetch(rowloc1, two_column_row4.getRowArray(), (FormatableBitSet)null)) {
                                throw T_Fail.testFailMsg("(alterTable) Row not there.");
                            }
                            if (((SQLInteger)two_column_row4.getCol(0)).getInt() != 1 || !two_column_row4.getCol(1).isNull()) {
                                throw T_Fail.testFailMsg("(alterTable) Bad column value after alter.");
                            }
                            if (!cc.fetch(rowloc2, two_column_row4.getRowArray(), (FormatableBitSet)null)) {
                                throw T_Fail.testFailMsg("(alterTable) Row not there.");
                            }
                            if (((SQLInteger)two_column_row4.getCol(0)).getInt() != 2 || !two_column_row4.getCol(1).isNull()) {
                                throw T_Fail.testFailMsg("(alterTable) Bad column value after alter.");
                            }
                            two_column_row4 = new T_AccessRow(2);
                            two_column_row4.setCol(0, (DataValueDescriptor)new SQLInteger(3));
                            two_column_row4.setCol(1, (DataValueDescriptor)new SQLInteger(300));
                            cc.insert(two_column_row4.getRowArray());
                            ScanController scan = tc.openScan(conglomid, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
                            block18: while (scan.next()) {
                                scan.fetch(two_column_row4.getRowArray());
                                key_value = ((SQLInteger)two_column_row4.getCol(0)).getInt();
                                switch (key_value) {
                                    case 1: {
                                        if (!two_column_row4.getCol(1).isNull()) {
                                            throw T_Fail.testFailMsg("(alterTable) Bad column value after alter.");
                                        }
                                        two_column_row4.setCol(1, (DataValueDescriptor)new SQLInteger(100));
                                        scan.replace(two_column_row4.getRowArray(), (FormatableBitSet)null);
                                        continue block18;
                                    }
                                    case 2: {
                                        if (!two_column_row4.getCol(1).isNull()) {
                                            throw T_Fail.testFailMsg("(alterTable) Bad column value after alter.");
                                        }
                                        two_column_row4.setCol(1, (DataValueDescriptor)new SQLInteger(200));
                                        scan.replace(two_column_row4.getRowArray(), (FormatableBitSet)null);
                                        continue block18;
                                    }
                                    case 3: {
                                        continue block18;
                                    }
                                }
                                throw T_Fail.testFailMsg("(alterTable) bad row value found in table.");
                            }
                            scan.reopenScan(null, 0, null, null, 0);
                            block19: while (scan.next()) {
                                scan.fetch(two_column_row4.getRowArray());
                                key_value = ((SQLInteger)two_column_row4.getCol(0)).getInt();
                                switch (key_value) {
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        int second_col_val = ((SQLInteger)two_column_row4.getCol(1)).getInt();
                                        if (second_col_val == key_value * 100) continue block19;
                                        throw T_Fail.testFailMsg("(alterTable) Bad column value after alter.expected: (" + key_value + ", " + key_value * 100 + ")\ngot     : (" + key_value + ", " + second_col_val + ")\n");
                                    }
                                }
                                throw T_Fail.testFailMsg("(alterTable) bad row value found in table.");
                            }
                            scan.close();
                            tc.commit();
                            this.REPORT("(alterTable) completed");
                            return true;
                        }
                    }
                }
            }
        }
    }

    protected boolean scanInfo(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(scanInfo) starting");
        T_AccessRow template_row = new T_AccessRow(2);
        long conglomid = tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        T_AccessRow r1 = new T_AccessRow(2);
        SQLInteger c1 = new SQLInteger(1);
        SQLInteger c2 = new SQLInteger(100);
        r1.setCol(0, (DataValueDescriptor)c1);
        r1.setCol(1, (DataValueDescriptor)c2);
        RowLocation rowloc1 = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc1);
        r1.setCol(0, (DataValueDescriptor)new SQLInteger(2));
        r1.setCol(1, (DataValueDescriptor)new SQLInteger(200));
        RowLocation rowloc2 = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc2);
        cc.delete(rowloc2);
        if (tc.isPristine() || tc.isIdle()) {
            throw T_Fail.testFailMsg("(scanInfo) bad xact state after update xact.");
        }
        tc.commit();
        ScanController scan = tc.openScan(conglomid, false, 0, 7, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        if (!scan.isTableLocked()) {
            throw T_Fail.testFailMsg("(scanInfo) table should be table locked.");
        }
        while (scan.next()) {
            scan.fetch(r1.getRowArray());
        }
        ScanInfo scan_info = scan.getScanInfo();
        Properties prop = scan_info.getAllScanInfo(null);
        if (!tc.isPristine() || tc.isIdle()) {
            throw T_Fail.testFailMsg("(scanInfo) bad xact state after update xact.");
        }
        this.REPORT("return from full row scan heap.getScanInfo() = " + String.valueOf(prop));
        if (Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ1.U", (Object[])new Object[0]))) != 1) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numPagesVisited.  Expected 1, got " + Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ1.U", (Object[])new Object[0]))));
        }
        if (Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ2.U", (Object[])new Object[0]))) != 2) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numRowsVisited. Expected 2, got " + Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ2.U", (Object[])new Object[0]))));
        }
        if (Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ4.U", (Object[])new Object[0]))) != 1) {
            throw T_Fail.testFailMsg("(scanInfo) wrong numRowsQualified. Expected 1, got " + Integer.parseInt(prop.getProperty(MessageService.getTextMessage((String)"XSAJ4.U", (Object[])new Object[0]))));
        }
        FormatableBitSet validColumns = new FormatableBitSet(3);
        validColumns.set(1);
        scan = tc.openScan(conglomid, false, 4, 6, 5, validColumns, null, 0, null, null, 0);
        if (scan.isTableLocked()) {
            throw T_Fail.testFailMsg("(scanInfo) table should be row locked.");
        }
        scan_info = scan.getScanInfo();
        prop = scan_info.getAllScanInfo(null);
        this.REPORT("return from partial scan heap.getScanInfo() = " + String.valueOf(prop));
        this.REPORT("(scanInfo) finishing");
        return true;
    }

    protected boolean partialScan(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(partialScan) starting");
        T_AccessRow template_row = new T_AccessRow(2);
        long conglomid = tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        T_AccessRow r1 = new T_AccessRow(2);
        SQLInteger c1 = new SQLInteger(1);
        SQLInteger c2 = new SQLInteger(100);
        r1.setCol(0, (DataValueDescriptor)c1);
        r1.setCol(1, (DataValueDescriptor)c2);
        RowLocation rowloc1 = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc1);
        r1.setCol(0, (DataValueDescriptor)new SQLInteger(2));
        r1.setCol(1, (DataValueDescriptor)new SQLInteger(200));
        RowLocation rowloc2 = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc2);
        cc.delete(rowloc2);
        tc.commit();
        FormatableBitSet validColumns = new FormatableBitSet();
        ScanController scan = tc.openScan(conglomid, false, 4, 6, 5, validColumns, null, 0, null, null, 0);
        if (!scan.next()) {
            throw T_Fail.testFailMsg("(partialScan) did not see first row.");
        }
        if (scan.next()) {
            throw T_Fail.testFailMsg("(partialScan) saw more than one row.");
        }
        this.REPORT("(partialScan) finishing");
        return true;
    }

    protected boolean insert_bench(TransactionController tc) throws StandardException, T_Fail {
        ConglomerateController cc = null;
        ScanController scan = null;
        long conglomid = -1L;
        T_AccessRow r1 = new T_AccessRow(1);
        long iter = 100L;
        for (int numcols = 1; numcols < 101; numcols *= 10) {
            int i;
            conglomid = tc.createConglomerate("heap", new T_AccessRow(numcols).getRowArray(), null, null, null, 0);
            tc.commit();
            cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
            for (i = 0; i < numcols; ++i) {
                r1.setCol(i, (DataValueDescriptor)new SQLInteger(numcols));
            }
            long before = System.currentTimeMillis();
            i = 0;
            while ((long)i < iter) {
                if (cc.insert(r1.getRowArray()) != 0) {
                    throw T_Fail.testFailMsg("(insert_bench) insert failed ");
                }
                ++i;
            }
            long after = System.currentTimeMillis();
            this.REPORT("insert " + iter + " rows of " + numcols + " integer cols = " + (after - before) + " milliseconds.\n");
            before = System.currentTimeMillis();
            i = 0;
            while ((long)i < iter) {
                if (cc.insert(r1.getRowArray()) != 0) {
                    throw T_Fail.testFailMsg("(insert_bench) insert failed ");
                }
                ++i;
            }
            after = System.currentTimeMillis();
            this.REPORT("second insert " + iter + " rows of " + numcols + " integer cols = " + (after - before) + " milliseconds.\n");
            before = System.currentTimeMillis();
            scan = tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
            before = System.currentTimeMillis();
            while (scan.next()) {
                scan.fetch(r1.getRowArray());
            }
            after = System.currentTimeMillis();
            this.REPORT("scan " + 2L * iter + " rows of " + numcols + " integer cols = " + (after - before) + " milliseconds.\n");
            cc.close();
            tc.commit();
        }
        return true;
    }

    protected boolean sortCost(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(sortCost) starting");
        T_AccessRow template_row = new T_AccessRow(2);
        long conglomid = tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        T_AccessRow r1 = new T_AccessRow(2);
        SQLInteger c1 = new SQLInteger(1);
        SQLInteger c2 = new SQLInteger(100);
        r1.setCol(0, (DataValueDescriptor)c1);
        r1.setCol(1, (DataValueDescriptor)c2);
        RowLocation rowloc1 = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc1);
        cc.close();
        tc.commit();
        this.flush_cache();
        SortCostController scc = tc.openSortCostController();
        double estimated_cost = scc.getSortCost(template_row.getRowArray(), null, false, 10000L, 100L, 100);
        if (estimated_cost <= 0.0) {
            throw T_Fail.testFailMsg("(storeCost) estimated sort cost :" + estimated_cost);
        }
        this.REPORT("(sortCost) finishing");
        return true;
    }

    protected boolean storeCost(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(storeCost) starting");
        T_AccessRow template_row = new T_AccessRow(2);
        long conglomid = tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        T_AccessRow r1 = new T_AccessRow(2);
        SQLInteger c1 = new SQLInteger(1);
        SQLInteger c2 = new SQLInteger(100);
        r1.setCol(0, (DataValueDescriptor)c1);
        r1.setCol(1, (DataValueDescriptor)c2);
        RowLocation rowloc1 = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc1);
        cc.close();
        tc.commit();
        this.flush_cache();
        StoreCostController scc = tc.openStoreCost(conglomid);
        if (scc.getEstimatedRowCount() != 1L) {
            throw T_Fail.testFailMsg("(storeCost) estimated row count not 1:" + scc.getEstimatedRowCount());
        }
        scc.setEstimatedRowCount(5L);
        if (scc.getEstimatedRowCount() != 5L) {
            throw T_Fail.testFailMsg("(storeCost) estimated row count not 5");
        }
        scc.setEstimatedRowCount(1L);
        double fetch_cost = scc.getFetchFromRowLocationCost((FormatableBitSet)null, 0);
        fetch_cost = scc.getFetchFromRowLocationCost(new FormatableBitSet(0), 0);
        this.REPORT("fetch cost (full row) of row loc = " + fetch_cost);
        fetch_cost = scc.getFetchFromRowLocationCost(new FormatableBitSet(1), 0);
        FormatableBitSet bit_set = new FormatableBitSet(2);
        this.REPORT("fetch cost (no cols) of row loc = " + fetch_cost);
        bit_set.set(1);
        fetch_cost = scc.getFetchFromRowLocationCost(new FormatableBitSet(1), 0);
        this.REPORT("fetch cost (1 col) of row loc = " + fetch_cost);
        T_StoreCostResult cost_result = new T_StoreCostResult();
        scc.getScanCost(2, -1L, 1, false, (FormatableBitSet)null, new T_AccessRow(2).getRowArray(), null, 0, null, 0, false, 0, (StoreCostResult)cost_result);
        this.REPORT("fetch scan cost (full row) of row loc = " + String.valueOf(cost_result));
        scc.getScanCost(2, -1L, 1, false, new FormatableBitSet(0), new T_AccessRow(2).getRowArray(), null, 0, null, 0, false, 0, (StoreCostResult)cost_result);
        this.REPORT("fetch scan cost (no cols) of row loc = " + String.valueOf(cost_result));
        scc.getScanCost(2, -1L, 1, false, new FormatableBitSet(1), new T_AccessRow(2).getRowArray(), null, 0, null, 0, false, 0, (StoreCostResult)cost_result);
        this.REPORT("fetch scan cost (no cols) of row loc = " + String.valueOf(cost_result));
        bit_set = new FormatableBitSet(2);
        bit_set.set(1);
        scc.getScanCost(2, -1L, 1, false, bit_set, new T_AccessRow(2).getRowArray(), null, 0, null, 0, false, 0, (StoreCostResult)cost_result);
        this.REPORT("fetch scan cost (1 cols) of row loc = " + String.valueOf(cost_result));
        rowloc1 = scc.newRowLocationTemplate();
        this.REPORT("(storeCost) finishing");
        return true;
    }

    protected boolean transactionalProperties(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("start transactionalProperties");
        tc.setProperty("T_Key_Frog", (Serializable)new SQLLongint(479L), false);
        tc.setProperty("T_Key_Tiger", (Serializable)((Object)"Roar, ROAR"), false);
        long lvalue = ((SQLLongint)tc.getProperty("T_Key_Frog")).getLong();
        if (lvalue != 479L) {
            throw T_Fail.testFailMsg("setProperty() - expected 479 - got " + lvalue);
        }
        String svalue = (String)((Object)tc.getProperty("T_Key_Tiger"));
        if (!svalue.equals("Roar, ROAR")) {
            throw T_Fail.testFailMsg("setProperty() - expected 'Roar, ROAR' - got " + svalue);
        }
        tc.commit();
        lvalue = ((SQLLongint)tc.getProperty("T_Key_Frog")).getLong();
        if (lvalue != 479L) {
            throw T_Fail.testFailMsg("setProperty() - expected 479 - got " + lvalue);
        }
        svalue = (String)((Object)tc.getProperty("T_Key_Tiger"));
        if (!svalue.equals("Roar, ROAR")) {
            throw T_Fail.testFailMsg("setProperty() - expected 'Roar, ROAR' - got " + svalue);
        }
        tc.commit();
        tc.setProperty("T_Key_Tiger", (Serializable)((Object)"mieow, mieow"), false);
        svalue = (String)((Object)tc.getProperty("T_Key_Tiger"));
        if (!svalue.equals("mieow, mieow")) {
            throw T_Fail.testFailMsg("setProperty() - expected 'mieow, mieow' - got " + svalue);
        }
        tc.commit();
        svalue = (String)((Object)tc.getProperty("T_Key_Tiger"));
        if (!svalue.equals("mieow, mieow")) {
            throw T_Fail.testFailMsg("setProperty() - expected 'mieow, mieow' - got " + svalue);
        }
        tc.setProperty("T_Key_Tiger", (Serializable)new SQLLongint(570L), false);
        lvalue = ((SQLLongint)tc.getProperty("T_Key_Tiger")).getLong();
        if (lvalue != 570L) {
            throw T_Fail.testFailMsg("setProperty() - expected 570 - got " + lvalue);
        }
        tc.commit();
        lvalue = ((SQLLongint)tc.getProperty("T_Key_Tiger")).getLong();
        if (lvalue != 570L) {
            throw T_Fail.testFailMsg("setProperty() - expected 570 - got " + lvalue);
        }
        tc.commit();
        tc.setProperty("T_Key_Frog", (Serializable)null, false);
        if (tc.getProperty("T_Key_Frog") != null) {
            throw T_Fail.testFailMsg("setProperty() - delete failed");
        }
        tc.commit();
        if (tc.getProperty("T_Key_Frog") != null) {
            throw T_Fail.testFailMsg("setProperty() - delete failed");
        }
        tc.commit();
        tc.setProperty("T_Key_Tiger", (Serializable)new SQLLongint(457L), false);
        tc.abort();
        lvalue = ((SQLLongint)tc.getProperty("T_Key_Tiger")).getLong();
        if (lvalue != 570L) {
            throw T_Fail.testFailMsg("setProperty() - expected 570 - got " + lvalue);
        }
        tc.commit();
        this.PASS("transactionalProperties");
        return true;
    }

    protected boolean tempTest(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(tempTest) starting");
        long cid5252t = this.createAConglom(tc, 5252, true);
        long cid87t = this.createAConglom(tc, 87, true);
        long cid999p = this.createAConglom(tc, 999, false);
        long cid3t = this.createAConglom(tc, 3, true);
        long cid5252ti = this.createBtree(tc, cid5252t, true);
        long cid999pi = this.createBtree(tc, cid999p, false);
        int r = this.checkAConglom(tc, null, cid5252t, 5252);
        if (r != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid5252t) == " + r);
        }
        r = this.checkAConglom(tc, this.getBtreeTemplate(tc, cid5252t), cid5252ti, 5252);
        if (r != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid5252ti) == " + r);
        }
        r = this.checkAConglom(tc, null, cid999p, 999);
        if (r != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid999p) == " + r);
        }
        r = this.checkAConglom(tc, this.getBtreeTemplate(tc, cid999p), cid999pi, 999);
        if (r != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid999pi) == " + r);
        }
        r = this.checkAConglom(tc, null, cid3t, 3);
        if (r != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid3t) == " + r);
        }
        r = this.checkAConglom(tc, null, cid87t, 87);
        if (r != 1) {
            throw T_Fail.testFailMsg("(tempTest) after create checkAConglom(cid87t) == " + r);
        }
        tc.dropConglomerate(cid999pi);
        tc.dropConglomerate(cid999p);
        tc.dropConglomerate(cid87t);
        try {
            tc.dropConglomerate(cid999p);
            throw T_Fail.testFailMsg("(tempTest) drop of dropped cid999p succeeded");
        }
        catch (StandardException standardException) {
            try {
                tc.dropConglomerate(cid999pi);
                throw T_Fail.testFailMsg("(tempTest) drop of dropped cid999pi succeeded");
            }
            catch (StandardException standardException2) {
                try {
                    tc.dropConglomerate(cid87t);
                    throw T_Fail.testFailMsg("(tempTest) drop of dropped cid87t succeeded");
                }
                catch (StandardException standardException3) {
                    r = this.checkAConglom(tc, null, cid5252t, 5252);
                    if (r != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after drop checkAConglom(cid5252t) == " + r);
                    }
                    r = this.checkAConglom(tc, this.getBtreeTemplate(tc, cid5252t), cid5252ti, 5252);
                    if (r != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after drop checkAConglom(cid5252ti) == " + r);
                    }
                    r = this.checkAConglom(tc, null, cid3t, 3);
                    if (r != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after drop checkAConglom(cid3t) == " + r);
                    }
                    tc.commitNoSync(1);
                    r = this.checkAConglom(tc, null, cid5252t, 5252);
                    if (r != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after commit checkAConglom(cid5252t) == " + r);
                    }
                    r = this.checkAConglom(tc, this.getBtreeTemplate(tc, cid5252t), cid5252ti, 5252);
                    if (r != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after commit checkAConglom(cid5252ti) == " + r);
                    }
                    r = this.checkAConglom(tc, null, cid3t, 3);
                    if (r != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after commit checkAConglom(cid3t) == " + r);
                    }
                    ScanController sc = tc.openScan(cid3t, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
                    sc.close();
                    tc.abort();
                    r = this.checkAConglom(tc, null, cid5252t, 5252);
                    if (r != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after abort checkAConglom(cid5252t) == " + r);
                    }
                    r = this.checkAConglom(tc, null, cid3t, 3);
                    if (r != 1) {
                        throw T_Fail.testFailMsg("(tempTest) after abort checkAConglom(cid3t) == " + r);
                    }
                    tc.dropConglomerate(cid5252ti);
                    if (tc.conglomerateExists(cid5252ti)) {
                        throw T_Fail.testFailMsg("(tempTest) after drop cid5252ti still exists");
                    }
                    tc.dropConglomerate(cid5252t);
                    if (tc.conglomerateExists(cid5252t)) {
                        throw T_Fail.testFailMsg("(tempTest) after drop cid5252t still exists");
                    }
                    this.REPORT("(tempTest) succeeded");
                    return true;
                }
            }
        }
    }

    private long createAConglom(TransactionController tc, int testValue, boolean temporary) throws StandardException {
        long cid = tc.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, temporary ? 1 : 0);
        ConglomerateController cc = tc.openConglomerate(cid, false, 4, 6, 5);
        T_AccessRow row = new T_AccessRow(1);
        SQLLongint col = new SQLLongint((long)testValue);
        row.setCol(0, (DataValueDescriptor)col);
        cc.insert(row.getRowArray());
        cc.close();
        return cid;
    }

    private DataValueDescriptor[] getBtreeTemplate(TransactionController tc, long baseConglomId) throws StandardException {
        FormatableBitSet singleColumn = new FormatableBitSet(1);
        singleColumn.set(0);
        ScanController sc = tc.openScan(baseConglomId, false, 0, 6, 5, singleColumn, null, 0, null, null, 0);
        T_AccessRow template = new T_AccessRow(2);
        SQLLongint col0 = new SQLLongint(0L);
        RowLocation col1 = sc.newRowLocationTemplate();
        template.setCol(0, (DataValueDescriptor)col0);
        template.setCol(1, (DataValueDescriptor)col1);
        sc.close();
        return template.getRowArray();
    }

    private long createBtree(TransactionController tc, long baseConglomId, boolean temporary) throws StandardException {
        Properties indexProps = new Properties();
        indexProps.put("baseConglomerateId", Long.toString(baseConglomId));
        indexProps.put("nUniqueColumns", "1");
        indexProps.put("rowLocationColumn", "1");
        indexProps.put("nKeyFields", "2");
        FormatableBitSet singleColumn = new FormatableBitSet(1);
        singleColumn.set(0);
        ScanController sc = tc.openScan(baseConglomId, false, 0, 6, 5, singleColumn, null, 0, null, null, 0);
        T_AccessRow template = new T_AccessRow(2);
        SQLLongint col0 = new SQLLongint(0L);
        RowLocation col1 = sc.newRowLocationTemplate();
        template.setCol(0, (DataValueDescriptor)col0);
        template.setCol(1, (DataValueDescriptor)col1);
        DataValueDescriptor[] baseRow = new DataValueDescriptor[]{col0};
        long iid = tc.createConglomerate("BTREE", template.getRowArray(), null, null, indexProps, temporary ? 1 : 0);
        ConglomerateController cc = tc.openConglomerate(iid, false, 4, 6, 5);
        while (sc.next()) {
            sc.fetch(baseRow);
            sc.fetchLocation(col1);
            cc.insert(template.getRowArray());
        }
        cc.close();
        return iid;
    }

    private int checkAConglom(TransactionController tc, DataValueDescriptor[] scratch_template, long conglomId, int testValue) throws StandardException {
        if (!tc.conglomerateExists(conglomId)) {
            return -1;
        }
        ScanController sc = tc.openScan(conglomId, false, 0, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        T_AccessRow row = new T_AccessRow(1);
        SQLLongint col = new SQLLongint(0L);
        row.setCol(0, (DataValueDescriptor)col);
        int nrows = 0;
        while (sc.next()) {
            sc.fetch(row.getRowArray());
            if (((SQLLongint)row.getCol(0)).getLong() != (long)testValue) {
                return -2;
            }
            ++nrows;
        }
        sc.close();
        return nrows;
    }

    protected boolean updatelocks(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(updatelocks starting.)");
        this.updatelocks_0(tc, 5);
        this.updatelocks_0(tc, 2);
        this.REPORT("(updatelocks ending.)");
        return true;
    }

    protected boolean updatelocks_0(TransactionController tc, int isolation_level) throws StandardException, T_Fail {
        T_AccessRow update_row;
        int key_value;
        T_AccessRow r1 = new T_AccessRow(2);
        SQLInteger c1 = new SQLInteger(1);
        SQLInteger c2 = new SQLInteger(100);
        r1.setCol(0, (DataValueDescriptor)c1);
        r1.setCol(1, (DataValueDescriptor)c2);
        long orig_conglomid = tc.createConglomerate("heap", r1.getRowArray(), null, null, null, 0);
        ConglomerateController cc = tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
        r1.setCol(0, (DataValueDescriptor)new SQLInteger(1));
        r1.setCol(1, (DataValueDescriptor)new SQLInteger(100));
        cc.insert(r1.getRowArray());
        r1.setCol(0, (DataValueDescriptor)new SQLInteger(2));
        r1.setCol(1, (DataValueDescriptor)new SQLInteger(200));
        cc.insert(r1.getRowArray());
        r1.setCol(0, (DataValueDescriptor)new SQLInteger(3));
        r1.setCol(1, (DataValueDescriptor)new SQLInteger(300));
        cc.insert(r1.getRowArray());
        cc.close();
        tc.commit();
        this.REPORT("(updatelocks ending.)");
        ScanController sc = tc.openScan(orig_conglomid, false, 4100, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        boolean found_row_2 = false;
        block13: while (sc.next()) {
            sc.fetch(r1.getRowArray());
            key_value = ((SQLInteger)r1.getCol(0)).getInt();
            switch (key_value) {
                case 1: {
                    sc.delete();
                    continue block13;
                }
                case 2: {
                    found_row_2 = true;
                    continue block13;
                }
                case 3: {
                    update_row = new T_AccessRow(2);
                    r1.setCol(0, (DataValueDescriptor)new SQLInteger(30));
                    r1.setCol(1, (DataValueDescriptor)new SQLInteger(3000));
                    sc.replace(r1.getRowArray(), null);
                    continue block13;
                }
            }
            throw T_Fail.testFailMsg("(updatelock) bad row value found in table.");
        }
        if (!found_row_2) {
            throw T_Fail.testFailMsg("(updatelock) did not find row in first scan.");
        }
        sc.reopenScan(null, 0, null, null, 0);
        found_row_2 = false;
        block14: while (sc.next()) {
            sc.fetch(r1.getRowArray());
            key_value = ((SQLInteger)r1.getCol(0)).getInt();
            switch (key_value) {
                case 2: {
                    found_row_2 = true;
                    continue block14;
                }
                case 30: {
                    update_row = new T_AccessRow(2);
                    r1.setCol(0, (DataValueDescriptor)new SQLInteger(40));
                    r1.setCol(1, (DataValueDescriptor)new SQLInteger(4000));
                    sc.replace(r1.getRowArray(), null);
                    continue block14;
                }
            }
            throw T_Fail.testFailMsg("(updatelock) bad row value found in table.");
        }
        if (!found_row_2) {
            throw T_Fail.testFailMsg("(updatelock) did not find row in second scan.");
        }
        sc.close();
        tc.commit();
        sc = tc.openScan(orig_conglomid, false, 4100, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        found_row_2 = false;
        block15: while (sc.next()) {
            sc.fetch(r1.getRowArray());
            key_value = ((SQLInteger)r1.getCol(0)).getInt();
            switch (key_value) {
                case 2: {
                    found_row_2 = true;
                    continue block15;
                }
                case 40: {
                    update_row = new T_AccessRow(2);
                    r1.setCol(0, (DataValueDescriptor)new SQLInteger(30));
                    r1.setCol(1, (DataValueDescriptor)new SQLInteger(3000));
                    sc.replace(r1.getRowArray(), null);
                    continue block15;
                }
            }
            throw T_Fail.testFailMsg("(updatelock) bad row value found in table.");
        }
        if (!found_row_2) {
            throw T_Fail.testFailMsg("(updatelock) did not find row in first scan.");
        }
        return true;
    }

    protected boolean nestedUserTransaction(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(nestedUserTransaction) starting");
        long orig_conglomid = tc.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 0);
        long tmp_conglomid = tc.createConglomerate("heap", new T_AccessRow(1).getRowArray(), null, null, null, 1);
        TransactionController current_xact = this.store.getTransaction(T_AccessFactory.getContextService().getCurrentContextManager());
        TransactionController child_tc = tc.startNestedUserTransaction(true, true);
        TransactionController current_xact_after_nest = this.store.getTransaction(T_AccessFactory.getContextService().getCurrentContextManager());
        if (current_xact_after_nest != current_xact) {
            throw T_Fail.testFailMsg("(nestedUserTransaction) getTransaction() return changed after startNestedUserTransaction().current_xact = " + String.valueOf(current_xact) + ";current_xact_after_nest = " + String.valueOf(current_xact_after_nest));
        }
        T_Fail.T_ASSERT(tc.getLockSpace() == child_tc.getLockSpace(), "getLockSpace() returned different object for child.");
        ConglomerateController cc = child_tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
        ConglomerateController tmp_cc = child_tc.openConglomerate(tmp_conglomid, false, 4, 6, 5);
        cc.close();
        tmp_cc.close();
        child_tc.commit();
        child_tc.destroy();
        tc.dropConglomerate(orig_conglomid);
        child_tc = tc.startNestedUserTransaction(true, true);
        try {
            child_tc.startNestedUserTransaction(true, true);
            throw T_Fail.testFailMsg("(nestedUserTransaction) double nest xact not allowed.");
        }
        catch (StandardException standardException) {
            child_tc.commit();
            child_tc.destroy();
            Object twok_string = new String("0123456789012345");
            for (int i = 0; i < 7; ++i) {
                twok_string = (String)twok_string + (String)twok_string;
            }
            T_AccessRow big_row = new T_AccessRow(2);
            big_row.setCol(1, (DataValueDescriptor)new SQLChar((String)twok_string));
            orig_conglomid = tc.createConglomerate("heap", big_row.getRowArray(), null, null, null, 0);
            child_tc = tc.startNestedUserTransaction(true, true);
            cc = child_tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
            child_tc.abort();
            child_tc.destroy();
            try {
                cc = tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
                throw T_Fail.testFailMsg("(nestedUserTransaction) conglom should have been aborted.");
            }
            catch (StandardException standardException2) {
                tc.commit();
                orig_conglomid = tc.createConglomerate("heap", big_row.getRowArray(), null, null, null, 0);
                tc.commit();
                child_tc = tc.startNestedUserTransaction(true, true);
                cc = child_tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
                child_tc.abort();
                child_tc.destroy();
                try {
                    cc = tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
                    cc.close();
                }
                catch (StandardException se) {
                    throw T_Fail.testFailMsg("(nestedUserTransaction) conglom should have not be aborted.");
                }
                child_tc = tc.startNestedUserTransaction(true, true);
                ConglomerateController child_cc = child_tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
                try {
                    big_row.setCol(0, (DataValueDescriptor)new SQLInteger(1042));
                    child_cc.insert(big_row.getRowArray());
                    throw T_Fail.testFailMsg("(nestedUserTransaction) read only xact does not allow upd.");
                }
                catch (StandardException se) {
                    child_tc.commit();
                    child_tc.destroy();
                    tc.commit();
                    child_tc = tc.startNestedUserTransaction(false, true);
                    child_cc = child_tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
                    try {
                        big_row.setCol(0, (DataValueDescriptor)new SQLInteger(1043));
                        child_cc.insert(big_row.getRowArray());
                    }
                    catch (StandardException se2) {
                        throw T_Fail.testFailMsg("(nestedUserTransaction) read only xact does not allow upd.");
                    }
                    child_tc.commit();
                    child_tc.destroy();
                    tc.commit();
                    cc = tc.openConglomerate(orig_conglomid, false, 4, 7, 5);
                    child_tc = tc.startNestedUserTransaction(false, true);
                    try {
                        child_cc = child_tc.openConglomerate(orig_conglomid, false, 4, 6, 5);
                        throw T_Fail.testFailMsg("(nestedUserTransaction) lock should have timed out.");
                    }
                    catch (StandardException standardException3) {
                        child_tc.commit();
                        child_tc.destroy();
                        tc.commit();
                        this.REPORT("(nestedUserTransaction) finishing");
                        return true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean commitTest(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(commitTest)");
        T_AccessRow template_row = new T_AccessRow(1);
        long conglomid = tc.createConglomerate("heap", template_row.getRowArray(), null, null, null, 0);
        tc.commit();
        ConglomerateController cc = tc.openConglomerate(conglomid, false, 4, 6, 5);
        T_AccessRow r1 = new T_AccessRow(1);
        SQLInteger c1 = new SQLInteger(0);
        r1.setCol(0, (DataValueDescriptor)c1);
        RowLocation rowloc = cc.newRowLocationTemplate();
        cc.insertAndFetchLocation(r1.getRowArray(), rowloc);
        tc.commitNoSync(2);
        try {
            cc.newRowLocationTemplate();
            throw T_Fail.testFailMsg("conglomerate controller is not closed after commit");
        }
        catch (StandardException standardException) {
            ContextManager cm2 = T_AccessFactory.getContextService().newContextManager();
            T_AccessFactory.getContextService().setCurrentContextManager(cm2);
            TransactionController tc2 = null;
            ConglomerateController cc2 = null;
            try {
                try {
                    tc2 = this.store.getTransaction(cm2);
                    cc2 = tc2.openConglomerate(conglomid, false, 4, 6, 5);
                    cc2.delete(rowloc);
                    throw T_Fail.testFailMsg("expected time out did not happen");
                }
                catch (StandardException lfe) {
                    if (!lfe.getMessageId().equals("40XL1")) {
                        throw lfe;
                    }
                    T_AccessFactory.getContextService().resetCurrentContextManager(cm2);
                }
            }
            catch (Throwable throwable) {
                T_AccessFactory.getContextService().resetCurrentContextManager(cm2);
                throw throwable;
            }
            if (tc.anyoneBlocked()) {
                throw T_Fail.testFailMsg("No transactions should be blocked");
            }
            tc.commit();
            T_AccessFactory.getContextService().setCurrentContextManager(cm2);
            try {
                cc2.fetch(rowloc, r1.getRowArray(), (FormatableBitSet)null);
                tc2.commitNoSync(1);
                tc2.destroy();
            }
            finally {
                T_AccessFactory.getContextService().resetCurrentContextManager(cm2);
            }
            this.REPORT("(commitTest) succeeded");
            return true;
        }
    }

    private void testOpsBeforeFirstNext(ScanController scan, DataValueDescriptor[] row) throws StandardException, T_Fail {
        try {
            scan.delete();
            throw T_Fail.testFailMsg("(holdCursor) delete() does not work until next() is called.");
        }
        catch (StandardException standardException) {
            try {
                scan.doesCurrentPositionQualify();
                throw T_Fail.testFailMsg("(holdCursor) doesCurrentPositionQualify() does not work until next() is called.");
            }
            catch (StandardException standardException2) {
                try {
                    scan.fetch(row);
                    throw T_Fail.testFailMsg("(holdCursor) fetch() does not work until next() is called.");
                }
                catch (StandardException standardException3) {
                    try {
                        scan.fetchLocation(null);
                        throw T_Fail.testFailMsg("(holdCursor) fetchLocation() does not work until next() is called.");
                    }
                    catch (StandardException standardException4) {
                        try {
                            scan.isCurrentPositionDeleted();
                            throw T_Fail.testFailMsg("(holdCursor) isCurrentPositionDeleted() does not work until next() is called.");
                        }
                        catch (StandardException standardException5) {
                            try {
                                scan.replace(row, null);
                                throw T_Fail.testFailMsg("(holdCursor) isCurrentPositionDeleted() does not work until next() is called.");
                            }
                            catch (StandardException standardException6) {
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    protected boolean holdCursor(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(holdCursor)");
        long base_id = this.createAConglom(tc, 0, false);
        ConglomerateController cc = tc.openConglomerate(base_id, false, 4, 6, 5);
        T_AccessRow r1 = null;
        SQLLongint c1 = null;
        for (int i = 1; i < 5; ++i) {
            r1 = new T_AccessRow(1);
            c1 = new SQLLongint((long)i);
            r1.setCol(0, (DataValueDescriptor)c1);
            RowLocation rowloc = cc.newRowLocationTemplate();
            cc.insertAndFetchLocation(r1.getRowArray(), rowloc);
        }
        long index_id = this.createBtree(tc, base_id, false);
        tc.commit();
        cc.close();
        tc.commit();
        ScanController base_scan = tc.openScan(base_id, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        ScanController index_scan = tc.openScan(index_id, false, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        this.testOpsBeforeFirstNext(base_scan, r1.getRowArray());
        this.testOpsBeforeFirstNext(index_scan, r1.getRowArray());
        base_scan.next();
        index_scan.next();
        base_scan.next();
        index_scan.next();
        base_scan.next();
        index_scan.next();
        base_scan.next();
        index_scan.next();
        base_scan.next();
        index_scan.next();
        base_scan.next();
        index_scan.next();
        base_scan.next();
        index_scan.next();
        long row_count = base_scan.getEstimatedRowCount();
        base_scan.setEstimatedRowCount(10L);
        row_count = base_scan.getEstimatedRowCount();
        row_count = index_scan.getEstimatedRowCount();
        index_scan.setEstimatedRowCount(10L);
        row_count = index_scan.getEstimatedRowCount();
        if (row_count != 10L) {
            throw T_Fail.testFailMsg("(holdCursor) some problem with get/set row count.");
        }
        tc.commit();
        this.testOpsBeforeFirstNext(base_scan, r1.getRowArray());
        this.testOpsBeforeFirstNext(index_scan, r1.getRowArray());
        if (base_scan.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should return false, commit should close base_scan.");
        }
        if (index_scan.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should return false, commit should close base_scan.");
        }
        tc.commit();
        base_scan = tc.openScan(base_id, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        index_scan = tc.openScan(index_id, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        tc.commit();
        this.testOpsBeforeFirstNext(base_scan, r1.getRowArray());
        this.testOpsBeforeFirstNext(index_scan, r1.getRowArray());
        if (!base_scan.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should not fail, commit should close hold scan.");
        }
        if (!index_scan.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should not fail, commit should close hold scan.");
        }
        base_scan.fetch(r1.getRowArray());
        long key_value = ((SQLLongint)r1.getCol(0)).getLong();
        if (key_value != 0L) {
            throw T_Fail.testFailMsg("(holdCursor) 1st row is not 0.");
        }
        index_scan.fetch(r1.getRowArray());
        key_value = ((SQLLongint)r1.getCol(0)).getLong();
        if (key_value != 0L) {
            throw T_Fail.testFailMsg("(holdCursor) 1st row is not 0.");
        }
        base_scan.next();
        index_scan.next();
        tc.commit();
        this.testOpsBeforeFirstNext(base_scan, r1.getRowArray());
        this.testOpsBeforeFirstNext(index_scan, r1.getRowArray());
        row_count = base_scan.getEstimatedRowCount();
        base_scan.setEstimatedRowCount(5L);
        row_count = base_scan.getEstimatedRowCount();
        row_count = index_scan.getEstimatedRowCount();
        index_scan.setEstimatedRowCount(5L);
        row_count = index_scan.getEstimatedRowCount();
        if (row_count != 5L) {
            throw T_Fail.testFailMsg("(holdCursor) some problem with get/set row count.");
        }
        if (!base_scan.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should not fail, commit should close hold base_scan.");
        }
        if (!index_scan.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should not fail, commit should close hold base_scan.");
        }
        base_scan.fetch(r1.getRowArray());
        key_value = ((SQLLongint)r1.getCol(0)).getLong();
        if (key_value != 2L) {
            throw T_Fail.testFailMsg("(holdCursor) 1st row is not 0.");
        }
        index_scan.fetch(r1.getRowArray());
        key_value = ((SQLLongint)r1.getCol(0)).getLong();
        if (key_value != 2L) {
            throw T_Fail.testFailMsg("(holdCursor) 1st row is not 0.");
        }
        base_scan.next();
        base_scan.delete();
        index_scan.next();
        index_scan.delete();
        base_scan.next();
        index_scan.next();
        base_scan.next();
        index_scan.next();
        tc.commit();
        row_count = base_scan.getEstimatedRowCount();
        base_scan.setEstimatedRowCount(15L);
        row_count = base_scan.getEstimatedRowCount();
        if (row_count != 15L) {
            throw T_Fail.testFailMsg("(holdCursor) some problem with get/set row count.");
        }
        row_count = index_scan.getEstimatedRowCount();
        index_scan.setEstimatedRowCount(15L);
        row_count = index_scan.getEstimatedRowCount();
        if (row_count != 15L) {
            throw T_Fail.testFailMsg("(holdCursor) some problem with get/set row count.");
        }
        this.testOpsBeforeFirstNext(base_scan, r1.getRowArray());
        this.testOpsBeforeFirstNext(index_scan, r1.getRowArray());
        if (base_scan.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should fail, the base_scan has been closed by progressing to end.");
        }
        if (index_scan.next()) {
            throw T_Fail.testFailMsg("(holdCursor) next() should fail, the base_scan has been closed by progressing to end.");
        }
        tc.commit();
        base_scan.close();
        index_scan.close();
        this.REPORT("(holdCursor) succeeded");
        return true;
    }

    protected boolean positionAtRowLocation(TransactionController tc) throws StandardException, T_Fail {
        this.REPORT("(positionAtRowLocation)");
        long base_id = this.createAConglom(tc, 0, false);
        ConglomerateController cc = tc.openConglomerate(base_id, false, 4, 6, 5);
        T_AccessRow accessRow = null;
        for (int i = 1; i < 5; ++i) {
            accessRow = new T_AccessRow(1);
            SQLLongint c1 = new SQLLongint((long)i);
            accessRow.setCol(0, (DataValueDescriptor)c1);
            cc.insert(accessRow.getRowArray());
        }
        tc.commit();
        cc.close();
        ScanController base_scan = tc.openScan(base_id, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        base_scan.next();
        RowLocation firstRow = base_scan.newRowLocationTemplate();
        base_scan.fetchLocation(firstRow);
        base_scan.fetch(accessRow.getRowArray());
        long key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 0L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_1) 1st row is not 0 it is:" + key_value);
        }
        base_scan.next();
        base_scan.fetch(accessRow.getRowArray());
        key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 1L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_2) 2nd row is not 1 it is:" + key_value);
        }
        base_scan.next();
        base_scan.fetch(accessRow.getRowArray());
        key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 2L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_3) 3d row is not 2 it is:" + key_value);
        }
        if (!base_scan.positionAtRowLocation(firstRow)) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_4) Failed to position at RowLocation");
        }
        base_scan.fetch(accessRow.getRowArray());
        key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 0L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_5) 1st row is not 0 it is:" + key_value);
        }
        tc.commit();
        base_scan.next();
        base_scan.fetch(accessRow.getRowArray());
        key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 1L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_6) 2nd row is not 1 it is:" + key_value);
        }
        base_scan.next();
        base_scan.fetch(accessRow.getRowArray());
        key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 2L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_7) 3d row is not 2 it is:" + key_value);
        }
        if (!base_scan.positionAtRowLocation(firstRow)) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_8) Failed to position at RowLocation after commit");
        }
        base_scan.fetch(accessRow.getRowArray());
        key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 0L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_9) 1st row is not 0 it is:" + key_value);
        }
        base_scan.next();
        base_scan.fetch(accessRow.getRowArray());
        key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 1L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_10) 2nd row is not 1 it is:" + key_value);
        }
        base_scan.next();
        base_scan.fetch(accessRow.getRowArray());
        key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 2L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_10) 3d row is not 2 it is:" + key_value);
        }
        base_scan.reopenScanByRowLocation(firstRow, null);
        base_scan.next();
        base_scan.fetch(accessRow.getRowArray());
        key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 0L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_11) 1st row is not 0 it is:" + key_value);
        }
        tc.commit();
        tc.compressConglomerate(base_id);
        tc.commit();
        base_scan.next();
        base_scan.fetch(accessRow.getRowArray());
        key_value = ((SQLLongint)accessRow.getCol(0)).getLong();
        if (key_value != 1L) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_12) 2nd row is not 1 it is:" + key_value);
        }
        if (base_scan.positionAtRowLocation(firstRow)) {
            throw T_Fail.testFailMsg("(positionAtRowLocation_err_12) Unexpectedly succeeded at positioning at RowLocation after compress");
        }
        base_scan.close();
        this.REPORT("(positionAtRowLocation) succeeded");
        return true;
    }

    protected boolean readUncommitted(TransactionController tc) throws StandardException, T_Fail {
        int i;
        this.REPORT("(readUncommitted)");
        Object twok_string = new String("0123456789012345");
        for (int i2 = 0; i2 < 7; ++i2) {
            twok_string = (String)twok_string + (String)twok_string;
        }
        T_AccessRow big_row = new T_AccessRow(2);
        big_row.setCol(1, (DataValueDescriptor)new SQLChar((String)twok_string));
        long orig_conglomid = tc.createConglomerate("heap", big_row.getRowArray(), null, null, null, 0);
        ConglomerateController cc = tc.openConglomerate(orig_conglomid, false, 4, 6, 1);
        for (int i3 = 0; i3 < 10; ++i3) {
            big_row.setCol(0, (DataValueDescriptor)new SQLInteger(i3));
            cc.insert(big_row.getRowArray());
        }
        cc.close();
        ScanController base_scan = tc.openScan(orig_conglomid, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        RowLocation deleted_page_rowloc = base_scan.newRowLocationTemplate();
        for (int i4 = 0; i4 < 10; ++i4) {
            base_scan.next();
            base_scan.fetchLocation(deleted_page_rowloc);
            base_scan.delete();
            tc.commit();
        }
        base_scan.close();
        tc.commit();
        cc = tc.openConglomerate(orig_conglomid, false, 0, 6, 1);
        if (cc.fetch(deleted_page_rowloc, big_row.getRowArray(), null)) {
            throw T_Fail.testFailMsg("(readUncommitted) fetch should ret false for reclaimed page.");
        }
        FormatableBitSet update_desc = new FormatableBitSet(1);
        if (cc.replace(deleted_page_rowloc, big_row.getRowArray(), update_desc)) {
            throw T_Fail.testFailMsg("(readUncommitted) delete should ret false for reclaimed page.");
        }
        if (cc.fetch(deleted_page_rowloc, big_row.getRowArray(), null, true)) {
            throw T_Fail.testFailMsg("(readUncommitted) fetch should ret false for reclaimed page.");
        }
        if (cc.delete(deleted_page_rowloc)) {
            throw T_Fail.testFailMsg("(readUncommitted) delete should ret false for reclaimed page.");
        }
        cc.close();
        SQLChar stringcol = new SQLChar();
        stringcol.setValue(T_AccessFactory.repeatString("012345678901234", 100));
        big_row.setCol(1, (DataValueDescriptor)stringcol);
        orig_conglomid = tc.createConglomerate("heap", big_row.getRowArray(), null, null, null, 0);
        cc = tc.openConglomerate(orig_conglomid, false, 4, 6, 1);
        for (int i5 = 0; i5 < 3; ++i5) {
            big_row.setCol(0, (DataValueDescriptor)new SQLInteger(i5));
            cc.insert(big_row.getRowArray());
        }
        base_scan = tc.openScan(orig_conglomid, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        RowLocation deleted_row_rowloc = base_scan.newRowLocationTemplate();
        for (i = 0; i < 3; ++i) {
            base_scan.next();
            base_scan.fetchLocation(deleted_row_rowloc);
            base_scan.delete();
        }
        cc.insert(big_row.getRowArray());
        cc.close();
        base_scan.close();
        tc.commit();
        cc = tc.openConglomerate(orig_conglomid, false, 0, 6, 1);
        if (cc.fetch(deleted_row_rowloc, big_row.getRowArray(), null)) {
            throw T_Fail.testFailMsg("(readUncommitted) fetch should ret false for reclaimed row.");
        }
        if (cc.replace(deleted_page_rowloc, big_row.getRowArray(), update_desc)) {
            throw T_Fail.testFailMsg("(readUncommitted) delete should ret false for reclaimed page.");
        }
        if (cc.fetch(deleted_page_rowloc, big_row.getRowArray(), null, true)) {
            throw T_Fail.testFailMsg("(readUncommitted) fetch should ret false for reclaimed page.");
        }
        if (cc.delete(deleted_page_rowloc)) {
            throw T_Fail.testFailMsg("(readUncommitted) delete should ret false for reclaimed page.");
        }
        cc.close();
        big_row = new T_AccessRow(2);
        big_row.setCol(1, (DataValueDescriptor)new SQLChar((String)twok_string));
        orig_conglomid = tc.createConglomerate("heap", big_row.getRowArray(), null, null, null, 0);
        cc = tc.openConglomerate(orig_conglomid, false, 4, 6, 1);
        for (i = 0; i < 10; ++i) {
            big_row.setCol(0, (DataValueDescriptor)new SQLInteger(i));
            cc.insert(big_row.getRowArray());
        }
        cc.close();
        base_scan = tc.openScan(orig_conglomid, true, 0, 6, 1, (FormatableBitSet)null, null, 0, null, null, 0);
        base_scan.next();
        base_scan.next();
        base_scan.next();
        if (!base_scan.doesCurrentPositionQualify()) {
            throw T_Fail.testFailMsg("(readUncommitted) doesCurrentPositionQualify() failed.");
        }
        base_scan.fetch(big_row.getRowArray());
        base_scan.fetchLocation(deleted_row_rowloc);
        if (base_scan.isCurrentPositionDeleted()) {
            throw T_Fail.testFailMsg("(readUncommitted) isCurrentPositionDeleted() failed.");
        }
        ScanController delete_scan = tc.openScan(orig_conglomid, true, 4, 6, 5, (FormatableBitSet)null, null, 0, null, null, 0);
        for (int i6 = 0; i6 < 10; ++i6) {
            delete_scan.next();
            delete_scan.fetchLocation(deleted_page_rowloc);
            delete_scan.delete();
        }
        delete_scan.close();
        if (base_scan.doesCurrentPositionQualify()) {
            throw T_Fail.testFailMsg("(readUncommitted) doesCurrentPositionQualify() failed.");
        }
        try {
            base_scan.fetch(big_row.getRowArray());
            throw T_Fail.testFailMsg("(readUncommitted) fetch of deleted row should throw exception.");
        }
        catch (StandardException se) {
            if (!se.getMessageId().equals("XSAM6.S")) {
                throw T_Fail.testFailMsg("(readUncommitted) fetch of deleted row should throw SQLState.AM_RECORD_NOT_FOUND.");
            }
            base_scan.fetchLocation(deleted_row_rowloc);
            if (!base_scan.isCurrentPositionDeleted()) {
                throw T_Fail.testFailMsg("(readUncommitted) isCurrentPositionDeleted() failed.");
            }
            base_scan.close();
            tc.commit();
            this.REPORT("(readUncommitted) succeeded");
            return true;
        }
    }

    public static String repeatString(String data, int repeat) {
        Object s = data;
        for (int i = 1; i < repeat; ++i) {
            s = (String)s + data;
        }
        return s;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Object findServiceModule(Object serviceModule, String factoryInterface) throws StandardException {
        return Monitor.findServiceModule((Object)serviceModule, (String)factoryInterface);
    }

    private static Object createPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)factoryInterface, (String)serviceName, (Properties)properties);
    }
}

