/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class RenameNode
extends DDLStatementNode {
    protected TableName newTableName;
    protected String oldObjectName;
    protected String newObjectName;
    protected TableDescriptor td;
    private long conglomerateNumber;
    protected boolean usedAlterTable;
    protected int renamingWhat;

    RenameNode(Object tableName, String oldObjectName, String newObjectName, boolean usedAlterTable, int renamingWhat, ContextManager cm) throws StandardException {
        super(cm);
        this.usedAlterTable = usedAlterTable;
        this.renamingWhat = renamingWhat;
        switch (this.renamingWhat) {
            case 1: {
                this.initAndCheck((TableName)tableName);
                this.newTableName = this.makeTableName(this.getObjectName().getSchemaName(), newObjectName);
                this.oldObjectName = null;
                this.newObjectName = this.newTableName.getTableName();
                break;
            }
            case 2: {
                TableName actingObjectName = tableName instanceof TableName ? (TableName)tableName : this.makeTableName(null, (String)tableName);
                this.initAndCheck(actingObjectName);
                this.oldObjectName = oldObjectName;
                this.newObjectName = newObjectName;
                break;
            }
            case 3: {
                this.oldObjectName = oldObjectName;
                this.newObjectName = newObjectName;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected rename action in RenameNode");
            }
        }
    }

    @Override
    public String toString() {
        switch (this.renamingWhat) {
            case 1: {
                return super.toString() + "oldTableName: \n" + this.getRelativeName() + "\nnewTableName: \n" + String.valueOf(this.newTableName) + "\n";
            }
            case 2: {
                return super.toString() + "oldTableName.oldColumnName:\n" + this.getRelativeName() + "." + this.oldObjectName + "\nnewColumnName: \n" + this.newObjectName + "\n";
            }
            case 3: {
                return super.toString() + "oldIndexName:\n" + this.oldObjectName + "\nnewIndexName: \n" + this.newObjectName + "\n";
            }
        }
        SanityManager.THROWASSERT("Unexpected rename action in RenameNode");
        return "UNKNOWN";
    }

    @Override
    String statementToString() {
        if (this.usedAlterTable) {
            return "ALTER TABLE";
        }
        switch (this.renamingWhat) {
            case 1: {
                return "RENAME TABLE";
            }
            case 2: {
                return "RENAME COLUMN";
            }
            case 3: {
                return "RENAME INDEX";
            }
        }
        SanityManager.THROWASSERT("Unexpected rename action in RenameNode");
        return "UNKNOWN";
    }

    @Override
    public void bindStatement() throws StandardException {
        SchemaDescriptor sd;
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        if (this.renamingWhat == 3) {
            sd = this.getSchemaDescriptor(null);
            ConglomerateDescriptor indexDescriptor = dd.getConglomerateDescriptor(this.oldObjectName, sd, false);
            if (indexDescriptor == null) {
                throw StandardException.newException("42X65", this.oldObjectName);
            }
            this.td = dd.getTableDescriptor(indexDescriptor.getTableID());
            this.initAndCheck(this.makeTableName(this.td.getSchemaName(), this.td.getName()));
        } else {
            sd = this.getSchemaDescriptor();
        }
        this.td = this.getTableDescriptor();
        if (this.td.getTableType() == 3) {
            throw StandardException.newException("42995", new Object[0]);
        }
        switch (this.renamingWhat) {
            case 1: {
                TableDescriptor tabDesc = this.getTableDescriptor(this.newObjectName, sd);
                if (tabDesc != null) {
                    throw this.descriptorExistsException(tabDesc, sd);
                }
                this.renameTableBind(dd);
                break;
            }
            case 2: {
                this.renameColumnBind(dd);
                break;
            }
            case 3: {
                ConglomerateDescriptor conglomDesc = dd.getConglomerateDescriptor(this.newObjectName, sd, false);
                if (conglomDesc == null) break;
                throw this.descriptorExistsException(conglomDesc, sd);
            }
            default: {
                SanityManager.THROWASSERT("Unexpected rename action in RenameNode");
            }
        }
        this.conglomerateNumber = this.td.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(this.conglomerateNumber);
        cc.createDependency(this.td);
        cc.createDependency(cd);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        if (RenameNode.isSessionSchema(this.td.getSchemaName())) {
            return true;
        }
        return this.renamingWhat == 1 && this.isSessionSchema(this.getSchemaDescriptor());
    }

    private void renameTableBind(DataDictionary dd) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = dd.getConstraintDescriptors(this.td);
        int size = constraintDescriptorList == null ? 0 : constraintDescriptorList.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(index);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            throw StandardException.newException("X0Y25.S", "RENAME", this.td.getName(), "CONSTRAINT", constraintDescriptor.getConstraintName());
        }
    }

    private void renameColumnBind(DataDictionary dd) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.oldObjectName);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", this.oldObjectName, this.getFullName());
        }
        ColumnDescriptor cd = this.td.getColumnDescriptor(this.newObjectName);
        if (cd != null) {
            throw this.descriptorExistsException(cd, this.td);
        }
        ColumnDescriptorList generatedColumns = this.td.getGeneratedColumns();
        int generatedColumnCount = generatedColumns.size();
        for (int i = 0; i < generatedColumnCount; ++i) {
            ColumnDescriptor gc = generatedColumns.elementAt(i);
            for (String refName : gc.getDefaultInfo().getReferencedColumnNames()) {
                if (!this.oldObjectName.equals(refName)) continue;
                throw StandardException.newException("42XA8", this.oldObjectName, gc.getColumnName());
            }
        }
        ConstraintDescriptorList constraintDescriptorList = dd.getConstraintDescriptors(this.td);
        int size = constraintDescriptorList == null ? 0 : constraintDescriptorList.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(index);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            ColumnDescriptorList checkConstraintCDL = constraintDescriptor.getColumnDescriptors();
            int checkConstraintCDLSize = checkConstraintCDL.size();
            for (int index2 = 0; index2 < checkConstraintCDLSize; ++index2) {
                if (checkConstraintCDL.elementAt(index2) != columnDescriptor) continue;
                throw StandardException.newException("42Z97", this.oldObjectName, constraintDescriptor.getConstraintName());
            }
        }
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getRenameConstantAction(this.getFullName(), this.getRelativeName(), this.oldObjectName, this.newObjectName, this.getSchemaDescriptor(), this.td.getUUID(), this.usedAlterTable, this.renamingWhat);
    }

    private StandardException descriptorExistsException(TupleDescriptor tuple, TupleDescriptor parent) {
        return StandardException.newException("X0Y32.S", tuple.getDescriptorType(), tuple.getDescriptorName(), parent.getDescriptorType(), parent.getDescriptorName());
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.newTableName != null) {
            this.newTableName = (TableName)this.newTableName.accept(v);
        }
    }
}

