/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpdateLocksTest
extends BaseJDBCTestCase {
    private static final int UNIQUE_INDEX = 0;
    private static final int NON_UNIQUE_INDEX = 1;
    private static final int NO_IDX_1 = 2;
    private static final int NO_IDX_2 = 3;
    private static final String _g = "GRANT";
    private static final String _a = "ACTIVE";
    private static final String _app = "APP";
    private static final String _ut = "UserTran";
    private static final String _t = "TABLE";
    private static final String _r = "ROW";
    private static final String _tl = "Tablelock";
    private static final String _A = "A";
    private static final String _X = "X";
    private static final String _IX = "IX";
    private static final String _U = "U";
    private PreparedStatement getLocksQuery;
    private static final String lock_table_query = "select * from lock_table order by     tabname, type desc, mode, cnt, lockname";

    public UpdateLocksTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("create function PADSTRING (data varchar(32000),                            length integer)     returns varchar(32000)     external name     'org.apache.derbyTesting.functionTests.util.Formatters.padString'     language java parameter style java");
            statement.executeUpdate("create view LOCK_TABLE as select      cast(username as char(8)) as username,     cast(t.type as char(8)) as trantype,     cast(l.type as char(8)) as type,     cast(lockcount as char(3)) as cnt,     mode,     cast(tablename as char(12)) as tabname,     cast(lockname as char(10)) as lockname,     state,     status from      syscs_diag.lock_table l  right outer join     syscs_diag.transaction_table t on l.xid = t.xid where l.tableType <> 'S' and       t.type='UserTransaction'");
            statement.execute("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
            this.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.getLocksQuery = this.prepareStatement(lock_table_query);
    }

    @Override
    public void tearDown() throws Exception {
        this.getLocksQuery = null;
        try {
            this.dropTable("a");
            this.commit();
        }
        catch (SQLException sQLException) {
            UpdateLocksTest.assertSQLState("42Y55", sQLException);
        }
        super.tearDown();
    }

    public static Test suite() {
        Test test = TestConfiguration.defaultSuite(UpdateLocksTest.class);
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "4096");
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup(test, properties, false));
    }

    public void testRepeatableRead() throws Exception {
        this.doRunTests(4, false);
    }

    public void testReadCommitted() throws Exception {
        this.doRunTests(2, false);
    }

    public void testSerializable() throws Exception {
        this.doRunTests(8, false);
    }

    public void testReadUncommitted() throws Exception {
        this.doRunTests(1, false);
    }

    public void testRepeatableReadJDBC30() throws Exception {
        this.doRunTests(4, true);
    }

    public void testReadCommittedJDBC30() throws Exception {
        this.doRunTests(2, true);
    }

    public void testSerializableJDBC30() throws Exception {
        this.doRunTests(8, true);
    }

    public void testReadUncommittedJDBC30() throws Exception {
        this.doRunTests(1, true);
    }

    private void insertValuesUnpaddedVarchar(Statement statement) throws SQLException {
        statement.executeUpdate("insert into a values (1, 10, 'one')");
        statement.executeUpdate("insert into a values (2, 20, 'two')");
        statement.executeUpdate("insert into a values (3, 30, 'three')");
        statement.executeUpdate("insert into a values (4, 40, 'four')");
        statement.executeUpdate("insert into a values (5, 50, 'five')");
        statement.executeUpdate("insert into a values (6, 60, 'six')");
        statement.executeUpdate("insert into a values (7, 70, 'seven')");
    }

    private void doRunTests(int n, boolean bl) throws Exception {
        this.setAutoCommit(false);
        this.getConnection().setTransactionIsolation(n);
        this.commit();
        Statement statement = this.createStatement();
        statement.executeUpdate("create table a(a int, b int)");
        statement.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(statement);
        this.commit();
        this.updatecursorlocks(this.getConnection(), n, 0, 2, bl);
        statement.executeUpdate("create table a(a int, b int)");
        statement.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(statement);
        this.commit();
        this.updatesetlocks(this.getConnection(), n, 0, 2);
        statement.executeUpdate("create table a(a int, b int)");
        statement.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(statement);
        statement.executeUpdate("create unique index a_idx on a (a)");
        this.commit();
        this.updateBtreeCursorLocks1(this.getConnection(), n, 0, true, 0, 0, bl);
        this.updateBtreeCursorLocks2(this.getConnection(), n, 0, true, 0, 0, bl);
        statement.executeUpdate("create table a(a int, b int)");
        statement.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(statement);
        statement.executeUpdate("create index a_idx on a (a)");
        this.commit();
        this.updateBtreeCursorLocks1(this.getConnection(), n, 1, true, 0, 0, bl);
        this.updateBtreeCursorLocks2(this.getConnection(), n, 1, true, 0, 0, bl);
        statement.executeUpdate("create table a(a int, b int)");
        statement.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(statement);
        statement.executeUpdate("create unique index a_idx on a (a)");
        this.commit();
        this.updateBtreeSetLocks(this.getConnection(), n, 0, true, 0, 0);
        statement.executeUpdate("create table a(a int, b int)");
        statement.executeUpdate("alter table a add column c varchar(1900)");
        this.insertValuesUnpaddedVarchar(statement);
        statement.executeUpdate("create index a_idx on a (a)");
        this.commit();
        this.updateBtreeSetLocks(this.getConnection(), n, 1, true, 0, 0);
        statement.executeUpdate("create table a (a int, b int, c varchar(1900))");
        statement.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900))");
        statement.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900))");
        statement.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900))");
        statement.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900))");
        statement.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900))");
        statement.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900))");
        statement.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900))");
        this.commit();
        this.updatecursorlocks(this.getConnection(), n, 1900, 3, bl);
        statement.executeUpdate("create table a (a int, b int, c varchar(1900))");
        statement.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900))");
        statement.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900))");
        statement.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900))");
        statement.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900))");
        statement.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900))");
        statement.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900))");
        statement.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900))");
        this.commit();
        this.updatesetlocks(this.getConnection(), n, 1900, 3);
        statement.executeUpdate("create table a (a int, b int, c varchar(1900),    index_pad varchar(600) )");
        statement.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900),     PADSTRING('index pad 1',600))");
        statement.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900),     PADSTRING('index pad 2',600))");
        statement.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900),     PADSTRING('index pad 3',600))");
        statement.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900),     PADSTRING('index pad 4',600))");
        statement.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900),     PADSTRING('index pad 5',600))");
        statement.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900),     PADSTRING('index pad 6',600))");
        statement.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900),     PADSTRING('index pad 7',600))");
        statement.executeUpdate("create unique index a_idx on a (a, index_pad)");
        this.commit();
        this.updateBtreeCursorLocks1(this.getConnection(), n, 0, false, 1900, 600, bl);
        this.updateBtreeCursorLocks2(this.getConnection(), n, 0, false, 1900, 600, bl);
        statement.executeUpdate("create table a (a int, b int, c varchar(1900),    index_pad varchar(700) )");
        statement.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900),     PADSTRING('index pad 1',700))");
        statement.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900),     PADSTRING('index pad 2',700))");
        statement.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900),     PADSTRING('index pad 3',700))");
        statement.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900),     PADSTRING('index pad 4',700))");
        statement.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900),     PADSTRING('index pad 5',700))");
        statement.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900),     PADSTRING('index pad 6',700))");
        statement.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900),     PADSTRING('index pad 7',700))");
        statement.executeUpdate("create index a_idx on a (a, index_pad)");
        this.commit();
        this.updateBtreeCursorLocks1(this.getConnection(), n, 1, false, 1900, 700, bl);
        this.updateBtreeCursorLocks2(this.getConnection(), n, 1, false, 1900, 700, bl);
        statement.executeUpdate("create table a (a int, b int, c varchar(1900),    index_pad varchar(800) )");
        statement.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900),     PADSTRING('index pad 1',800))");
        statement.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900),     PADSTRING('index pad 2',800))");
        statement.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900),     PADSTRING('index pad 3',800))");
        statement.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900),     PADSTRING('index pad 4',800))");
        statement.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900),     PADSTRING('index pad 5',800))");
        statement.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900),     PADSTRING('index pad 6',800))");
        statement.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900),     PADSTRING('index pad 7',800))");
        statement.executeUpdate("create unique index a_idx on a (a, index_pad)");
        this.commit();
        this.updateBtreeSetLocks(this.getConnection(), n, 0, false, 1900, 800);
        statement.executeUpdate("create table a (a int, b int, c varchar(1900),     index_pad varchar(900) )");
        statement.executeUpdate("insert into a values (1, 10,     PADSTRING('one',1900),     PADSTRING('index pad 1',900))");
        statement.executeUpdate("insert into a values (2, 20,     PADSTRING('two',1900),     PADSTRING('index pad 2',900))");
        statement.executeUpdate("insert into a values (3, 30,     PADSTRING('three',1900),     PADSTRING('index pad 3',900))");
        statement.executeUpdate("insert into a values (4, 40,     PADSTRING('four',1900),     PADSTRING('index pad 4',900))");
        statement.executeUpdate("insert into a values (5, 50,     PADSTRING('five',1900),     PADSTRING('index pad 5',900))");
        statement.executeUpdate("insert into a values (6, 60,     PADSTRING('six',1900),     PADSTRING('index pad 6',900))");
        statement.executeUpdate("insert into a values (7, 70,     PADSTRING('seven',1900),     PADSTRING('index pad 7',900))");
        statement.executeUpdate("create index a_idx on a (a, index_pad)");
        this.commit();
        this.updateBtreeSetLocks(this.getConnection(), n, 1, false, 1900, 900);
        this.commit();
    }

    /*
     * Opcode count of 31735 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void updatecursorlocks(Connection connection, int n, int n2, int n3, boolean bl) throws SQLException {
        String[][] stringArray;
        String[][] stringArray2;
        String[][] stringArray3;
        String[][] stringArray4;
        String[][] stringArray5;
        String[][] stringArray6;
        String[][] stringArray7;
        String[][] stringArray8;
        String[][] stringArray9;
        String[][] stringArray10;
        String[][] stringArray11;
        String[][] stringArray12;
        String[][] stringArray13;
        String[][] stringArray14;
        String[][] stringArray15;
        String[][] stringArray16;
        String[][] stringArray17;
        String[][] stringArray18;
        String[][] stringArray19;
        String[][] stringArray20;
        String[][] stringArray21;
        String[][] stringArray22;
        String[][] stringArray23;
        String[][] stringArray24;
        String[][] stringArray25;
        String[][] stringArray26;
        String[][] stringArray27;
        String[][] stringArray28;
        String[][] stringArray29;
        String[][] stringArray30;
        String[][] stringArray31;
        String[][] stringArray32;
        String[][] stringArray33;
        String[][] stringArray34;
        String[][] stringArray35;
        String[][] stringArray36;
        String[][] stringArray37;
        String[][] stringArray38;
        String[][] stringArray39;
        String[][] stringArray40;
        String[][] stringArray41;
        String[][] stringArray42;
        String[][] stringArray43;
        String[][] stringArray44;
        String[][] stringArray45;
        String[][] stringArray46;
        String[][] stringArray47;
        String[][] stringArray48;
        String[][] stringArray49;
        String[][] stringArray50;
        String[][] stringArray51;
        String[][] stringArray52;
        Statement statement = bl ? connection.createStatement(1003, 1008, 1) : connection.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select a, b, c from a for update");
        ResultSet resultSet2 = this.getLocks();
        this.verifyRsMetaData(resultSet2);
        if (n == 8) {
            String[][] stringArray53 = new String[1][];
            stringArray52 = stringArray53;
            stringArray53[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            String[][] stringArrayArray = new String[1][];
            stringArray52 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray52 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray52);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1", "10", UpdateLocksTest.pad2("one", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray54 = new String[1][];
            stringArray51 = stringArray54;
            stringArray54[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray51 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray51);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"2", "20", UpdateLocksTest.pad2("two", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray55 = new String[1][];
            stringArray50 = stringArray55;
            stringArray55[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray50 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray50 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray50);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray56 = new String[1][];
            stringArray49 = stringArray56;
            stringArray56[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray49 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray49 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray49 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray49 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray49);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"4", "40", UpdateLocksTest.pad2("four", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray57 = new String[1][];
            stringArray48 = stringArray57;
            stringArray57[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray48 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray48 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray48 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray48 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray48);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5", "50", UpdateLocksTest.pad2("five", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray58 = new String[1][];
            stringArray47 = stringArray58;
            stringArray58[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray47 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArray47 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray47 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray47 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray47);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"6", "60", UpdateLocksTest.pad2("six", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray59 = new String[1][];
            stringArray46 = stringArray59;
            stringArray59[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray46 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray46 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray46 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray46 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray46);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"7", "70", UpdateLocksTest.pad2("seven", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray60 = new String[1][];
            stringArray45 = stringArray60;
            stringArray60[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray45 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArray45 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray45 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray45 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray45);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray61 = new String[1][];
            stringArray44 = stringArray61;
            stringArray61[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray44 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArray44 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray44 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray44);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray62 = new String[1][];
            stringArray43 = stringArray62;
            stringArray62[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray43 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArray43 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray43 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray43);
        this.commit();
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        resultSet = statement.executeQuery("select a, b, c from a for update");
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray63 = new String[1][];
            stringArray42 = stringArray63;
            stringArray63[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray42 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray42);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1", "10", UpdateLocksTest.pad2("one", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray64 = new String[1][];
            stringArray41 = stringArray64;
            stringArray64[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray41 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray41);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"2", "20", UpdateLocksTest.pad2(UpdateLocksTest.pad2("two", n2), n2)});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray65 = new String[2][];
            stringArray65[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray40 = stringArray65;
            stringArray65[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            stringArray40 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            stringArray40 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray40);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray66 = new String[2][];
            stringArray66[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray39 = stringArray66;
            stringArray66[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray39 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray39 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray39 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            stringArray39 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray39);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"4", "40", UpdateLocksTest.pad2("four", n2)});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray67 = new String[2][];
            stringArray67[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray38 = stringArray67;
            stringArray67[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArray38 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArray38 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray38 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArray38 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray38);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5", "50", UpdateLocksTest.pad2("five", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray68 = new String[2][];
            stringArray68[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray37 = stringArray68;
            stringArray68[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArray37 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArray37 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray37 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            stringArray37 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray37);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"6", "60", UpdateLocksTest.pad2("six", n2)});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray69 = new String[2][];
            stringArray69[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray36 = stringArray69;
            stringArray69[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                stringArray36 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
                stringArray36 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
            stringArray36 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            stringArray36 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray36);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"7", "70", UpdateLocksTest.pad2("seven", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray70 = new String[2][];
            stringArray70[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray35 = stringArray70;
            stringArray70[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                stringArray35 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
                stringArray35 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
            stringArray35 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            stringArray35 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray35);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray71 = new String[2][];
            stringArray71[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray34 = stringArray71;
            stringArray71[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                stringArray34 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
                stringArray34 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
            stringArray34 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            stringArray34 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray34);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray72 = new String[2][];
            stringArray72[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray33 = stringArray72;
            stringArray72[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                stringArray33 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
                stringArray33 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
            stringArray33 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            stringArray33 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray33);
        this.commit();
        statement.execute("call wait_for_post_commit()");
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"1", "10", UpdateLocksTest.pad2("one", n2)}, {"3", "30", UpdateLocksTest.pad2("three", n2)}, {"5", "50", UpdateLocksTest.pad2("five", n2)}, {"7", "70", UpdateLocksTest.pad2("seven", n2)}}, false);
        this.commit();
        resultSet = statement.executeQuery("select a, b, c from a for update");
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray73 = new String[1][];
            stringArray32 = stringArray73;
            stringArray73[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray32 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray32);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1", "10", UpdateLocksTest.pad2("one", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray74 = new String[1][];
            stringArray31 = stringArray74;
            stringArray74[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray31 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray31);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray75 = new String[1][];
            stringArray30 = stringArray75;
            stringArray75[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray30 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray30 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray30);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5", "50", UpdateLocksTest.pad2("five", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray76 = new String[1][];
            stringArray29 = stringArray76;
            stringArray76[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray29 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray29 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray29);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"7", "70", UpdateLocksTest.pad2("seven", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray77 = new String[1][];
            stringArray28 = stringArray77;
            stringArray77[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray28);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray78 = new String[1][];
            stringArray27 = stringArray78;
            stringArray78[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray27 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray27);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray79 = new String[1][];
            stringArray26 = stringArray79;
            stringArray79[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray26 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray26);
        this.commit();
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"1", "10", UpdateLocksTest.pad2("one", n2)}, {"3", "30", UpdateLocksTest.pad2("three", n2)}, {"5", "50", UpdateLocksTest.pad2("five", n2)}, {"7", "70", UpdateLocksTest.pad2("seven", n2)}}, false);
        this.commit();
        resultSet = statement.executeQuery("select a, b, c from a for update");
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray80 = new String[1][];
            stringArray25 = stringArray80;
            stringArray80[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray25 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray25);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1", "10", UpdateLocksTest.pad2("one", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray81 = new String[1][];
            stringArray24 = stringArray81;
            stringArray81[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray24 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray24);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n2)});
        resultSet.updateInt(_A, -3);
        resultSet.updateInt("B", -30);
        resultSet.updateString("C", UpdateLocksTest.pad2("-three", n2));
        resultSet.updateRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray82 = new String[2][];
            stringArray82[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray23 = stringArray82;
            stringArray82[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray23 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            stringArray23 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray23);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5", "50", UpdateLocksTest.pad2("five", n2)});
        resultSet.updateInt(_A, -5);
        resultSet.updateInt("B", -50);
        resultSet.updateString("C", UpdateLocksTest.pad2("-five", n2));
        resultSet.updateRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray83 = new String[2][];
            stringArray83[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray22 = stringArray83;
            stringArray83[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray22);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"7", "70", UpdateLocksTest.pad2("seven", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray84 = new String[2][];
            stringArray84[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray21 = stringArray84;
            stringArray84[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray21);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray85 = new String[2][];
            stringArray85[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray20 = stringArray85;
            stringArray85[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray20);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray86 = new String[2][];
            stringArray86[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray19 = stringArray86;
            stringArray86[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray19);
        this.commit();
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"1", "10", UpdateLocksTest.pad2("one", n2)}, {"-3", "-30", UpdateLocksTest.pad2("-three", n2)}, {"-5", "-50", UpdateLocksTest.pad2("-five", n2)}, {"7", "70", UpdateLocksTest.pad2("seven", n2)}}, false);
        this.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a < 0 for update");
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray87 = new String[1][];
            stringArray18 = stringArray87;
            stringArray87[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray18 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray18);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"-3", "-30", UpdateLocksTest.pad2("-three", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray88 = new String[1][];
            stringArray17 = stringArray88;
            stringArray88[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray17);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"-5", "-50", UpdateLocksTest.pad2("-five", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray89 = new String[1][];
            stringArray16 = stringArray89;
            stringArray89[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray16 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray16 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray16);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray90 = new String[1][];
            stringArray15 = stringArray90;
            stringArray90[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray15 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray15);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray91 = new String[1][];
            stringArray14 = stringArray91;
            stringArray91[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray14 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray14);
        this.commit();
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"1", "10", UpdateLocksTest.pad2("one", n2)}, {"-3", "-30", UpdateLocksTest.pad2("-three", n2)}, {"-5", "-50", UpdateLocksTest.pad2("-five", n2)}, {"7", "70", UpdateLocksTest.pad2("seven", n2)}}, false);
        this.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a > 0 for update");
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray92 = new String[1][];
            stringArray13 = stringArray92;
            stringArray92[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray13 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray13);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1", "10", UpdateLocksTest.pad2("one", n2)});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray93 = new String[2][];
            stringArray93[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray12 = stringArray93;
            stringArray93[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray12);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"7", "70", UpdateLocksTest.pad2("seven", n2)});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray94 = new String[2][];
            stringArray94[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray11 = stringArray94;
            stringArray94[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray11);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray95 = new String[2][];
            stringArray95[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray10 = stringArray95;
            stringArray95[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
            stringArray10 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArray10 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray10);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray96 = new String[2][];
            stringArray96[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray9 = stringArray96;
            stringArray96[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray9);
        this.commit();
        statement.execute("call wait_for_post_commit()");
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"-3", "-30", UpdateLocksTest.pad2("-three", n2)}, {"-5", "-50", UpdateLocksTest.pad2("-five", n2)}}, false);
        this.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a >= -5 for update");
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray97 = new String[1][];
            stringArray8 = stringArray97;
            stringArray97[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray8 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray8);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"-3", "-30", UpdateLocksTest.pad2("-three", n2)});
        resultSet.updateInt(_A, 3);
        resultSet.updateInt("B", 30);
        resultSet.updateString("C", UpdateLocksTest.pad2("three", n2));
        resultSet.updateRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray98 = new String[2][];
            stringArray98[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray7 = stringArray98;
            stringArray98[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray7);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"-5", "-50", UpdateLocksTest.pad2("-five", n2)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray99 = new String[2][];
            stringArray99[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray6 = stringArray99;
            stringArray99[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArray6 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray6 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray6);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray100 = new String[2][];
            stringArray100[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray5 = stringArray100;
            stringArray100[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray5 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray5 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray5);
        this.commit();
        JDBC.assertEmpty(this.getLocks());
        this.commit();
        resultSet = statement.executeQuery("select * from a");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"3", "30", UpdateLocksTest.pad2("three", n2)}, {"-5", "-50", UpdateLocksTest.pad2("-five", n2)}}, true);
        this.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a >= -5 for update");
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray101 = new String[1][];
            stringArray4 = stringArray101;
            stringArray101[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray4 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray4);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n2)});
        resultSet.updateInt(_A, 33);
        resultSet.updateInt("B", 3030);
        resultSet.updateString("C", "threethree");
        resultSet.updateRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray102 = new String[2][];
            stringArray102[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray3 = stringArray102;
            stringArray102[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray3);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"-5", "-50", UpdateLocksTest.pad2("-five", n2)});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray103 = new String[2][];
            stringArray103[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray2 = stringArray103;
            stringArray103[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray2);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray104 = new String[2][];
            stringArray104[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray = stringArray104;
            stringArray104[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray);
        this.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        this.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"33", "3030", "threethree"}});
        this.commit();
        statement.executeUpdate("drop table a");
        resultSet.close();
        resultSet2.close();
        statement.close();
    }

    private void updatesetlocks(Connection connection, int n, int n2, int n3) throws SQLException {
        String[][] stringArray;
        String[][] stringArray2;
        String[][] stringArray3;
        String[][] stringArray4;
        String[][] stringArray5;
        String[][] stringArray6;
        String[][] stringArray7;
        String[][] stringArray8;
        String[][] stringArray9;
        String[][] stringArray10;
        String[][] stringArray11;
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"2", "20", "two"}, {"3", "30", "three"}, {"4", "40", "four"}, {"5", "50", "five"}, {"6", "60", "six"}, {"7", "70", "seven"}});
        connection.commit();
        statement.executeUpdate("delete from a where a = -42");
        ResultSet resultSet = this.getLocks();
        if (n == 8) {
            String[][] stringArray12 = new String[1][];
            stringArray11 = stringArray12;
            stringArray12[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray11 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray11);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        statement.executeUpdate("update a set b = -b where a = -42");
        resultSet = this.getLocks();
        if (n == 8) {
            String[][] stringArray13 = new String[1][];
            stringArray10 = stringArray13;
            stringArray13[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray10 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray10);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"2", "20", "two"}, {"3", "30", "three"}, {"4", "40", "four"}, {"5", "50", "five"}, {"6", "60", "six"}, {"7", "70", "seven"}});
        connection.commit();
        statement.executeUpdate("update a set a = -a, b = -b where a = -42");
        resultSet = this.getLocks();
        if (n == 8) {
            String[][] stringArray14 = new String[1][];
            stringArray9 = stringArray14;
            stringArray14[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray9 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray9);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"2", "20", "two"}, {"3", "30", "three"}, {"4", "40", "four"}, {"5", "50", "five"}, {"6", "60", "six"}, {"7", "70", "seven"}});
        connection.commit();
        statement.executeUpdate("delete from a where a = 2 or a = 4 or a = 6");
        resultSet = this.getLocks();
        if (n == 8) {
            String[][] stringArray15 = new String[2][];
            stringArray15[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray8 = stringArray15;
            stringArray15[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,7)", _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray8);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"3", "30", "three"}, {"5", "50", "five"}, {"7", "70", "seven"}});
        connection.commit();
        statement.executeUpdate("delete from a where a = -42");
        resultSet = this.getLocks();
        if (n == 8) {
            String[][] stringArray16 = new String[1][];
            stringArray7 = stringArray16;
            stringArray16[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray7 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray7);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        statement.executeUpdate("update a set b = -b where a = -42");
        resultSet = this.getLocks();
        if (n == 8) {
            String[][] stringArray17 = new String[1][];
            stringArray6 = stringArray17;
            stringArray17[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray6 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray6);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"3", "30", "three"}, {"5", "50", "five"}, {"7", "70", "seven"}});
        connection.commit();
        statement.executeUpdate("update a set b = -b where a = 3 or a = 5");
        resultSet = this.getLocks();
        if (n == 8) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArray18 = new String[3][];
            stringArray18[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray18[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray5 = stringArray18;
            stringArray18[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray5 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray5);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"1", "10", "one"}, {"3", "-30", "three"}, {"5", "-50", "five"}, {"7", "70", "seven"}});
        connection.commit();
        statement.executeUpdate("update a set b = 4000 where a < 0");
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        statement.executeUpdate("delete from a where b > 0");
        resultSet = this.getLocks();
        if (n == 8) {
            String[][] stringArray19 = new String[1][];
            stringArray4 = stringArray19;
            stringArray19[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,13)", _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray4);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"3", "-30", "three"}, {"5", "-50", "five"}});
        connection.commit();
        statement.executeUpdate("update a set b = -b, c = 'three' where a > 2 and a < 5");
        resultSet = this.getLocks();
        if (n == 8) {
            String[][] stringArray20 = new String[1][];
            stringArray3 = stringArray20;
            stringArray20[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray3);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"3", "30", "three"}, {"5", "-50", "five"}});
        connection.commit();
        statement.executeUpdate("update a set a=33,b=3030,c='threethree' where a = 3");
        resultSet = this.getLocks();
        if (n == 8) {
            String[][] stringArray21 = new String[1][];
            stringArray2 = stringArray21;
            stringArray21[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray2);
        statement.executeUpdate("delete from a where a = 5");
        resultSet = this.getLocks();
        if (n == 8) {
            String[][] stringArray22 = new String[1][];
            stringArray = stringArray22;
            stringArray22[0] = new String[]{_app, _ut, _t, "4", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (n3 == 2) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n3 == 2) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArray = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet = this.getLocks();
        JDBC.assertEmpty(resultSet);
        connection.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from a"), new String[][]{{"33", "3030", "threethree"}});
        connection.commit();
        statement.executeUpdate("drop table a");
        resultSet.close();
        statement.close();
    }

    /*
     * Opcode count of 33904 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void updateBtreeCursorLocks1(Connection connection, int n, int n2, boolean bl, int n3, int n4, boolean bl2) throws SQLException {
        String[][] stringArray;
        String[][] stringArray2;
        String[][] stringArray3;
        String[][] stringArray4;
        String[][] stringArray5;
        String[][] stringArray6;
        Object[][] objectArray;
        String[][] stringArray7;
        String[][] stringArray8;
        String[][] stringArray9;
        String[][] stringArray10;
        String[][] stringArray11;
        String[][] stringArray12;
        String[][] stringArray13;
        String[][] stringArray14;
        String[][] stringArray15;
        String[][] stringArray16;
        String[][] stringArray17;
        String[][] stringArray18;
        String[][] stringArray19;
        String[][] stringArray20;
        String[][] stringArray21;
        String[][] stringArray22;
        String[][] stringArray23;
        String[][] stringArray24;
        String[][] stringArray25;
        String[][] stringArray26;
        String[][] stringArray27;
        String[][] stringArray28;
        String[][] stringArray29;
        String[][] stringArray30;
        String[][] stringArray31;
        String[][] stringArray32;
        String[][] stringArray33;
        Object[][] objectArray2;
        connection.setAutoCommit(false);
        Statement statement = bl2 ? connection.createStatement(1003, 1008, 1) : connection.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select a, b, c from a for update");
        ResultSet resultSet2 = this.getLocks();
        this.verifyRsMetaData(resultSet2);
        ResultSet resultSet3 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray3 = new String[7][];
            objectArray3[0] = new String[]{"1", "10", "one"};
            objectArray3[1] = new String[]{"2", "20", "two"};
            objectArray3[2] = new String[]{"3", "30", "three"};
            objectArray3[3] = new String[]{"4", "40", "four"};
            objectArray3[4] = new String[]{"5", "50", "five"};
            objectArray3[5] = new String[]{"6", "60", "six"};
            objectArray2 = objectArray3;
            objectArray3[6] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[7][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"2", "20", UpdateLocksTest.pad2("two", n3), UpdateLocksTest.pad2("index pad 2", n4)};
            stringArrayArray[2] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[3] = new String[]{"4", "40", UpdateLocksTest.pad2("four", n3), UpdateLocksTest.pad2("index pad 4", n4)};
            stringArrayArray[4] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArrayArray[5] = new String[]{"6", "60", UpdateLocksTest.pad2("six", n3), UpdateLocksTest.pad2("index pad 6", n4)};
            objectArray2 = stringArrayArray;
            stringArrayArray[6] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet3, objectArray2, false);
        connection.commit();
        resultSet = statement.executeQuery("select a, b, c from a where     a >= 1 and a < 20 for update of b, c");
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArrayArray = new String[1][];
                stringArray33 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray33 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray34 = new String[1][];
            stringArray33 = stringArray34;
            stringArray34[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray33);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1", "10", UpdateLocksTest.pad2("one", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray35 = new String[1][];
                stringArray32 = stringArray35;
                stringArray35[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArray32 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray32 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray32);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"2", "20", UpdateLocksTest.pad2("two", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray36 = new String[1][];
                stringArray31 = stringArray36;
                stringArray36[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray31 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray31 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray31);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray37 = new String[1][];
                stringArray30 = stringArray37;
                stringArray37[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray30 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray30 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray30 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray30);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"4", "40", UpdateLocksTest.pad2("four", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray38 = new String[1][];
                stringArray29 = stringArray38;
                stringArray38[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray29 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray29 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray29);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5", "50", UpdateLocksTest.pad2("five", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray39 = new String[1][];
                stringArray28 = stringArray39;
                stringArray39[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray28);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"6", "60", UpdateLocksTest.pad2("six", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray40 = new String[1][];
                stringArray27 = stringArray40;
                stringArray40[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray27 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray27 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray27);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray41 = new String[1][];
                stringArray26 = stringArray41;
                stringArray41[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray26 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray26 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray26);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray42 = new String[1][];
                stringArray25 = stringArray42;
                stringArray42[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray25 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray25 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray25 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray25 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray25);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray43 = new String[1][];
                stringArray24 = stringArray43;
                stringArray43[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray24 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray24 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray24 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray24 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray24);
        connection.commit();
        JDBC.assertEmpty(this.getLocks());
        connection.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a >= 1 and a < 20 for update of b, c");
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArrayArray = new String[1][];
                stringArray23 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray23 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray44 = new String[1][];
            stringArray23 = stringArray44;
            stringArray44[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray23);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1", "10", UpdateLocksTest.pad2("one", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray45 = new String[1][];
                stringArray22 = stringArray45;
                stringArray45[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray22);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"2", "20", UpdateLocksTest.pad2("two", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray46 = new String[1][];
                stringArray21 = stringArray46;
                stringArray46[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray21);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray47 = new String[1][];
                stringArray20 = stringArray47;
                stringArray47[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray20);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"4", "40", UpdateLocksTest.pad2("four", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray48 = new String[1][];
                stringArray19 = stringArray48;
                stringArray48[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray19);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray49 = new String[1][];
                stringArray18 = stringArray49;
                stringArray49[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray18 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray18 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray18 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray18 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray18);
        connection.commit();
        JDBC.assertEmpty(this.getLocks());
        connection.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a >= 1 and a < 20 for update of b, c");
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArrayArray = new String[1][];
                stringArray17 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray17 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray50 = new String[1][];
            stringArray17 = stringArray50;
            stringArray50[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray17);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1", "10", UpdateLocksTest.pad2("one", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray51 = new String[1][];
                stringArray16 = stringArray51;
                stringArray51[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray16 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray16);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"2", "20", UpdateLocksTest.pad2("two", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray52 = new String[1][];
                stringArray15 = stringArray52;
                stringArray52[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray15 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray15 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray15);
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray53 = new String[2][];
                stringArray53[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray14 = stringArray53;
                stringArray53[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (n2 == 0) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
            stringArray14 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
            stringArray14 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray14);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray54 = new String[2][];
                stringArray54[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray13 = stringArray54;
                stringArray54[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (n2 == 0) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray13 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray13 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray13);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"4", "40", UpdateLocksTest.pad2("four", n3)});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray55 = new String[2][];
                stringArray55[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArray12 = stringArray55;
                stringArray55[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (n2 == 0) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray12);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5", "50", UpdateLocksTest.pad2("five", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray56 = new String[2][];
                stringArray56[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArray11 = stringArray56;
                stringArray56[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (n2 == 0) {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "5", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray11);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"6", "60", UpdateLocksTest.pad2("six", n3)});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray57 = new String[2][];
                stringArray57[0] = new String[]{_app, _ut, _t, "6", _IX, _A, _tl, _g, _a};
                stringArray10 = stringArray57;
                stringArray57[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (n2 == 0) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[14][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[11] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[12] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[13] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
            stringArray10 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArray10 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray10);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray58 = new String[2][];
                stringArray58[0] = new String[]{_app, _ut, _t, "6", _IX, _A, _tl, _g, _a};
                stringArray9 = stringArray58;
                stringArray58[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (n2 == 0) {
                String[][] stringArrayArray = new String[12][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[11] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[15][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[11] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[12] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[13] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[14] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray9 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray9);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray59 = new String[2][];
                stringArray59[0] = new String[]{_app, _ut, _t, "6", _IX, _A, _tl, _g, _a};
                stringArray8 = stringArray59;
                stringArray59[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (n2 == 0) {
                String[][] stringArrayArray = new String[12][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[11] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[15][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[11] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[12] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[13] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[14] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray8);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray60 = new String[2][];
                stringArray60[0] = new String[]{_app, _ut, _t, "6", _IX, _A, _tl, _g, _a};
                stringArray7 = stringArray60;
                stringArray60[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else if (n2 == 0) {
                String[][] stringArrayArray = new String[12][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[11] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[15][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[11] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[12] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[13] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[14] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "7", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray7);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        connection.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select a from a"), new String[][]{{"1"}, {"3"}, {"5"}, {"7"}});
        ResultSet resultSet4 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray4 = new String[4][];
            objectArray4[0] = new String[]{"1", "10", "one"};
            objectArray4[1] = new String[]{"3", "30", "three"};
            objectArray4[2] = new String[]{"5", "50", "five"};
            objectArray = objectArray4;
            objectArray4[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            objectArray = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet4, objectArray, false);
        connection.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a >= 1 and a < 20 for update of b, c");
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArrayArray = new String[1][];
                stringArray6 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray6 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray61 = new String[1][];
            stringArray6 = stringArray61;
            stringArray61[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray6);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1", "10", UpdateLocksTest.pad2("one", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray62 = new String[1][];
                stringArray5 = stringArray62;
                stringArray62[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray5 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray5);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray63 = new String[1][];
                stringArray4 = stringArray63;
                stringArray63[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray4);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5", "50", UpdateLocksTest.pad2("five", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray64 = new String[1][];
                stringArray3 = stringArray64;
                stringArray64[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray3);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray65 = new String[1][];
                stringArray2 = stringArray65;
                stringArray65[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray2);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray66 = new String[1][];
                stringArray = stringArray66;
                stringArray66[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray);
        resultSet.close();
    }

    /*
     * Opcode count of 29972 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void updateBtreeCursorLocks2(Connection connection, int n, int n2, boolean bl, int n3, int n4, boolean bl2) throws SQLException {
        Object[][] objectArray;
        String[][] stringArray;
        String[][] stringArray2;
        String[][] stringArray3;
        Object[][] objectArray2;
        String[][] stringArray4;
        String[][] stringArray5;
        String[][] stringArray6;
        Object[][] objectArray3;
        String[][] stringArray7;
        String[][] stringArray8;
        String[][] stringArray9;
        String[][] stringArray10;
        Object[][] objectArray4;
        String[][] stringArray11;
        String[][] stringArray12;
        String[][] stringArray13;
        Object[][] objectArray5;
        String[][] stringArray14;
        String[][] stringArray15;
        String[][] stringArray16;
        String[][] stringArray17;
        String[][] stringArray18;
        Object[][] objectArray6;
        String[][] stringArray19;
        String[][] stringArray20;
        String[][] stringArray21;
        String[][] stringArray22;
        String[][] stringArray23;
        String[][] stringArray24;
        String[][] stringArray25;
        Object[][] objectArray7;
        String[][] stringArray26;
        String[][] stringArray27;
        Object[][] objectArray8;
        String[][] stringArray28;
        String[][] stringArray29;
        String[][] stringArray30;
        Object[][] objectArray9;
        String[][] stringArray31;
        Statement statement = bl2 ? connection.createStatement(1003, 1008, 1) : connection.createStatement(1003, 1008);
        ResultSet resultSet = null;
        ResultSet resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray32 = new String[1][];
                stringArray31 = stringArray32;
                stringArray32[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray31 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray31 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray31);
        connection.commit();
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        connection.commit();
        ResultSet resultSet3 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray10 = new String[4][];
            objectArray10[0] = new String[]{"1", "10", "one"};
            objectArray10[1] = new String[]{"3", "30", "three"};
            objectArray10[2] = new String[]{"5", "50", "five"};
            objectArray9 = objectArray10;
            objectArray10[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            objectArray9 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet3, objectArray9, false);
        connection.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a = 3 for update of b, c");
        JDBC.assertUnorderedResultSet(this.getLocks(), new String[][]{{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a}});
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n3)});
        resultSet.updateInt("B", -3000);
        resultSet.updateRow();
        resultSet2 = this.getLocks();
        if (n == 8 && n2 == 1 && bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, "Tablelock ", _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(1,8)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(1,9)", _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1  ", _X, _A, "(1,9)", _g, _a};
        } else if (n == 8 && n2 == 1 && !bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, "Tablelock ", _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(2,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(3,6)", _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1  ", _X, _A, "(3,6)", _g, _a};
        } else if (n == 8 && !bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, "Tablelock ", _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(2,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(3,6)", _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1  ", _X, _A, "(3,6)", _g, _a};
        } else if (bl) {
            String[][] stringArray33 = new String[3][];
            stringArray33[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray33[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray30 = stringArray33;
            stringArray33[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray30 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray30);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        String[][] stringArray34 = !UpdateLocksTest.usingDerbyNetClient() ? new String[][]{{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a}, {_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a}, {_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a}} : new String[][]{{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a}, {_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a}};
        if (n == 8) {
            if (n2 == 1) {
                if (bl) {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, "Tablelock ", _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(1,8)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(1,9)", _g, _a};
                    stringArray29 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1  ", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, "Tablelock ", _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1  ", _U, _A, "(3,6)", _g, _a};
                    stringArray29 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1  ", _X, _A, "(3,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            if (n2 == 0) {
                stringArray29 = stringArray34;
            } else {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray29 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray29 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray29);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (n2 == 0) {
                if (bl) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                    stringArray28 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                    stringArray28 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray28 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray35 = new String[2][];
            stringArray35[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArray35;
            stringArray35[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray28 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray28);
        connection.commit();
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        connection.commit();
        ResultSet resultSet4 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray11 = new String[4][];
            objectArray11[0] = new String[]{"1", "10", "one"};
            objectArray11[1] = new String[]{"3", "-3000", "three"};
            objectArray11[2] = new String[]{"5", "50", "five"};
            objectArray8 = objectArray11;
            objectArray11[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "-3000", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            objectArray8 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet4, objectArray8, false);
        connection.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a = 3 for update of b, c");
        JDBC.assertUnorderedResultSet(this.getLocks(), new String[][]{{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a}});
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "-3000", UpdateLocksTest.pad2("three", n3)});
        resultSet.updateInt("B", 30);
        resultSet.updateRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (n2 == 0) {
                if (bl) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                    stringArray27 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                    stringArray27 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray27 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray36 = new String[3][];
            stringArray36[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray36[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray27 = stringArray36;
            stringArray36[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray27 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray27);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (n2 == 0) {
                if (bl) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                    stringArray26 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                    stringArray26 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray26 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray37 = new String[2][];
            stringArray37[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray26 = stringArray37;
            stringArray37[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray26 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray26);
        connection.commit();
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        connection.commit();
        ResultSet resultSet5 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray12 = new String[4][];
            objectArray12[0] = new String[]{"1", "10", "one"};
            objectArray12[1] = new String[]{"3", "30", "three"};
            objectArray12[2] = new String[]{"5", "50", "five"};
            objectArray7 = objectArray12;
            objectArray12[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            objectArray7 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet5, objectArray7, false);
        connection.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a >= 1 and a < 20 for update of b, c");
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArrayArray = new String[1][];
                stringArray25 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray25 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray38 = new String[1][];
            stringArray25 = stringArray38;
            stringArray38[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray25);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1", "10", UpdateLocksTest.pad2("one", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray39 = new String[1][];
                stringArray24 = stringArray39;
                stringArray39[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArray24 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray24 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray24);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", UpdateLocksTest.pad2("three", n3)});
        resultSet.updateInt("B", -30);
        resultSet.updateString("C", "-three");
        resultSet.updateRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray40 = new String[2][];
                stringArray40[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArray23 = stringArray40;
                stringArray40[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray23 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray23 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray23);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5", "50", UpdateLocksTest.pad2("five", n3)});
        resultSet.updateInt("B", -50);
        resultSet.updateString("C", "-five");
        resultSet.updateRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray41 = new String[2][];
                stringArray41[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray22 = stringArray41;
                stringArray41[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray22);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3)});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray42 = new String[2][];
                stringArray42[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray21 = stringArray42;
                stringArray42[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray21 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray21 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray21);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray43 = new String[2][];
                stringArray43[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray20 = stringArray43;
                stringArray43[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray20);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray44 = new String[2][];
                stringArray44[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray19 = stringArray44;
                stringArray44[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[11][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[9] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[10] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray19 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray19 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray19);
        connection.commit();
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        connection.commit();
        ResultSet resultSet6 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray13 = new String[4][];
            objectArray13[0] = new String[]{"1", "10", "one"};
            objectArray13[1] = new String[]{"3", "-30", "-three"};
            objectArray13[2] = new String[]{"5", "-50", "-five"};
            objectArray6 = objectArray13;
            objectArray13[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "-30", "-three", UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "-50", "-five", UpdateLocksTest.pad2("index pad 5", n4)};
            objectArray6 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet6, objectArray6, false);
        connection.commit();
        resultSet = statement.executeQuery("select a from a where a > 0 and b < 0 for update of b, c");
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArrayArray = new String[1][];
                stringArray18 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[1][];
                stringArray18 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            }
        } else {
            String[][] stringArray45 = new String[1][];
            stringArray18 = stringArray45;
            stringArray45[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray18);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3"});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray46 = new String[1][];
                stringArray17 = stringArray46;
                stringArray46[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArray17 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArray17 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray17 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray17);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5"});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray47 = new String[1][];
                stringArray16 = stringArray47;
                stringArray47[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray16 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray16 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
            stringArray16 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray16);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray48 = new String[1][];
                stringArray15 = stringArray48;
                stringArray48[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray15 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray15);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArray49 = new String[1][];
                stringArray14 = stringArray49;
                stringArray49[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _U, _A, "(6,6)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray14 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray14 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray14);
        connection.commit();
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        connection.commit();
        ResultSet resultSet7 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray14 = new String[4][];
            objectArray14[0] = new String[]{"1", "10", "one"};
            objectArray14[1] = new String[]{"3", "-30", "-three"};
            objectArray14[2] = new String[]{"5", "-50", "-five"};
            objectArray5 = objectArray14;
            objectArray14[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "-30", "-three", UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "-50", "-five", UpdateLocksTest.pad2("index pad 5", n4)};
            objectArray5 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet7, objectArray5, false);
        connection.commit();
        resultSet = statement.executeQuery("select a from a where a = 1 for update of b, c");
        JDBC.assertUnorderedResultSet(this.getLocks(), new String[][]{{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a}});
        resultSet.next();
        this.assertRow(resultSet, new String[]{"1"});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8 && n2 == 1) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
            stringArray13 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (n == 8 && n2 == 0 && !bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray13 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArray50 = new String[3][];
            stringArray50[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray50[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray13 = stringArray50;
            stringArray50[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray13);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        stringArray34 = UpdateLocksTest.usingDerbyNetClient() && n != 8 ? new String[][]{{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a}, {_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a}} : new String[][]{{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a}, {_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a}, {_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a}};
        if (n == 8 && n2 == 1) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (n == 8 && n2 == 0 && !bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            }
        } else if (bl) {
            if (n2 == 0) {
                stringArray12 = stringArray34;
            } else {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArray12 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            }
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray12 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray12);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8 && n2 == 1) {
            String[][] stringArrayArray = new String[5][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (n == 8 && n2 == 0 && !bl) {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (n == 8) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else if (n == 4) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArray51 = new String[2][];
            stringArray51[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray11 = stringArray51;
            stringArray51[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray11);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        connection.commit();
        ResultSet resultSet8 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray15 = new String[3][];
            objectArray15[0] = new String[]{"3", "-30", "-three"};
            objectArray15[1] = new String[]{"5", "-50", "-five"};
            objectArray4 = objectArray15;
            objectArray15[2] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{"3", "-30", "-three", UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[1] = new String[]{"5", "-50", "-five", UpdateLocksTest.pad2("index pad 5", n4)};
            objectArray4 = stringArrayArray;
            stringArrayArray[2] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet8, objectArray4, false);
        connection.commit();
        resultSet = statement.executeQuery("select a from a where a <> 3 and a <> 5 for update of b, c");
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray52 = new String[1][];
            stringArray10 = stringArray52;
            stringArray52[0] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray10 = stringArrayArray;
            stringArrayArray[0] = new String[]{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray10);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"7"});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray53 = new String[2][];
            stringArray53[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray9 = stringArray53;
            stringArray53[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (bl) {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
            stringArray9 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray9);
        UpdateLocksTest.assertFalse((boolean)resultSet.next());
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray54 = new String[2][];
            stringArray54[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray8 = stringArray54;
            stringArray54[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray8);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            String[][] stringArray55 = new String[2][];
            stringArray55[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray7 = stringArray55;
            stringArray55[1] = new String[]{_app, _ut, _t, "1", _X, _A, _tl, _g, _a};
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,13)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(7,6)", _g, _a};
                stringArray7 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "3", _IX, _A, _tl, _g, _a};
            stringArray7 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray7);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        connection.commit();
        ResultSet resultSet9 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray16 = new String[2][];
            objectArray16[0] = new String[]{"3", "-30", "-three"};
            objectArray3 = objectArray16;
            objectArray16[1] = new String[]{"5", "-50", "-five"};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{"3", "-30", "-three", UpdateLocksTest.pad2("index pad 3", n4)};
            objectArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{"5", "-50", "-five", UpdateLocksTest.pad2("index pad 5", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet9, objectArray3, false);
        connection.commit();
        resultSet = statement.executeQuery("select a,b,c from a where a > 2 and a <= 5 for update of b, c");
        JDBC.assertUnorderedResultSet(this.getLocks(), new String[][]{{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a}});
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "-30", "-three"});
        resultSet.updateInt("B", 30);
        resultSet.updateString("C", "three");
        resultSet.updateRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray56 = new String[3][];
            stringArray56[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray56[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray6 = stringArray56;
            stringArray56[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray6 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray6);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5", "-50", "-five"});
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray5 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray57 = new String[3][];
            stringArray57[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray57[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArray5 = stringArray57;
            stringArray57[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            stringArray5 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray5);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray58 = new String[2][];
            stringArray58[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray4 = stringArray58;
            stringArray58[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray4);
        connection.commit();
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        connection.commit();
        ResultSet resultSet10 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray17 = new String[2][];
            objectArray17[0] = new String[]{"3", "30", "three"};
            objectArray2 = objectArray17;
            objectArray17[1] = new String[]{"5", "-50", "-five"};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{"3", "30", "three", UpdateLocksTest.pad2("index pad 3", n4)};
            objectArray2 = stringArrayArray;
            stringArrayArray[1] = new String[]{"5", "-50", "-five", UpdateLocksTest.pad2("index pad 5", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet10, objectArray2, false);
        connection.commit();
        resultSet = statement.executeQuery("select a, b, c from a where a > 0 for update of b, c");
        JDBC.assertUnorderedResultSet(this.getLocks(), new String[][]{{_app, _ut, _t, "1", _IX, _A, _tl, _g, _a}});
        resultSet.next();
        this.assertRow(resultSet, new String[]{"3", "30", "three"});
        resultSet.updateInt("B", 3030);
        resultSet.updateString("C", "threethree");
        resultSet.updateRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (bl) {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[6][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArray3 = stringArrayArray;
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray59 = new String[3][];
            stringArray59[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray59[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
            stringArray3 = stringArray59;
            stringArray59[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
            stringArray3 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray3);
        resultSet.next();
        this.assertRow(resultSet, new String[]{"5", "-50", "-five"});
        resultSet.deleteRow();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (n2 == 0) {
                if (bl) {
                    String[][] stringArrayArray = new String[9][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                    stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                    stringArray2 = stringArrayArray;
                    stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[9][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                    stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                    stringArray2 = stringArrayArray;
                    stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray60 = new String[4][];
            stringArray60[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArray60[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
            stringArray60[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            stringArray2 = stringArray60;
            stringArray60[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray2);
        resultSet.close();
        resultSet2 = this.getLocks();
        if (n == 8) {
            if (n2 == 0) {
                if (bl) {
                    String[][] stringArrayArray = new String[9][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                    stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                    stringArray = stringArrayArray;
                    stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[9][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                    stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                    stringArray = stringArrayArray;
                    stringArrayArray[8] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,8)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[10][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _U, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _U, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[9] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
            }
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,11)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(1,9)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _U, _A, "(3,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _U, _A, "(5,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray61 = new String[3][];
            stringArray61[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArray61[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
            stringArray = stringArray61;
            stringArray61[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArray = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet2 = this.getLocks();
        JDBC.assertEmpty(resultSet2);
        connection.commit();
        ResultSet resultSet11 = statement.executeQuery("select * from a");
        if (bl) {
            Object[][] objectArray18 = new String[1][];
            objectArray = objectArray18;
            objectArray18[0] = new String[]{"3", "3030", "threethree"};
        } else {
            String[][] stringArrayArray = new String[1][];
            objectArray = stringArrayArray;
            stringArrayArray[0] = new String[]{"3", "3030", "threethree", UpdateLocksTest.pad2("index pad 3", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet11, objectArray, false);
        connection.commit();
        statement.executeUpdate("drop table a");
        resultSet2.close();
        statement.close();
        resultSet.close();
    }

    /*
     * Opcode count of 13512 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void updateBtreeSetLocks(Connection connection, int n, int n2, boolean bl, int n3, int n4) throws SQLException {
        String[][] stringArray;
        String[][] stringArray2;
        String[][] stringArray3;
        String[][] stringArray4;
        String[][] stringArray5;
        String[][] stringArray6;
        String[][] stringArray7;
        String[][] stringArray8;
        String[][] stringArray9;
        String[][] stringArray10;
        String[][] stringArray11;
        String[][] stringArray12;
        String[][] stringArray13;
        String[][] stringArray14;
        String[][] stringArray15;
        String[][] stringArray16;
        String[][] stringArray17;
        String[][] stringArray18;
        String[][] stringArray19;
        String[][] stringArray20;
        String[][] stringArray21;
        String[][] stringArray22;
        String[][] stringArray23;
        String[][] stringArray24;
        String[][] stringArray25;
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray26 = new String[7][];
            stringArray26[0] = new String[]{"1", "10", "one"};
            stringArray26[1] = new String[]{"2", "20", "two"};
            stringArray26[2] = new String[]{"3", "30", "three"};
            stringArray26[3] = new String[]{"4", "40", "four"};
            stringArray26[4] = new String[]{"5", "50", "five"};
            stringArray26[5] = new String[]{"6", "60", "six"};
            stringArray25 = stringArray26;
            stringArray26[6] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[7][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"2", "20", UpdateLocksTest.pad2("two", n3), UpdateLocksTest.pad2("index pad 2", n4)};
            stringArrayArray[2] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[3] = new String[]{"4", "40", UpdateLocksTest.pad2("four", n3), UpdateLocksTest.pad2("index pad 4", n4)};
            stringArrayArray[4] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArrayArray[5] = new String[]{"6", "60", UpdateLocksTest.pad2("six", n3), UpdateLocksTest.pad2("index pad 6", n4)};
            stringArray25 = stringArrayArray;
            stringArrayArray[6] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet, stringArray25);
        connection.commit();
        ResultSet resultSet2 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray27 = new String[7][];
            stringArray27[0] = new String[]{"1", "10", "one"};
            stringArray27[1] = new String[]{"2", "20", "two"};
            stringArray27[2] = new String[]{"3", "30", "three"};
            stringArray27[3] = new String[]{"4", "40", "four"};
            stringArray27[4] = new String[]{"5", "50", "five"};
            stringArray27[5] = new String[]{"6", "60", "six"};
            stringArray24 = stringArray27;
            stringArray27[6] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[7][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"2", "20", UpdateLocksTest.pad2("two", n3), UpdateLocksTest.pad2("index pad 2", n4)};
            stringArrayArray[2] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[3] = new String[]{"4", "40", UpdateLocksTest.pad2("four", n3), UpdateLocksTest.pad2("index pad 4", n4)};
            stringArrayArray[4] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArrayArray[5] = new String[]{"6", "60", UpdateLocksTest.pad2("six", n3), UpdateLocksTest.pad2("index pad 6", n4)};
            stringArray24 = stringArrayArray;
            stringArrayArray[6] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet2, stringArray24);
        ResultSet resultSet3 = this.getLocks();
        if (n == 8) {
            String[][] stringArray28 = new String[1][];
            stringArray23 = stringArray28;
            stringArray28[0] = new String[]{_app, _ut, _t, "1", "S", _A, _tl, _g, _a};
        } else if (n == 4) {
            if (bl) {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", "IS", _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,11)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,12)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,13)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,7)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,8)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[8][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "1", "IS", _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", "S", _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", "S", _A, "(2,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", "S", _A, "(3,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", "S", _A, "(4,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", "S", _A, "(5,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", "S", _A, "(6,6)", _g, _a};
                stringArray23 = stringArrayArray;
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", "S", _A, "(7,6)", _g, _a};
            }
        } else {
            stringArray23 = new String[][]{};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray23);
        connection.commit();
        JDBC.assertEmpty(this.getLocks());
        connection.commit();
        statement.executeUpdate("delete from a where a = 4");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 1) {
                if (bl) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                    stringArray22 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                    stringArray22 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArray22 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray29 = new String[2][];
            stringArray29[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray22 = stringArray29;
            stringArray29[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray22 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray22);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        connection.commit();
        ResultSet resultSet4 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray30 = new String[6][];
            stringArray30[0] = new String[]{"1", "10", "one"};
            stringArray30[1] = new String[]{"2", "20", "two"};
            stringArray30[2] = new String[]{"3", "30", "three"};
            stringArray30[3] = new String[]{"5", "50", "five"};
            stringArray30[4] = new String[]{"6", "60", "six"};
            stringArray21 = stringArray30;
            stringArray30[5] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[6][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"2", "20", UpdateLocksTest.pad2("two", n3), UpdateLocksTest.pad2("index pad 2", n4)};
            stringArrayArray[2] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[3] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArrayArray[4] = new String[]{"6", "60", UpdateLocksTest.pad2("six", n3), UpdateLocksTest.pad2("index pad 6", n4)};
            stringArray21 = stringArrayArray;
            stringArrayArray[5] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet4, stringArray21);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        statement.executeUpdate("delete from a where a = 2 or a = 4 or a = 6");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 1) {
                if (bl) {
                    String[][] stringArrayArray = new String[7][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,11)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,9)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                    stringArray20 = stringArrayArray;
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[7][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                    stringArray20 = stringArrayArray;
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[7][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
                stringArray20 = stringArrayArray;
                stringArrayArray[6] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray31 = new String[4][];
            stringArray31[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray31[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray31[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,12)", _g, _a};
            stringArray20 = stringArray31;
            stringArray31[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(2,6)", _g, _a};
            stringArray20 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(6,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray20);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        connection.commit();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select a from a"), new String[][]{{"1"}, {"3"}, {"5"}, {"7"}});
        ResultSet resultSet5 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray32 = new String[4][];
            stringArray32[0] = new String[]{"1", "10", "one"};
            stringArray32[1] = new String[]{"3", "30", "three"};
            stringArray32[2] = new String[]{"5", "50", "five"};
            stringArray19 = stringArray32;
            stringArray32[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArray19 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet5, stringArray19);
        connection.commit();
        statement.executeUpdate("delete from a where (a = 2 or a = 4 or a = 6) and (b < 8)");
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        connection.commit();
        ResultSet resultSet6 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray33 = new String[4][];
            stringArray33[0] = new String[]{"1", "10", "one"};
            stringArray33[1] = new String[]{"3", "30", "three"};
            stringArray33[2] = new String[]{"5", "50", "five"};
            stringArray18 = stringArray33;
            stringArray33[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArray18 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet6, stringArray18);
        connection.commit();
        statement.executeUpdate("update a  set b = 300 where a = 3");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 1) {
                if (bl) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                    stringArray17 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArray17 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray17 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray17 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray34 = new String[2][];
            stringArray34[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArray34;
            stringArray34[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray17 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray17);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        connection.commit();
        ResultSet resultSet7 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray35 = new String[4][];
            stringArray35[0] = new String[]{"1", "10", "one"};
            stringArray35[1] = new String[]{"3", "300", "three"};
            stringArray35[2] = new String[]{"5", "50", "five"};
            stringArray16 = stringArray35;
            stringArray35[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "300", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArray16 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet7, stringArray16);
        connection.commit();
        statement.executeUpdate("update a  set b = 30 where a = 3 and b = 300");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 1) {
                if (bl) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                    stringArray15 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArray15 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArray15 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray36 = new String[2][];
            stringArray36[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray15 = stringArray36;
            stringArray36[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray15 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray15);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        connection.commit();
        ResultSet resultSet8 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray37 = new String[4][];
            stringArray37[0] = new String[]{"1", "10", "one"};
            stringArray37[1] = new String[]{"3", "30", "three"};
            stringArray37[2] = new String[]{"5", "50", "five"};
            stringArray14 = stringArray37;
            stringArray37[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArray14 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet8, stringArray14);
        connection.commit();
        statement.executeUpdate("update a  set b = -b where a >= 3 and a < 6");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 1) {
                if (bl) {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,11)", _g, _a};
                    stringArray13 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                    stringArray13 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(5,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,11)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                stringArray13 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(5,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray38 = new String[4][];
            stringArray38[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray38[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray38[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,11)", _g, _a};
            stringArray13 = stringArray38;
            stringArray38[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
            stringArray13 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(5,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray13);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        connection.commit();
        ResultSet resultSet9 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray39 = new String[4][];
            stringArray39[0] = new String[]{"1", "10", "one"};
            stringArray39[1] = new String[]{"3", "-30", "three"};
            stringArray39[2] = new String[]{"5", "-50", "five"};
            stringArray12 = stringArray39;
            stringArray39[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "-30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "-50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArray12 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet9, stringArray12);
        connection.commit();
        statement.executeUpdate("delete from a  where a = 2");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 1) {
                if (bl) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArray11 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArray11 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray11 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray40 = new String[2][];
            stringArray40[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray11 = stringArray40;
            stringArray40[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray11 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray11);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        statement.executeUpdate("update a  set b = -b where a = 2");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 1) {
                if (bl) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArray10 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArray10 = stringArrayArray;
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[2][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArray10 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray41 = new String[2][];
            stringArray41[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray10 = stringArray41;
            stringArray41[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray10 = stringArrayArray;
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray10);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        ResultSet resultSet10 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray42 = new String[4][];
            stringArray42[0] = new String[]{"1", "10", "one"};
            stringArray42[1] = new String[]{"3", "-30", "three"};
            stringArray42[2] = new String[]{"5", "-50", "five"};
            stringArray9 = stringArray42;
            stringArray42[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "-30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "-50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArray9 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet10, stringArray9);
        connection.commit();
        statement.executeUpdate("delete from a  where a > 0 and b < -1000");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 0) {
                if (bl) {
                    String[][] stringArrayArray = new String[1][];
                    stringArray8 = stringArrayArray;
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
                } else {
                    String[][] stringArrayArray = new String[9][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                    stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                    stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                    stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(6,6)", _g, _a};
                    stringArray8 = stringArrayArray;
                    stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(7,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[1][];
                stringArray8 = stringArrayArray;
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _X, _A, _tl, _g, _a};
            } else {
                String[][] stringArrayArray = new String[9][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
                stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
                stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(6,6)", _g, _a};
                stringArray8 = stringArrayArray;
                stringArrayArray[8] = new String[]{_app, _ut, _r, "1", _X, _A, "(7,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray43 = new String[1][];
            stringArray8 = stringArray43;
            stringArray43[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
        } else {
            String[][] stringArrayArray = new String[8][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,7)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
            stringArrayArray[3] = new String[]{_app, _ut, _r, "1", _X, _A, "(3,6)", _g, _a};
            stringArrayArray[4] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArrayArray[5] = new String[]{_app, _ut, _r, "1", _X, _A, "(5,6)", _g, _a};
            stringArrayArray[6] = new String[]{_app, _ut, _r, "1", _X, _A, "(6,6)", _g, _a};
            stringArray8 = stringArrayArray;
            stringArrayArray[7] = new String[]{_app, _ut, _r, "1", _X, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray8);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        ResultSet resultSet11 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray44 = new String[4][];
            stringArray44[0] = new String[]{"1", "10", "one"};
            stringArray44[1] = new String[]{"3", "-30", "three"};
            stringArray44[2] = new String[]{"5", "-50", "five"};
            stringArray7 = stringArray44;
            stringArray44[3] = new String[]{"7", "70", "seven"};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{"1", "10", UpdateLocksTest.pad2("one", n3), UpdateLocksTest.pad2("index pad 1", n4)};
            stringArrayArray[1] = new String[]{"3", "-30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArrayArray[2] = new String[]{"5", "-50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
            stringArray7 = stringArrayArray;
            stringArrayArray[3] = new String[]{"7", "70", UpdateLocksTest.pad2("seven", n3), UpdateLocksTest.pad2("index pad 7", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet11, stringArray7);
        connection.commit();
        statement.executeUpdate("delete from a  where a = 1 or a = 7");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 1) {
                if (bl) {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,12)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
                    stringArray6 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(6,6)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
                    stringArray6 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[3][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,3)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(6,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
                stringArray6 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray45 = new String[3][];
            stringArray45[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray45[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,13)", _g, _a};
            stringArray6 = stringArray45;
            stringArray45[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,7)", _g, _a};
            stringArray6 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(7,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray6);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        connection.commit();
        ResultSet resultSet12 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray46 = new String[2][];
            stringArray46[0] = new String[]{"3", "-30", "three"};
            stringArray5 = stringArray46;
            stringArray46[1] = new String[]{"5", "-50", "five"};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{"3", "-30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArray5 = stringArrayArray;
            stringArrayArray[1] = new String[]{"5", "-50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet12, stringArray5);
        connection.commit();
        statement.executeUpdate("update a  set b = 30 where a > 2 and a < 5");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 0) {
                if (bl) {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                    stringArray4 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[4][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                    stringArray4 = stringArrayArray;
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[4][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
                stringArray4 = stringArrayArray;
                stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray47 = new String[3][];
            stringArray47[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArray47[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray4 = stringArray47;
            stringArray47[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[3][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "2", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArray4 = stringArrayArray;
            stringArrayArray[2] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray4);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        connection.commit();
        ResultSet resultSet13 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray48 = new String[2][];
            stringArray48[0] = new String[]{"3", "30", "three"};
            stringArray3 = stringArray48;
            stringArray48[1] = new String[]{"5", "-50", "five"};
        } else {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{"3", "30", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
            stringArray3 = stringArrayArray;
            stringArrayArray[1] = new String[]{"5", "-50", UpdateLocksTest.pad2("five", n3), UpdateLocksTest.pad2("index pad 5", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet13, stringArray3);
        connection.commit();
        statement.executeUpdate("update a  set b = 3030 where a > 2 and a < 5");
        statement.executeUpdate("delete from a where a = 5");
        resultSet3 = this.getLocks();
        if (n == 8) {
            if (n2 == 1) {
                if (bl) {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,10)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
                    stringArray2 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
                } else {
                    String[][] stringArrayArray = new String[5][];
                    stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                    stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                    stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                    stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
                    stringArray2 = stringArrayArray;
                    stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
                }
            } else if (bl) {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,8)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
            } else {
                String[][] stringArrayArray = new String[5][];
                stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
                stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(2,6)", _g, _a};
                stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(4,6)", _g, _a};
                stringArrayArray[3] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
                stringArray2 = stringArrayArray;
                stringArrayArray[4] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
            }
        } else if (bl) {
            String[][] stringArray49 = new String[4][];
            stringArray49[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArray49[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(1,10)", _g, _a};
            stringArray49[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(1,11)", _g, _a};
            stringArray2 = stringArray49;
            stringArray49[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(1,9)", _g, _a};
        } else {
            String[][] stringArrayArray = new String[4][];
            stringArrayArray[0] = new String[]{_app, _ut, _t, "4", _IX, _A, _tl, _g, _a};
            stringArrayArray[1] = new String[]{_app, _ut, _r, "1", _X, _A, "(4,6)", _g, _a};
            stringArrayArray[2] = new String[]{_app, _ut, _r, "2", _X, _A, "(5,6)", _g, _a};
            stringArray2 = stringArrayArray;
            stringArrayArray[3] = new String[]{_app, _ut, _r, "3", _X, _A, "(3,6)", _g, _a};
        }
        JDBC.assertUnorderedResultSet(resultSet3, stringArray2);
        connection.commit();
        statement.execute("call wait_for_post_commit()");
        resultSet3 = this.getLocks();
        JDBC.assertEmpty(resultSet3);
        connection.commit();
        ResultSet resultSet14 = statement.executeQuery("select * from a");
        if (bl) {
            String[][] stringArray50 = new String[1][];
            stringArray = stringArray50;
            stringArray50[0] = new String[]{"3", "3030", "three"};
        } else {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = new String[]{"3", "3030", UpdateLocksTest.pad2("three", n3), UpdateLocksTest.pad2("index pad 3", n4)};
        }
        JDBC.assertUnorderedResultSet(resultSet14, stringArray);
        connection.commit();
        statement.executeUpdate("drop table a");
        resultSet3.close();
        statement.close();
    }

    private void verifyRsMetaData(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        UpdateLocksTest.assertEquals((int)resultSetMetaData.getColumnCount(), (int)9);
        String[] stringArray = new String[]{"USERNAME", "TRANTYPE", "TYPE", "CNT", "MODE", "TABNAME", "LOCKNAME", "STATE", "STATUS"};
        for (int i = 0; i < stringArray.length; ++i) {
            UpdateLocksTest.assertTrue((boolean)stringArray[i].equals(resultSetMetaData.getColumnName(i + 1)));
        }
    }

    private void assertRow(ResultSet resultSet, String[] stringArray) throws SQLException {
        UpdateLocksTest.assertEquals((int)resultSet.getMetaData().getColumnCount(), (int)stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            UpdateLocksTest.assertEquals((String)stringArray[i], (String)resultSet.getString(i + 1));
        }
    }

    private static String pad2(String string, int n) {
        if (n == 0) {
            return string;
        }
        char[] cArray = new char[n];
        string.getChars(0, string.length(), cArray, 0);
        Arrays.fill(cArray, string.length(), n, ' ');
        cArray[n - 1] = '\u0000';
        return new String(cArray);
    }

    private ResultSet getLocks() throws SQLException {
        return this.getLocksQuery.executeQuery();
    }
}

