/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class TernaryOperatorNode
extends OperatorNode {
    static final int K_TRIM = 0;
    static final int K_LOCATE = 1;
    static final int K_SUBSTRING = 2;
    static final int K_LIKE = 3;
    static final int K_TIMESTAMPADD = 4;
    static final int K_TIMESTAMPDIFF = 5;
    final int kind;
    String operator;
    String methodName;
    ValueNode receiver;
    ValueNode leftOperand;
    ValueNode rightOperand;
    String resultInterfaceType;
    String receiverInterfaceType;
    String leftInterfaceType;
    String rightInterfaceType;
    int trimType;
    static final String[] TernaryOperators = new String[]{"trim", "LOCATE", "substring", "like", "TIMESTAMPADD", "TIMESTAMPDIFF"};
    static final String[] TernaryMethodNames = new String[]{"ansiTrim", "locate", "substring", "like", "timestampAdd", "timestampDiff"};
    static final String[] TernaryResultType = new String[]{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.ConcatableDataValue", "org.apache.derby.iapi.types.BooleanDataValue", "org.apache.derby.iapi.types.DateTimeDataValue", "org.apache.derby.iapi.types.NumberDataValue"};
    static final String[][] TernaryArgType = new String[][]{{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.StringDataValue", "java.lang.Integer"}, {"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.ConcatableDataValue", "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor"}, {"org.apache.derby.iapi.types.DateTimeDataValue", "java.lang.Integer", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.DateTimeDataValue", "java.lang.Integer", "org.apache.derby.iapi.types.DateTimeDataValue"}};

    TernaryOperatorNode(ValueNode receiver, ValueNode leftOperand, ValueNode rightOperand, int kind, ContextManager cm) {
        super(cm);
        this.kind = kind;
        this.constructorMinion(receiver, leftOperand, rightOperand, -1);
    }

    TernaryOperatorNode(ValueNode receiver, ValueNode leftOperand, ValueNode rightOperand, int kind, int trimType, ContextManager cm) {
        super(cm);
        this.kind = kind;
        this.constructorMinion(receiver, leftOperand, rightOperand, trimType);
    }

    private void constructorMinion(ValueNode receiver, ValueNode leftOperand, ValueNode rightOperand, int trimType) {
        this.receiver = receiver;
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
        this.operator = TernaryOperators[this.kind];
        this.methodName = TernaryMethodNames[this.kind];
        this.resultInterfaceType = TernaryResultType[this.kind];
        this.receiverInterfaceType = TernaryArgType[this.kind][0];
        this.leftInterfaceType = TernaryArgType[this.kind][1];
        this.rightInterfaceType = TernaryArgType[this.kind][2];
        if (trimType != -1) {
            this.trimType = trimType;
        }
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\nmethodName: " + this.methodName + "\nresultInterfaceType: " + this.resultInterfaceType + "\nreceiverInterfaceType: " + this.receiverInterfaceType + "\nleftInterfaceType: " + this.leftInterfaceType + "\nrightInterfaceType: " + this.rightInterfaceType + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.receiver != null) {
            this.printLabel(depth, "receiver: ");
            this.receiver.treePrint(depth + 1);
        }
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperand != null) {
            this.printLabel(depth, "rightOperand: ");
            this.rightOperand.treePrint(depth + 1);
        }
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.receiver = this.receiver.bindExpression(fromList, subqueryList, aggregates);
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregates);
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, aggregates);
        }
        if (this.kind == 0) {
            this.trimBind();
        } else if (this.kind == 1) {
            this.locateBind();
        } else if (this.kind == 2) {
            this.substrBind();
        } else if (this.kind == 4) {
            this.timestampAddBind();
        } else if (this.kind == 5) {
            this.timestampDiffBind();
        }
        return this;
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.receiver = this.receiver.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        }
        return this;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int nargs = 0;
        String receiverType = null;
        LocalField field = acb.newFieldDeclaration(2, this.resultInterfaceType);
        this.receiver.generateExpression(acb, mb);
        if (this.kind == 0) {
            mb.push(this.trimType);
            this.leftOperand.generateExpression(acb, mb);
            mb.cast(this.leftInterfaceType);
            mb.getField(field);
            nargs = 3;
            receiverType = this.receiverInterfaceType;
        } else if (this.kind == 1) {
            this.leftOperand.generateExpression(acb, mb);
            mb.upCast(this.leftInterfaceType);
            this.rightOperand.generateExpression(acb, mb);
            mb.upCast(this.rightInterfaceType);
            mb.getField(field);
            nargs = 3;
        } else if (this.kind == 2) {
            this.leftOperand.generateExpression(acb, mb);
            mb.upCast(this.leftInterfaceType);
            if (this.rightOperand != null) {
                this.rightOperand.generateExpression(acb, mb);
                mb.upCast(this.rightInterfaceType);
            } else {
                mb.pushNull(this.rightInterfaceType);
            }
            mb.getField(field);
            mb.push(this.receiver.getTypeServices().getMaximumWidth());
            nargs = 4;
            receiverType = this.receiverInterfaceType;
        } else if (this.kind == 4 || this.kind == 5) {
            Object intervalType = this.leftOperand.getConstantValueAsObject();
            SanityManager.ASSERT(intervalType != null && intervalType instanceof Integer, "Invalid interval type used for " + this.operator);
            mb.push((Integer)intervalType);
            this.rightOperand.generateExpression(acb, mb);
            mb.upCast(TernaryArgType[this.kind][2]);
            acb.getCurrentDateExpression(mb);
            mb.getField(field);
            nargs = 4;
            receiverType = this.receiverInterfaceType;
        }
        mb.callMethod((short)185, receiverType, this.methodName, this.resultInterfaceType, nargs);
        mb.putField(field);
    }

    void setLeftOperand(ValueNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    void setRightOperand(ValueNode newRightOperand) {
        this.rightOperand = newRightOperand;
    }

    ValueNode getRightOperand() {
        return this.rightOperand;
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        boolean pushable = this.receiver.categorize(referencedTabs, simplePredsOnly);
        boolean bl = pushable = this.leftOperand.categorize(referencedTabs, simplePredsOnly) && pushable;
        if (this.rightOperand != null) {
            pushable = this.rightOperand.categorize(referencedTabs, simplePredsOnly) && pushable;
        }
        return pushable;
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.receiver = this.receiver.remapColumnReferencesToExpressions();
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.remapColumnReferencesToExpressions();
        }
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.receiver.isConstantExpression() && this.leftOperand.isConstantExpression() && (this.rightOperand == null || this.rightOperand.isConstantExpression());
    }

    @Override
    boolean constantExpression(PredicateList whereClause) {
        return this.receiver.constantExpression(whereClause) && this.leftOperand.constantExpression(whereClause) && (this.rightOperand == null || this.rightOperand.constantExpression(whereClause));
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.receiver != null) {
            this.receiver = (ValueNode)this.receiver.accept(v);
        }
        if (this.leftOperand != null) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.rightOperand != null) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(v);
        }
    }

    private ValueNode trimBind() throws StandardException {
        TypeId leftCTI;
        TypeId resultType = TypeId.getBuiltInTypeId(12);
        if (this.receiver.requiresTypeFromContext()) {
            this.receiver.setType(this.getVarcharDescriptor());
            if (!this.leftOperand.requiresTypeFromContext()) {
                this.receiver.setCollationInfo(this.leftOperand.getTypeServices());
            } else {
                this.receiver.setCollationUsingCompilationSchema();
            }
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(this.getVarcharDescriptor());
            this.leftOperand.setCollationInfo(this.receiver.getTypeServices());
        }
        this.bindToBuiltIn();
        TypeId receiverType = this.receiver.getTypeId();
        if (receiverType.userType()) {
            this.throwBadType("trim", receiverType.getSQLTypeName());
        }
        this.receiver = this.castArgToString(this.receiver);
        if (receiverType.getTypeFormatId() == 444) {
            resultType = receiverType;
        }
        if ((leftCTI = this.leftOperand.getTypeId()).userType()) {
            this.throwBadType("trim", leftCTI.getSQLTypeName());
        }
        this.leftOperand = this.castArgToString(this.leftOperand);
        this.setResultType(resultType);
        this.setCollationInfo(this.receiver.getTypeServices());
        return this;
    }

    private void setResultType(TypeId resultType) throws StandardException {
        this.setType(new DataTypeDescriptor(resultType, true, this.receiver.getTypeServices().getMaximumWidth()));
    }

    ValueNode locateBind() throws StandardException {
        if (this.receiver.requiresTypeFromContext()) {
            if (this.leftOperand.requiresTypeFromContext()) {
                this.receiver.setType(this.getVarcharDescriptor());
                this.receiver.setCollationUsingCompilationSchema();
            } else if (this.leftOperand.getTypeId().isStringTypeId()) {
                this.receiver.setType(this.leftOperand.getTypeServices());
            }
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.receiver.requiresTypeFromContext()) {
                this.leftOperand.setType(this.getVarcharDescriptor());
            } else if (this.receiver.getTypeId().isStringTypeId()) {
                this.leftOperand.setType(this.receiver.getTypeServices());
            }
            this.leftOperand.setCollationInfo(this.receiver.getTypeServices());
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        this.bindToBuiltIn();
        TypeId secondOperandType = this.leftOperand.getTypeId();
        TypeId offsetType = this.rightOperand.getTypeId();
        TypeId firstOperandType = this.receiver.getTypeId();
        if (!firstOperandType.isStringTypeId() || !secondOperandType.isStringTypeId() || offsetType.getJDBCTypeId() != 4) {
            throw StandardException.newException("42884", "LOCATE", "FUNCTION");
        }
        this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.receiver.getTypeServices().isNullable()));
        return this;
    }

    protected ValueNode castArgToString(ValueNode vn) throws StandardException {
        TypeCompiler vnTC = vn.getTypeCompiler();
        if (!vn.getTypeId().isStringTypeId()) {
            DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, vnTC.getCastToCharWidth(vn.getTypeServices()));
            CastNode newNode = new CastNode(vn, dtd, this.getContextManager());
            newNode.setCollationUsingCompilationSchema();
            newNode.bindCastNodeOnly();
            return newNode;
        }
        return vn;
    }

    ValueNode substrBind() throws StandardException {
        TypeId resultType = TypeId.getBuiltInTypeId(12);
        if (this.receiver.requiresTypeFromContext()) {
            this.receiver.setType(this.getVarcharDescriptor());
            this.receiver.setCollationUsingCompilationSchema();
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        if (this.rightOperand != null && this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        this.bindToBuiltIn();
        if (!this.leftOperand.getTypeId().isNumericTypeId() || this.rightOperand != null && !this.rightOperand.getTypeId().isNumericTypeId()) {
            throw StandardException.newException("42884", "SUBSTR", "FUNCTION");
        }
        TypeId receiverType = this.receiver.getTypeId();
        switch (receiverType.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                this.throwBadType("SUBSTR", receiverType.getSQLTypeName());
            }
        }
        if (receiverType.getTypeFormatId() == 444) {
            resultType = receiverType;
        }
        int resultLen = this.receiver.getTypeServices().getMaximumWidth();
        if (this.rightOperand != null && this.rightOperand instanceof ConstantNode && ((ConstantNode)this.rightOperand).getValue().getInt() < resultLen) {
            resultLen = ((ConstantNode)this.rightOperand).getValue().getInt();
        }
        this.setType(new DataTypeDescriptor(resultType, true, resultLen));
        this.setCollationInfo(this.receiver.getTypeServices());
        return this;
    }

    private ValueNode timestampAddBind() throws StandardException {
        int jdbcType;
        if (!this.bindParameter(this.rightOperand, 4) && (jdbcType = this.rightOperand.getTypeId().getJDBCTypeId()) != -6 && jdbcType != 5 && jdbcType != 4 && jdbcType != -5) {
            throw StandardException.newException("42X45", this.rightOperand.getTypeId().getSQLTypeName(), 2, this.operator);
        }
        this.bindDateTimeArg(this.receiver, 3);
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(93));
        return this;
    }

    private ValueNode timestampDiffBind() throws StandardException {
        this.bindDateTimeArg(this.rightOperand, 2);
        this.bindDateTimeArg(this.receiver, 3);
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5));
        return this;
    }

    private void bindDateTimeArg(ValueNode arg, int argNumber) throws StandardException {
        if (!this.bindParameter(arg, 93) && !arg.getTypeId().isDateTimeTimeStampTypeId()) {
            throw StandardException.newException("42X45", arg.getTypeId().getSQLTypeName(), argNumber, this.operator);
        }
    }

    private boolean bindParameter(ValueNode arg, int jdbcType) throws StandardException {
        if (arg.requiresTypeFromContext() && arg.getTypeId() == null) {
            arg.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(jdbcType), true));
            return true;
        }
        return false;
    }

    ValueNode getReceiver() {
        return this.receiver;
    }

    private void throwBadType(String funcName, String type) throws StandardException {
        throw StandardException.newException("42X25", funcName, type);
    }

    protected void bindToBuiltIn() throws StandardException {
        if (this.receiver.getTypeId().userType()) {
            this.receiver = this.receiver.genSQLJavaSQLTree();
        }
        if (this.leftOperand.getTypeId().userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if (this.rightOperand != null && this.rightOperand.getTypeId().userType()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
    }

    private DataTypeDescriptor getVarcharDescriptor() {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true);
    }

    @Override
    boolean isSameNodeKind(ValueNode o) {
        return super.isSameNodeKind(o) && ((TernaryOperatorNode)o).kind == this.kind;
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeKind(o)) {
            TernaryOperatorNode other = (TernaryOperatorNode)o;
            return other.methodName.equals(this.methodName) && other.receiver.isEquivalent(this.receiver) && other.leftOperand.isEquivalent(this.leftOperand) && (this.rightOperand == null && other.rightOperand == null || other.rightOperand != null && other.rightOperand.isEquivalent(this.rightOperand));
        }
        return false;
    }
}

