/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class QueryPlanTest
extends BaseJDBCTestCase {
    public QueryPlanTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties sysprops = new Properties();
        sysprops.setProperty("derby.optimizer.noTimeout", "true");
        return new CleanDatabaseTestSetup((Test)new SystemPropertyTestSetup(TestConfiguration.embeddedSuite(QueryPlanTest.class), sysprops, true));
    }

    public void testDerby6011PreferUniqueIndex() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("CREATE TABLE jobs(id BIGINT PRIMARY KEY)");
        s.execute("CREATE TABLE jobqueue(docpriority FLOAT, id BIGINT PRIMARY KEY, priorityset BIGINT, docid CLOB NOT NULL, failcount BIGINT, status CHAR(1) NOT NULL, dochash VARCHAR(40) NOT NULL, isseed CHAR(1), checktime BIGINT, checkaction CHAR(1), jobid BIGINT NOT NULL CONSTRAINT jobs_fk REFERENCES jobs, failtime BIGINT)");
        s.execute("CREATE UNIQUE INDEX DOCHASH_JOBID_IDX ON jobqueue(dochash, jobid)");
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        PreparedStatement ps = this.prepareStatement("SELECT id,status,checktime FROM jobqueue WHERE dochash=? AND jobid=? FOR UPDATE");
        ps.setString(1, "");
        ps.setInt(2, 0);
        JDBC.assertEmpty(ps.executeQuery());
        this.assertIndex("JOBQUEUE", "DOCHASH_JOBID_IDX");
        s.execute("create table t1(a int not null, b int not null, c int not null, d int not null, e blob)");
        s.execute("create index idx_t1_a on t1(a)");
        s.execute("create unique index uidx_t1_a on t1(a)");
        ps = this.prepareStatement("select * from t1 where a = ?");
        ps.setInt(1, 1);
        JDBC.assertEmpty(ps.executeQuery());
        this.assertIndex("T1", "UIDX_T1_A");
        s.execute("drop index uidx_t1_a");
        s.execute("create index idx_t1_ab on t1(a,b)");
        s.execute("create unique index uidx_t1_ab on t1(a,b)");
        ps = this.prepareStatement("select * from t1 where a = ? and b = ?");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        JDBC.assertEmpty(ps.executeQuery());
        this.assertIndex("T1", "UIDX_T1_AB");
        s.execute("drop index uidx_t1_ab");
        s.execute("create index idx_t1_abc on t1(a,b,c)");
        s.execute("create unique index uidx_t1_abc on t1(a,b,c)");
        ps = this.prepareStatement("select * from t1 where a = ? and b = ? and c = ?");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        JDBC.assertEmpty(ps.executeQuery());
        this.assertIndex("T1", "UIDX_T1_ABC");
        s.execute("drop index uidx_t1_abc");
        s.execute("create unique index uidx_t1_abcd on t1(a,b,c,d)");
        ps = this.prepareStatement("select * from t1 where a = ? and b = ? and c = ? and d = ?");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        ps.setInt(4, 4);
        JDBC.assertEmpty(ps.executeQuery());
        this.assertIndex("T1", "UIDX_T1_ABCD");
        s.execute("create table t2(a varchar(200) not null, b varchar(200) not null, c varchar(200) not null)");
        s.execute("create unique index uidx_t2_ab on t1(a,b)");
        s.execute("create index idx_t2_abc on t2(a,b,c)");
        ps = this.prepareStatement("select * from t2 where a = ? and b = ? and c = ?");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        JDBC.assertEmpty(ps.executeQuery());
        this.assertIndex("T2", "IDX_T2_ABC");
    }

    private void assertIndex(String table, String index) throws SQLException {
        RuntimeStatisticsParser parser = SQLUtilities.getRuntimeStatisticsParser(this.createStatement());
        if (!parser.usedSpecificIndexForIndexScan(table, index)) {
            QueryPlanTest.fail((String)("Should have used index " + index + " when accessing table " + table + ". Actual plan:\n" + parser));
        }
    }
}

