/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public final class XMLXXETest
extends BaseJDBCTestCase {
    public XMLXXETest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("XML XXE Vulnerability tests\n");
        if (!XML.classpathMeetsXMLReqs()) {
            return suite;
        }
        String[] testFiles = new String[]{"functionTests/tests/lang/xmlOptimizerXXE1Payload.trace", "functionTests/tests/lang/xmlOptimizerXXE1.trace", "functionTests/tests/lang/xmlOptimizerXXE2.trace"};
        suite.addTest((Test)new SupportFilesSetup(TestConfiguration.defaultSuite(XMLXXETest.class), testFiles));
        return new LocaleTestSetup((Test)suite, Locale.US);
    }

    public void testDerby6807FileAccess() throws Exception {
        File password = null;
        password = new File("test6807.txt");
        PrintWriter writer = new PrintWriter("test6807.txt", "UTF-8");
        writer.print("HelloWorld");
        writer.close();
        String path = password.getAbsolutePath();
        Statement s = this.createStatement();
        s.execute("CREATE TABLE xml_data(xml_col XML)");
        String stmt = "INSERT INTO xml_data(xml_col) VALUES(XMLPARSE(DOCUMENT'<!DOCTYPE foo [<!ENTITY xxe SYSTEM \"file:" + path + "\" >]><yolo>&xxe;</yolo>'PRESERVE WHITESPACE))";
        s.execute(stmt);
        JDBC.assertSingleValueResultSet(s.executeQuery("SELECT XMLSERIALIZE(xml_col AS CLOB) FROM xml_data"), "<yolo/>");
        password.delete();
    }

    public void testDerby6807BillionLaughs() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("create table xml_billion_laughs( xml_col xml )");
        String xmlBillionLaughs = "insert into xml_billion_laughs( xml_col ) values( xmlparse(document '<!DOCTYPE lolz [ <!ENTITY lol \"lol\"> <!ELEMENT lolz (#PCDATA)> <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\"> <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\"> <!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\"> <!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\"> <!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\"> <!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\"> <!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\"> <!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\"> <!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">]><lolz>&lol9;</lolz>' PRESERVE WHITESPACE))";
        XMLXXETest.assertStatementError("2200M", st, xmlBillionLaughs);
    }

    public void testDerby6807FileAccessVTI() throws Exception {
        String VULNERABLE_XML = "xmlOptimizerXXE1.trace";
        URL traceURL = SupportFilesSetup.getReadOnlyURL(VULNERABLE_XML);
        Statement s = this.createStatement();
        s.execute("create function decorationURLChildOnly\n(\n    urlString varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    childTags varchar( 32672 )...\n)\nreturns table\n(\n        conglomerateName varchar( 36 ),\n        joinStrategy varchar( 200 ),\n        estimatedCost double,\n        estimatedRowCount varchar( 200 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTIFromURL'\n");
        s.execute("create view decorationURLChildOnly as\nselect * from table\n(\n    decorationURLChildOnly\n    (\n        '" + traceURL.toString() + "',\n        'decoration',\n        'decConglomerateName', 'decJoinStrategy',\n        'ceEstimatedCost', 'ceEstimatedRowCount'\n    )\n) v\n");
        ResultSet rs = s.executeQuery("select distinct conglomerateName, joinStrategy,                estimatedCost, estimatedRowCount\nfrom decorationURLChildOnly\nwhere conglomerateName like '%_A' and       estimatedCost is not null\norder by conglomerateName, joinStrategy,          estimatedCost, estimatedRowCount\n");
        XMLXXETest.assertTrue((boolean)rs.next());
        XMLXXETest.assertEquals((String)"null", (String)rs.getString(4).trim());
        XMLXXETest.assertFalse((boolean)rs.next());
    }

    public void testDerby6807BillionLaughsVTI() throws Exception {
        block2: {
            String VULNERABLE_XML = "xmlOptimizerXXE2.trace";
            URL traceURL = SupportFilesSetup.getReadOnlyURL(VULNERABLE_XML);
            Statement s = this.createStatement();
            s.execute("create function lolzURL\n(\n    urlString varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    childTags varchar( 32672 )...\n)\nreturns table\n(\n        lolz varchar( 32000 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTIFromURL'\n");
            s.execute("create view lolzURL as\nselect * from table\n(\n    lolzURL\n    (\n        '" + traceURL.toString() + "',\n        'lolz'\n    )\n) v\n");
            try {
                ResultSet rs = s.executeQuery("select lolz from lolzURL");
                XMLXXETest.assertTrue((boolean)rs.next());
                XMLXXETest.fail((String)"Expected SAXParseException");
            }
            catch (Throwable e) {
                if (e.getMessage().contains("entity expansions")) break block2;
                XMLXXETest.fail("Expected SAXParseException", e);
            }
        }
    }
}

