/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.tester;

import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.tester.TesterObject;

public class Tester1
extends TesterObject {
    public Tester1(String string) {
        super(string);
    }

    @Override
    public void startTesting() {
        this.connex = this.getConnection();
        if (this.connex == null) {
            NsTest.logger.println("FAIL: " + this.getThread_id() + " could not get the database connection");
            return;
        }
        try {
            this.connex.setAutoCommit(false);
        }
        catch (Exception exception) {
            NsTest.logger.println("FAIL: " + this.getThread_id() + "'s setAutoCommit() failed:");
            this.printException("setting AutoCommit", exception);
            return;
        }
        this.setIsolationLevel(1);
        for (int i = 0; i < NsTest.MAX_ITERATIONS; ++i) {
            int n = (int)(Math.random() * 100.0) % 4;
            switch (n) {
                case 0: {
                    int n2;
                    try {
                        n2 = this.doSelectOperation(NsTest.MAX_LOW_STRESS_ROWS);
                        NsTest.logger.println(this.getThread_id() + " selected " + n2 + " rows");
                        break;
                    }
                    catch (Exception exception) {
                        NsTest.logger.println("--> Isolation Level is TRANSACTION_READ_UNCOMMITTED, hence SHOULD NOT FAIL ********* doSelect in thread " + this.getThread_id() + " threw " + exception);
                        this.printException("doSelectOperation()", exception);
                        if (NsTest.justCountErrors()) {
                            NsTest.printException(Tester1.class.getName(), exception);
                        } else {
                            exception.printStackTrace(NsTest.logger);
                        }
                        if (!NsTest.deadConnection(exception)) break;
                        return;
                    }
                }
                case 1: 
                case 2: 
                case 3: {
                    int n2;
                    for (n2 = 0; n2 < NsTest.MAX_LOW_STRESS_ROWS; ++n2) {
                        this.doIUDOperation();
                        if (!this.deadConnection()) continue;
                        return;
                    }
                    break;
                }
            }
            try {
                this.connex.commit();
                continue;
            }
            catch (Exception exception) {
                NsTest.logger.println("FAIL: " + this.getThread_id() + "'s commit() failed:");
                this.printException("committing Xn in Tester1", exception);
                return;
            }
        }
        this.closeConnection();
        NsTest.logger.println("Thread " + this.getThread_id() + " is now terminating");
    }
}

