/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.planexporter;

import java.io.IOException;
import java.io.Writer;
import org.apache.derby.impl.tools.planexporter.AccessDatabase;

public class CreateXMLFile {
    AccessDatabase access;

    public CreateXMLFile(AccessDatabase access) {
        this.access = access;
    }

    public void writeTheXMLFile(String stmt, String time, Writer out, String xsl_sheet_name) throws IOException {
        String defaultXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        Object embedXSL = "";
        if (xsl_sheet_name != null) {
            embedXSL = "<?xml-stylesheet type=\"text/xsl\" href=\"" + xsl_sheet_name + "\"?>\n";
        }
        String comment = "<!-- Apache Derby Query Explainer (DERBY-4587)-->\n";
        String parentTagStart = "<plan>\n";
        String parentTagEnd = "</plan>\n";
        String childTagStart = "<details>\n";
        String childTagEnd = "</details>\n";
        out.write(defaultXML);
        out.write((String)embedXSL);
        out.write(comment);
        out.write(parentTagStart);
        out.write(this.access.indent(0));
        out.write(stmt);
        out.write(this.access.indent(0));
        out.write(time);
        out.write(this.access.indent(0));
        out.write(this.access.stmtID());
        out.write(this.access.indent(0));
        out.write(childTagStart);
        out.write(this.access.getXmlString());
        out.write(this.access.indent(0));
        out.write(childTagEnd);
        out.write(parentTagEnd);
    }
}

