/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.BufferPositionInvariantsException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PositionalTest {
    @Test
    public void checkLimits() {
        Buffer buf = Memory.wrap((byte[])new byte[100]).asBuffer();
        buf.setStartPositionEnd(40L, 45L, 50L);
        buf.setStartPositionEnd(0L, 0L, 100L);
        try {
            buf.setStartPositionEnd(0L, 0L, 101L);
            Assert.fail();
        }
        catch (BufferPositionInvariantsException bufferPositionInvariantsException) {
            // empty catch block
        }
    }

    @Test
    public void checkLimitsAndCheck() {
        Buffer buf = Memory.wrap((byte[])new byte[100]).asBuffer();
        buf.setStartPositionEnd(40L, 45L, 50L);
        buf.setStartPositionEnd(0L, 0L, 100L);
        try {
            buf.setStartPositionEnd(0L, 0L, 101L);
            Assert.fail();
        }
        catch (BufferPositionInvariantsException bufferPositionInvariantsException) {
            // empty catch block
        }
        buf.setPosition(100L);
        try {
            buf.setPosition(101L);
            Assert.fail();
        }
        catch (BufferPositionInvariantsException bufferPositionInvariantsException) {
            // empty catch block
        }
        buf.setPosition(99L);
        buf.incrementPosition(1L);
        try {
            buf.incrementPosition(1L);
            Assert.fail();
        }
        catch (BufferPositionInvariantsException bufferPositionInvariantsException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void checkCheckValid() {
        Buffer buf;
        try (WritableMemory wmem = WritableMemory.allocateDirect((long)100L);){
            buf = wmem.asBuffer();
        }
        Memory mem = buf.asMemory();
    }
}

