/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.annotations.Test;

public class ExampleMemoryRequestServerTest {
    @Test
    public void checkExampleMemoryRequestServer1() {
        DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer(true, true);
        long workingMemBytes = 8L;
        WritableMemory workingMem = WritableMemory.allocateDirect((long)workingMemBytes, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr);
        MemoryHungryClient client = new MemoryHungryClient(workingMem);
        client.process();
    }

    @Test
    public void printlnTest() {
        ExampleMemoryRequestServerTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
    }

    static class MemoryHungryClient {
        WritableMemory workingMem;
        MemoryRequestServer memReqSvr;

        MemoryHungryClient(WritableMemory workingMemory) {
            this.workingMem = workingMemory;
            this.memReqSvr = workingMemory.getMemoryRequestServer();
        }

        void process() {
            int oldWorkingCap = 0;
            int newWorkingCap = (int)this.workingMem.getCapacity();
            for (byte itr = 1; itr <= 4; itr = (byte)(itr + 1)) {
                this.workingMem.fill((long)oldWorkingCap, (long)(newWorkingCap - oldWorkingCap), itr);
                oldWorkingCap = newWorkingCap;
                newWorkingCap = 2 * oldWorkingCap;
                WritableMemory newMem = this.memReqSvr.request(this.workingMem, (long)newWorkingCap);
                this.memReqSvr.requestClose(this.workingMem, newMem);
                this.workingMem = newMem;
            }
            this.workingMem.close();
        }
    }
}

