/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.Prim;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.StepBoolean;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceTest {
    @Test
    public void checkPrimOffset() {
        int off = (int)Prim.BYTE.off();
        Assert.assertTrue((off > 0 ? 1 : 0) != 0);
    }

    @Test
    public void checkIsSameResource() {
        WritableBuffer wbuf;
        WritableMemory wmem;
        WritableMemory mem = wmem = WritableMemory.allocate((int)16);
        Assert.assertFalse((boolean)wmem.isSameResource(null));
        Assert.assertTrue((boolean)wmem.isSameResource((Resource)mem));
        WritableBuffer buf = wbuf = wmem.asWritableBuffer();
        Assert.assertFalse((boolean)wbuf.isSameResource(null));
        Assert.assertTrue((boolean)wbuf.isSameResource((Resource)buf));
    }

    @Test
    public void checkNotEqualTo() {
        byte[] arr1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        Memory mem1 = Memory.wrap((byte[])arr1);
        byte[] arr2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 9};
        Memory mem2 = Memory.wrap((byte[])arr2);
        Assert.assertFalse((boolean)mem1.equalTo((Resource)mem2));
    }

    @Test
    public void checkStepBoolean() {
        ResourceTest.checkStepBoolean(true);
        ResourceTest.checkStepBoolean(false);
    }

    private static void checkStepBoolean(boolean initialState) {
        StepBoolean step = new StepBoolean(initialState);
        Assert.assertTrue((step.get() == initialState ? 1 : 0) != 0);
        step.change();
        Assert.assertTrue((boolean)step.hasChanged());
        Assert.assertTrue((step.get() != initialState ? 1 : 0) != 0);
        step.change();
        Assert.assertTrue((step.get() != initialState ? 1 : 0) != 0);
        Assert.assertTrue((boolean)step.hasChanged());
    }

    @Test
    public void checkPrim() {
        Assert.assertEquals((long)Prim.DOUBLE.scale(), (long)8L);
    }

    @Test
    public void checkIsByteOrderCompatible() {
        WritableMemory wmem = WritableMemory.allocate((int)8);
        Assert.assertTrue((boolean)wmem.isByteOrderCompatible(ByteOrder.nativeOrder()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkByteOrderNull() {
        Util.isNativeByteOrder(null);
        Assert.fail();
    }

    @Test
    public void checkIsNativeByteOrder() {
        Assert.assertTrue((boolean)Util.isNativeByteOrder((ByteOrder)ByteOrder.nativeOrder()));
        try {
            Util.isNativeByteOrder(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkXxHash64() {
        WritableMemory mem = WritableMemory.allocate((int)8);
        long out = mem.xxHash64(mem.getLong(0L), 1L);
        Assert.assertTrue((out != 0L ? 1 : 0) != 0);
    }

    @Test
    public void checkTypeDecode() {
        for (int i = 0; i < 128; ++i) {
            ResourceImpl.typeDecode((int)i);
        }
    }

    @Test
    public void printlnTest() {
        ResourceTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

