/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AllocateDirectMemoryTest {
    @Test(expectedExceptions={IllegalStateException.class})
    public void simpleAllocateDirect() {
        int longs = 32;
        try (WritableMemory wMem = WritableMemory.allocateDirect((long)(longs << 3));){
            for (int i = 0; i < longs; ++i) {
                wMem.putLong((long)(i << 3), (long)i);
                Assert.assertEquals((long)wMem.getLong((long)(i << 3)), (long)i);
            }
            ((ResourceImpl)wMem).checkValid();
            wMem.close();
        }
    }

    @Test
    public void checkDefaultMemoryRequestServer() {
        int longs1 = 32;
        int bytes1 = longs1 << 3;
        WritableMemory origWmem = WritableMemory.allocateDirect((long)bytes1);
        for (int i = 0; i < longs1; ++i) {
            origWmem.putLong((long)(i << 3), (long)i);
            Assert.assertEquals((long)origWmem.getLong((long)(i << 3)), (long)i);
        }
        AllocateDirectMemoryTest.println(origWmem.toString("Test", 0L, 256, true));
        int longs2 = 64;
        int bytes2 = longs2 << 3;
        origWmem.setMemoryRequestServer(Resource.defaultMemReqSvr);
        MemoryRequestServer myMemReqSvr = origWmem.getMemoryRequestServer();
        WritableMemory newWmem = myMemReqSvr.request(origWmem, (long)bytes2);
        Assert.assertTrue((boolean)newWmem.isHeap());
        for (int i = 0; i < longs2; ++i) {
            newWmem.putLong((long)(i << 3), (long)i);
            Assert.assertEquals((long)newWmem.getLong((long)(i << 3)), (long)i);
        }
        if (origWmem.isCloseable()) {
            myMemReqSvr.requestClose(origWmem, newWmem);
        }
    }

    @Test
    public void checkNonNativeDirect() {
        try (WritableMemory wmem = WritableMemory.allocateDirect((long)128L, (ByteOrder)Util.NON_NATIVE_BYTE_ORDER, null);){
            wmem.putChar(0L, '\u0001');
            Assert.assertEquals((byte)wmem.getByte(1L), (byte)1);
        }
    }

    @Test
    public void checkExplicitClose() {
        long cap = 128L;
        WritableMemory wMem = WritableMemory.allocateDirect((long)128L);
        Assert.assertTrue((boolean)wMem.isAlive());
        wMem.close();
        Assert.assertFalse((boolean)wMem.isAlive());
    }

    @Test
    public void printlnTest() {
        AllocateDirectMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

