/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class WritableDirectCopyTest {
    @Test
    public void checkCopyWithinNativeSmall() throws Exception {
        int memCapacity = 64;
        int half = memCapacity / 2;
        try (WritableHandle wrh = WritableMemory.allocateDirect((long)memCapacity);){
            int i;
            WritableMemory mem = wrh.getWritable();
            mem.clear();
            for (i = 0; i < half; ++i) {
                mem.putByte((long)i, (byte)i);
            }
            mem.copyTo(0L, mem, (long)half, (long)half);
            for (i = 0; i < half; ++i) {
                Assert.assertEquals((byte)mem.getByte((long)(i + half)), (byte)((byte)i));
            }
        }
    }

    @Test
    public void checkCopyWithinNativeLarge() throws Exception {
        int memCapacity = 0x200040;
        int memCapLongs = memCapacity / 8;
        int halfBytes = memCapacity / 2;
        int halfLongs = memCapLongs / 2;
        try (WritableHandle wrh = WritableMemory.allocateDirect((long)memCapacity);){
            int i;
            WritableMemory mem = wrh.getWritable();
            mem.clear();
            for (i = 0; i < halfLongs; ++i) {
                mem.putLong((long)(i * 8), (long)i);
            }
            mem.copyTo(0L, mem, (long)halfBytes, (long)halfBytes);
            for (i = 0; i < halfLongs; ++i) {
                Assert.assertEquals((long)mem.getLong((long)((i + halfLongs) * 8)), (long)i);
            }
        }
    }

    @Test
    public void checkCopyWithinNativeOverlap() throws Exception {
        int memCapacity = 64;
        try (WritableHandle wrh = WritableMemory.allocateDirect((long)memCapacity);){
            WritableMemory mem = wrh.getWritable();
            mem.clear();
            for (int i = 0; i < memCapacity / 2; ++i) {
                mem.putByte((long)i, (byte)i);
            }
            mem.copyTo(0L, mem, (long)(memCapacity / 4), (long)(memCapacity / 2));
        }
    }

    @Test
    public void checkCopyWithinNativeSrcBound() throws Exception {
        int memCapacity = 64;
        try (WritableHandle wrh = WritableMemory.allocateDirect((long)memCapacity);){
            WritableMemory mem = wrh.getWritable();
            mem.copyTo(32L, mem, 32L, 33L);
            Assert.fail((String)"Did Not Catch Assertion Error: source bound");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCopyWithinNativeDstBound() throws Exception {
        int memCapacity = 64;
        try (WritableHandle wrh = WritableMemory.allocateDirect((long)memCapacity);){
            WritableMemory mem = wrh.getWritable();
            mem.copyTo(0L, mem, 32L, 33L);
            Assert.fail((String)"Did Not Catch Assertion Error: dst bound");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCopyCrossNativeSmall() throws Exception {
        int memCapacity = 64;
        try (WritableHandle wrh1 = WritableMemory.allocateDirect((long)memCapacity);
             WritableHandle wrh2 = WritableMemory.allocateDirect((long)memCapacity);){
            int i;
            WritableMemory mem1 = wrh1.getWritable();
            WritableMemory mem2 = wrh2.getWritable();
            for (i = 0; i < memCapacity; ++i) {
                mem1.putByte((long)i, (byte)i);
            }
            mem2.clear();
            mem1.copyTo(0L, mem2, 0L, (long)memCapacity);
            for (i = 0; i < memCapacity; ++i) {
                Assert.assertEquals((byte)mem2.getByte((long)i), (byte)((byte)i));
            }
            wrh1.close();
            wrh2.close();
        }
    }

    @Test
    public void checkCopyCrossNativeLarge() throws Exception {
        int memCapacity = 0x200040;
        int memCapLongs = memCapacity / 8;
        try (WritableHandle wrh1 = WritableMemory.allocateDirect((long)memCapacity);
             WritableHandle wrh2 = WritableMemory.allocateDirect((long)memCapacity);){
            int i;
            WritableMemory mem1 = wrh1.getWritable();
            WritableMemory mem2 = wrh2.getWritable();
            for (i = 0; i < memCapLongs; ++i) {
                mem1.putLong((long)(i * 8), (long)i);
            }
            mem2.clear();
            mem1.copyTo(0L, mem2, 0L, (long)memCapacity);
            for (i = 0; i < memCapLongs; ++i) {
                Assert.assertEquals((long)mem2.getLong((long)(i * 8)), (long)i);
            }
        }
    }

    @Test
    public void checkCopyCrossNativeAndByteArray() throws Exception {
        int memCapacity = 64;
        try (WritableHandle wrh1 = WritableMemory.allocateDirect((long)memCapacity);){
            WritableMemory mem1 = wrh1.getWritable();
            int i = 0;
            while ((long)i < mem1.getCapacity()) {
                mem1.putByte((long)i, (byte)i);
                ++i;
            }
            WritableMemory mem2 = WritableMemory.allocate((int)memCapacity);
            mem1.copyTo(8L, mem2, 16L, 16L);
            for (int i2 = 0; i2 < 16; ++i2) {
                Assert.assertEquals((byte)mem1.getByte((long)(8 + i2)), (byte)mem2.getByte((long)(16 + i2)));
            }
        }
    }

    @Test
    public void checkCopyCrossRegionsSameNative() throws Exception {
        int memCapacity = 128;
        try (WritableHandle wrh1 = WritableMemory.allocateDirect((long)memCapacity);){
            WritableMemory mem1 = wrh1.getWritable();
            int i = 0;
            while ((long)i < mem1.getCapacity()) {
                mem1.putByte((long)i, (byte)i);
                ++i;
            }
            Memory reg1 = mem1.region(8L, 16L);
            WritableMemory reg2 = mem1.writableRegion(24L, 16L);
            reg1.copyTo(0L, reg2, 0L, 16L);
            for (int i2 = 0; i2 < 16; ++i2) {
                Assert.assertEquals((byte)reg1.getByte((long)i2), (byte)reg2.getByte((long)i2));
                Assert.assertEquals((byte)mem1.getByte((long)(8 + i2)), (byte)mem1.getByte((long)(24 + i2)));
            }
        }
    }

    @Test
    public void checkCopyCrossNativeArrayAndHierarchicalRegions() throws Exception {
        int memCapacity = 64;
        try (WritableHandle wrh1 = WritableMemory.allocateDirect((long)memCapacity);){
            WritableMemory mem1 = wrh1.getWritable();
            int i = 0;
            while ((long)i < mem1.getCapacity()) {
                mem1.putByte((long)i, (byte)i);
                ++i;
            }
            WritableMemory mem2 = WritableMemory.allocate((int)memCapacity);
            Memory reg1 = mem1.region(8L, 32L);
            Memory reg1B = reg1.region(8L, 16L);
            WritableMemory reg2 = mem2.writableRegion(32L, 16L);
            reg1B.copyTo(0L, reg2, 0L, 16L);
            int i2 = 32;
            int j = 16;
            while (i2 < 40) {
                Assert.assertEquals((int)mem2.getByte((long)i2), (int)j);
                ++i2;
                ++j;
            }
        }
    }

    @Test
    public void printlnTest() {
        WritableDirectCopyTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

